/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.caption.endpoint;

import java.io.StringWriter;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.caption.api.CaptionService;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.XmlSafeParser;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/")
@RestService(name="caption", title="Caption Service", abstractText="This service enables conversion from one caption format to another.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={CaptionServiceRestEndpoint.class}, property={"service.description=Caption REST Endpoint", "opencast.service.type=org.opencastproject.caption", "opencast.service.path=/caption", "opencast.service.jobproducer=true"})
public class CaptionServiceRestEndpoint
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(CaptionServiceRestEndpoint.class);
    protected CaptionService service;
    protected ServiceRegistry serviceRegistry = null;

    @Activate
    public void activate(ComponentContext cc) {
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetCaptionService")
    protected void setCaptionService(CaptionService service) {
        this.service = service;
    }

    protected void unsetCaptionService(CaptionService service) {
        this.service = null;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @POST
    @Path(value="convert")
    @Produces(value={"text/xml"})
    @RestQuery(name="convert", description="Convert captions from one format to another.", restParameters={@RestParameter(description="Captions to be converted.", isRequired=true, name="captions", type=RestParameter.Type.TEXT), @RestParameter(description="Caption input format (for example: dfxp, subrip,...).", isRequired=false, defaultValue="dfxp", name="input", type=RestParameter.Type.STRING), @RestParameter(description="Caption output format (for example: dfxp, subrip,...).", isRequired=false, defaultValue="subrip", name="output", type=RestParameter.Type.STRING), @RestParameter(description="Caption language (for those formats that store such information).", isRequired=false, defaultValue="en", name="language", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="OK, Conversion successfully completed.", responseCode=200)}, returnDescription="The converted captions file")
    public Response convert(@FormParam(value="input") String inputType, @FormParam(value="output") String outputType, @FormParam(value="captions") String catalogAsXml, @FormParam(value="language") String lang) {
        MediaPackageElement element;
        try {
            element = MediaPackageElementParser.getFromXml((String)catalogAsXml);
            if (!Catalog.TYPE.equals((Object)element.getElementType())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Captions must be of type catalog.").build();
            }
        }
        catch (Exception e) {
            logger.info("Unable to parse serialized captions");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Job job = StringUtils.isNotBlank((CharSequence)lang) ? this.service.convert((MediaPackageElement)((Catalog)element), inputType, outputType, lang) : this.service.convert((MediaPackageElement)((Catalog)element), inputType, outputType);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (Exception e) {
            logger.error("Unable to convert captions: {}", (Object)e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="languages")
    @Produces(value={"text/xml"})
    @RestQuery(name="languages", description="Get information about languages in caption catalog (if such information is available).", restParameters={@RestParameter(description="Captions to be examined.", isRequired=true, name="captions", type=RestParameter.Type.TEXT), @RestParameter(description="Caption input format (for example: dfxp, subrip,...).", isRequired=false, defaultValue="dfxp", name="input", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="OK, information was extracted and retrieved", responseCode=200)}, returnDescription="Returned information about languages present in captions.")
    public Response languages(@FormParam(value="input") String inputType, @FormParam(value="captions") String catalogAsXml) {
        try {
            MediaPackageElement element = MediaPackageElementParser.getFromXml((String)catalogAsXml);
            if (!Catalog.TYPE.equals((Object)element.getElementType())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Captions must be of type catalog").build();
            }
            String[] languageArray = this.service.getLanguageList((MediaPackageElement)((Catalog)element), inputType);
            DocumentBuilder docBuilder = XmlSafeParser.newDocumentBuilderFactory().newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("languages");
            root.setAttribute("type", inputType);
            root.setAttribute("url", element.getURI().toString());
            for (String lang : languageArray) {
                Element language = doc.createElement("language");
                language.appendChild(doc.createTextNode(lang));
                root.appendChild(language);
            }
            DOMSource domSource = new DOMSource(root);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer transformer = XmlSafeParser.newTransformerFactory().newTransformer();
            transformer.transform(domSource, result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)writer.toString()).build();
        }
        catch (Exception e) {
            logger.error("Unable to parse captions: {}", (Object)e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    public JobProducer getService() {
        if (this.service instanceof JobProducer) {
            return (JobProducer)this.service;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

