/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElixirClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElixirClientCodegen.class);
    protected String apiVersion = "1.0.0";
    protected String moduleName;
    protected static final String defaultModuleName = "OpenAPI.Client";
    protected static final String defaultPackageName = "openapi_client";
    String supportedElixirVersion = "1.6";
    List<String> extraApplications = Arrays.asList(":logger");
    List<String> deps = Arrays.asList("{:tesla, \"~> 1.2\"}", "{:poison, \"~> 3.0\"}");

    public ElixirClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Implicit, SecurityFeature.BasicAuth)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.outputFolder = "generated-code/elixir";
        this.modelTemplateFiles.put("model.mustache", ".ex");
        this.apiTemplateFiles.put("api.mustache", ".ex");
        this.templateDir = "elixir";
        this.reservedWords = new HashSet<String>(Arrays.asList("nil", "true", "false", "__MODULE__", "__FILE__", "__DIR__", "__ENV__", "__CALLER__"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.supportingFiles.add(new SupportingFile("README.md.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("config.exs.mustache", "config", "config.exs"));
        this.supportingFiles.add(new SupportingFile("mix.exs.mustache", "", "mix.exs"));
        this.supportingFiles.add(new SupportingFile("test_helper.exs.mustache", "test", "test_helper.exs"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Integer", "Float", "Boolean", "String", "List", "Atom", "Map", "Tuple", "PID", "DateTime"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("number", "Float");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Float");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("byte", "Integer");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("Date", "DateTime");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("file", "String");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("object", "Map");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("URI", "String");
        this.cliOptions.add(new CliOption("invokerPackage", "The main namespace to use for all classes. e.g. Yay.Pets"));
        this.cliOptions.add(new CliOption("licenseHeader", "The license header to prepend to the top of all source files."));
        this.cliOptions.add(new CliOption("packageName", "Elixir package name (convention: lowercase)."));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "elixir";
    }

    @Override
    public String getHelp() {
        return "Generates an elixir client library (alpha).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.additionalProperties.put("supportedElixirVersion", this.supportedElixirVersion);
        this.additionalProperties.put("extraApplications", this.join(",", this.extraApplications));
        this.additionalProperties.put("deps", this.deps);
        this.additionalProperties.put("underscored", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                writer.write(ElixirClientCodegen.this.underscored(fragment.execute()));
            }
        });
        this.additionalProperties.put("modulized", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                writer.write(ElixirClientCodegen.this.modulized(fragment.execute()));
            }
        });
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setModuleName((String)this.additionalProperties.get("invokerPackage"));
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Info info = openAPI.getInfo();
        if (this.moduleName == null) {
            if (info.getTitle() != null) {
                this.setModuleName(this.modulized(this.escapeText(info.getTitle())));
            } else {
                this.setModuleName(defaultModuleName);
            }
        }
        this.additionalProperties.put("moduleName", this.moduleName);
        if (!this.additionalProperties.containsKey("packageName")) {
            this.additionalProperties.put("packageName", this.underscored(this.moduleName));
        }
        this.supportingFiles.add(new SupportingFile("connection.ex.mustache", this.sourceFolder(), "connection.ex"));
        this.supportingFiles.add(new SupportingFile("request_builder.ex.mustache", this.sourceFolder(), "request_builder.ex"));
        this.supportingFiles.add(new SupportingFile("deserializer.ex.mustache", this.sourceFolder(), "deserializer.ex"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)super.postProcessOperationsWithModels(objs, allModels).get("operations");
        List os = (List)operations.get("operation");
        ArrayList<ExtendedCodegenOperation> newOs = new ArrayList<ExtendedCodegenOperation>();
        Pattern pattern = Pattern.compile("\\{([^\\}]+)\\}([^\\{]*)");
        for (CodegenOperation o : os) {
            Map firstType;
            ArrayList<String> pathTemplateNames = new ArrayList<String>();
            Matcher matcher = pattern.matcher(o.path);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String pathTemplateName = matcher.group(1);
                matcher.appendReplacement(buffer, "#{" + StringUtils.underscore(pathTemplateName) + "}$2");
                pathTemplateNames.add(pathTemplateName);
            }
            ExtendedCodegenOperation eco = new ExtendedCodegenOperation(o);
            if (buffer.toString().isEmpty()) {
                eco.setReplacedPathName(o.path);
            } else {
                eco.setReplacedPathName(buffer.toString());
            }
            eco.setPathTemplateNames(pathTemplateNames);
            if (eco.hasConsumes == Boolean.TRUE && (firstType = (Map)eco.consumes.get(0)) != null && "multipart/form-data".equals(firstType.get("mediaType"))) {
                eco.isMultipart = Boolean.TRUE;
            }
            newOs.add(eco);
        }
        operations.put("operation", newOs);
        return objs;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel cm = super.fromModel(name, model);
        return new ExtendedCodegenModel(cm);
    }

    @Override
    public CodegenResponse fromResponse(String responseCode, ApiResponse resp) {
        return new ExtendedCodegenResponse(super.fromResponse(responseCode, resp));
    }

    String join(CharSequence charSequence, Iterable<String> iterable) {
        StringBuilder buf = new StringBuilder();
        for (String str : iterable) {
            if (0 < buf.length()) {
                buf.append(charSequence);
            }
            buf.append(str);
        }
        return buf.toString();
    }

    private String underscored(String words) {
        ArrayList<String> underscoredWords = new ArrayList<String>();
        for (String word : words.split(" ")) {
            underscoredWords.add(StringUtils.underscore(word));
        }
        return this.join("_", underscoredWords);
    }

    private String modulized(String words) {
        ArrayList<String> modulizedWords = new ArrayList<String>();
        for (String word : words.split(" ")) {
            modulizedWords.add(StringUtils.camelize(word));
        }
        return this.join("", modulizedWords);
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    private String sourceFolder() {
        ArrayList<String> underscoredWords = new ArrayList<String>();
        for (String word : this.moduleName.split("\\.")) {
            underscoredWords.add(StringUtils.underscore(word));
        }
        return ("lib/" + this.join("/", underscoredWords)).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder() + File.separator + "model";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder() + File.separator + "api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "Default";
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name);
    }

    @Override
    public String toModelName(String name) {
        return StringUtils.camelize(this.toModelFilename(name));
    }

    @Override
    public String toModelFilename(String name) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        return StringUtils.underscore(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.underscore(this.sanitizeName("call_" + operationId)));
            return StringUtils.underscore(this.sanitizeName("call_" + operationId));
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return StringUtils.underscore(this.sanitizeName(operationId));
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return "%{optional(String.t) => " + this.getTypeDeclaration(inner) + "}";
        }
        if (ModelUtils.isPasswordSchema(p)) {
            return "String.t";
        }
        if (ModelUtils.isEmailSchema(p)) {
            return "String.t";
        }
        if (ModelUtils.isByteArraySchema(p)) {
            return "binary()";
        }
        if (ModelUtils.isUUIDSchema(p)) {
            return "String.t";
        }
        if (ModelUtils.isDateSchema(p)) {
            return "Date.t";
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return "DateTime.t";
        }
        if (ModelUtils.isObjectSchema(p)) {
            return super.getTypeDeclaration(p);
        }
        if (ModelUtils.isIntegerSchema(p)) {
            return "integer()";
        }
        if (ModelUtils.isNumberSchema(p)) {
            return "float()";
        }
        if (ModelUtils.isBinarySchema(p) || ModelUtils.isFileSchema(p)) {
            return "String.t";
        }
        if (ModelUtils.isBooleanSchema(p)) {
            return "boolean()";
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)p.get$ref())) {
            return super.getTypeDeclaration(p);
        }
        if (ModelUtils.isFileSchema(p)) {
            return "String.t";
        }
        if (ModelUtils.isStringSchema(p)) {
            return "String.t";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    class ExtendedCodegenModel
    extends CodegenModel {
        public boolean hasImports;

        public ExtendedCodegenModel(CodegenModel cm) {
            this.parent = cm.parent;
            this.parentSchema = cm.parentSchema;
            this.parentModel = cm.parentModel;
            this.interfaceModels = cm.interfaceModels;
            this.children = cm.children;
            this.name = cm.name;
            this.classname = cm.classname;
            this.title = cm.title;
            this.description = cm.description;
            this.classVarName = cm.classVarName;
            this.modelJson = cm.modelJson;
            this.dataType = cm.dataType;
            this.xmlPrefix = cm.xmlPrefix;
            this.xmlNamespace = cm.xmlNamespace;
            this.xmlName = cm.xmlName;
            this.classFilename = cm.classFilename;
            this.unescapedDescription = cm.unescapedDescription;
            this.discriminator = cm.discriminator;
            this.defaultValue = cm.defaultValue;
            this.arrayModelType = cm.arrayModelType;
            this.isAlias = cm.isAlias;
            this.vars = cm.vars;
            this.requiredVars = cm.requiredVars;
            this.optionalVars = cm.optionalVars;
            this.readOnlyVars = cm.readOnlyVars;
            this.readWriteVars = cm.readWriteVars;
            this.allVars = cm.allVars;
            this.parentVars = cm.parentVars;
            this.allowableValues = cm.allowableValues;
            this.mandatory = cm.mandatory;
            this.allMandatory = cm.allMandatory;
            this.imports = cm.imports;
            this.hasVars = cm.hasVars;
            this.emptyVars = cm.emptyVars;
            this.hasMoreModels = cm.hasMoreModels;
            this.hasEnums = cm.hasEnums;
            this.isEnum = cm.isEnum;
            this.hasRequired = cm.hasRequired;
            this.hasOptional = cm.hasOptional;
            this.isArray = cm.isArray;
            this.hasChildren = cm.hasChildren;
            this.hasOnlyReadOnly = cm.hasOnlyReadOnly;
            this.externalDocumentation = cm.externalDocumentation;
            this.vendorExtensions = cm.vendorExtensions;
            this.additionalPropertiesType = cm.additionalPropertiesType;
            this.hasImports = !this.imports.isEmpty();
        }

        public boolean hasComplexVars() {
            for (CodegenProperty p : this.vars) {
                if (p.isPrimitiveType) continue;
                return true;
            }
            return false;
        }
    }

    class ExtendedCodegenOperation
    extends CodegenOperation {
        private List<String> pathTemplateNames = new ArrayList<String>();
        private String replacedPathName;

        public ExtendedCodegenOperation(CodegenOperation o) {
            this.responseHeaders.addAll(o.responseHeaders);
            this.hasAuthMethods = o.hasAuthMethods;
            this.hasConsumes = o.hasConsumes;
            this.hasProduces = o.hasProduces;
            this.hasParams = o.hasParams;
            this.hasOptionalParams = o.hasOptionalParams;
            this.returnTypeIsPrimitive = o.returnTypeIsPrimitive;
            this.returnSimpleType = o.returnSimpleType;
            this.subresourceOperation = o.subresourceOperation;
            this.isMap = o.isMap;
            this.isArray = o.isArray;
            this.isMultipart = o.isMultipart;
            this.isResponseBinary = o.isResponseBinary;
            this.hasReference = o.hasReference;
            this.isRestfulIndex = o.isRestfulIndex;
            this.isRestfulShow = o.isRestfulShow;
            this.isRestfulCreate = o.isRestfulCreate;
            this.isRestfulUpdate = o.isRestfulUpdate;
            this.isRestfulDestroy = o.isRestfulDestroy;
            this.isRestful = o.isRestful;
            this.path = o.path;
            this.operationId = o.operationId;
            this.returnType = o.returnType;
            this.httpMethod = o.httpMethod;
            this.returnBaseType = o.returnBaseType;
            this.returnContainer = o.returnContainer;
            this.summary = o.summary;
            this.unescapedNotes = o.unescapedNotes;
            this.notes = o.notes;
            this.baseName = o.baseName;
            this.defaultResponse = o.defaultResponse;
            this.discriminator = o.discriminator;
            this.consumes = o.consumes;
            this.produces = o.produces;
            this.bodyParam = o.bodyParam;
            this.allParams = o.allParams;
            this.bodyParams = o.bodyParams;
            this.pathParams = o.pathParams;
            this.queryParams = o.queryParams;
            this.headerParams = o.headerParams;
            this.formParams = o.formParams;
            this.requiredParams = o.requiredParams;
            this.optionalParams = o.optionalParams;
            this.authMethods = o.authMethods;
            this.tags = o.tags;
            this.responses = o.responses;
            this.imports = o.imports;
            this.examples = o.examples;
            this.externalDocs = o.externalDocs;
            this.vendorExtensions = o.vendorExtensions;
            this.nickname = o.nickname;
            this.operationIdLowerCase = o.operationIdLowerCase;
            this.operationIdCamelCase = o.operationIdCamelCase;
        }

        public List<String> getPathTemplateNames() {
            return this.pathTemplateNames;
        }

        public void setPathTemplateNames(List<String> pathTemplateNames) {
            this.pathTemplateNames = pathTemplateNames;
        }

        public String getReplacedPathName() {
            return this.replacedPathName;
        }

        public void setReplacedPathName(String replacedPathName) {
            this.replacedPathName = replacedPathName;
        }

        public String typespec() {
            StringBuilder sb = new StringBuilder("@spec ");
            sb.append(StringUtils.underscore(this.operationId));
            sb.append("(Tesla.Env.client, ");
            for (CodegenParameter param : this.allParams) {
                if (!param.required) continue;
                this.buildTypespec(param, sb);
                sb.append(", ");
            }
            sb.append("keyword()) :: ");
            HashSet<String> uniqueResponseTypes = new HashSet<String>();
            for (CodegenResponse response : this.responses) {
                ExtendedCodegenResponse exResponse = (ExtendedCodegenResponse)response;
                StringBuilder returnEntry = new StringBuilder("");
                if (exResponse.baseType == null) {
                    returnEntry.append("nil");
                } else if (exResponse.simpleType) {
                    if (!exResponse.primitiveType) {
                        returnEntry.append(ElixirClientCodegen.this.moduleName);
                        returnEntry.append(".Model.");
                    }
                    returnEntry.append(exResponse.baseType);
                    returnEntry.append(".t");
                } else if (exResponse.containerType == null) {
                    returnEntry.append(this.returnBaseType);
                    returnEntry.append(".t");
                } else if (exResponse.containerType.equals("array") || exResponse.containerType.equals("set")) {
                    returnEntry.append("list(");
                    if (!exResponse.primitiveType) {
                        returnEntry.append(ElixirClientCodegen.this.moduleName);
                        returnEntry.append(".Model.");
                    }
                    returnEntry.append(exResponse.baseType);
                    returnEntry.append(".t)");
                } else if (exResponse.containerType.equals("map")) {
                    returnEntry.append("map()");
                }
                uniqueResponseTypes.add(returnEntry.toString());
            }
            for (String returnType : uniqueResponseTypes) {
                sb.append("{:ok, ").append(returnType).append("} | ");
            }
            sb.append("{:error, Tesla.Env.t}");
            return sb.toString();
        }

        private void buildTypespec(CodegenParameter param, StringBuilder sb) {
            if (param.dataType == null) {
                sb.append("nil");
            } else if (param.isArray) {
                sb.append("list(");
                this.buildTypespec(param.items, sb);
                sb.append(")");
            } else if (param.isMap) {
                sb.append("%{optional(String.t) => ");
                this.buildTypespec(param.items, sb);
                sb.append("}");
            } else if (param.isPrimitiveType) {
                sb.append(param.dataType);
            } else if (param.isFile || param.isBinary) {
                sb.append("String.t");
            } else if ("String.t".equals(param.dataType)) {
                sb.append(param.dataType);
            } else {
                sb.append(ElixirClientCodegen.this.moduleName);
                sb.append(".Model.");
                sb.append(param.dataType);
                sb.append(".t");
            }
        }

        private void buildTypespec(CodegenProperty property, StringBuilder sb) {
            if (property == null) {
                LOGGER.error("CodegenProperty cannot be null. Please report the issue to https://github.com/openapitools/openapi-generator with the spec");
            } else if (property.isArray) {
                sb.append("list(");
                this.buildTypespec(property.items, sb);
                sb.append(")");
            } else if (property.isMap) {
                sb.append("%{optional(String.t) => ");
                this.buildTypespec(property.items, sb);
                sb.append("}");
            } else if (property.isPrimitiveType) {
                sb.append(property.baseType);
                sb.append(".t");
            } else {
                sb.append(ElixirClientCodegen.this.moduleName);
                sb.append(".Model.");
                sb.append(property.baseType);
                sb.append(".t");
            }
        }
    }

    class ExtendedCodegenResponse
    extends CodegenResponse {
        public boolean isDefinedDefault;

        public ExtendedCodegenResponse(CodegenResponse o) {
            this.headers.addAll(o.headers);
            this.code = o.code;
            this.message = o.message;
            this.examples = o.examples;
            this.dataType = o.dataType;
            this.baseType = o.baseType;
            this.containerType = o.containerType;
            this.hasHeaders = o.hasHeaders;
            this.isString = o.isString;
            this.isNumeric = o.isNumeric;
            this.isInteger = o.isInteger;
            this.isLong = o.isLong;
            this.isNumber = o.isNumber;
            this.isFloat = o.isFloat;
            this.isDouble = o.isDouble;
            this.isByteArray = o.isByteArray;
            this.isBoolean = o.isBoolean;
            this.isDate = o.isDate;
            this.isDateTime = o.isDateTime;
            this.isUuid = o.isUuid;
            this.isEmail = o.isEmail;
            this.isModel = o.isModel;
            this.isFreeFormObject = o.isFreeFormObject;
            this.isDefault = o.isDefault;
            this.simpleType = o.simpleType;
            this.primitiveType = o.primitiveType;
            this.isMap = o.isMap;
            this.isArray = o.isArray;
            this.isBinary = o.isBinary;
            this.isFile = o.isFile;
            this.schema = o.schema;
            this.jsonSchema = o.jsonSchema;
            this.vendorExtensions = o.vendorExtensions;
            this.isDefinedDefault = this.code.equals("0") || this.code.equals("default");
        }

        public String codeMappingKey() {
            if (this.isDefinedDefault) {
                return ":default";
            }
            if (this.code.matches("^\\d{3}$")) {
                return this.code;
            }
            LOGGER.warn("Unknown HTTP status code: " + this.code);
            return "\"" + this.code + "\"";
        }

        public String decodedStruct() {
            if (this.isMap) {
                return "%{}";
            }
            if (this.baseType == null || this.simpleType && this.primitiveType) {
                return "false";
            }
            if (this.isArray && ElixirClientCodegen.this.languageSpecificPrimitives().contains(this.baseType)) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            if (this.isArray) {
                sb.append("[");
            }
            sb.append("%");
            sb.append(ElixirClientCodegen.this.moduleName);
            sb.append(".Model.");
            sb.append(this.baseType);
            sb.append("{}");
            if (this.isArray) {
                sb.append("]");
            }
            return sb.toString();
        }
    }
}

