/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpZendExpressivePathHandlerServerCodegen
extends AbstractPhpCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhpZendExpressivePathHandlerServerCodegen.class);
    public static final String VEN_FROM_QUERY = "internal.ze-ph.fromQuery";
    public static final String VEN_COLLECTION_FORMAT = "internal.ze-ph.collectionFormat";
    public static final String VEN_QUERY_DATA_TYPE = "internal.ze-ph.queryDataType";
    public static final String VEN_HAS_QUERY_DATA = "internal.ze-ph.hasQueryData";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "php-ze-ph";
    }

    @Override
    public String getHelp() {
        return "Generates PHP server stub using Zend Expressive ( https://zendframework.github.io/zend-expressive ) and Path Handler ( https://github.com/Articus/PathHandler ).";
    }

    public PhpZendExpressivePathHandlerServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}));
        this.typeMapping.put("double", "float");
        this.templateDir = "php-ze-ph";
        this.embeddedTemplateDir = "php-ze-ph";
        this.invokerPackage = "App";
        this.srcBasePath = "src" + File.separator + "App";
        this.apiDirName = "Handler";
        this.modelDirName = "DTO";
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.supportingFiles.add(new SupportingFile("README.md.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("composer.json.mustache", "", "composer.json"));
        this.supportingFiles.add(new SupportingFile("index.php", "public", "index.php"));
        this.supportingFiles.add(new SupportingFile("container.php", "application", "container.php"));
        this.supportingFiles.add(new SupportingFile("config.yml", "application", "config.yml"));
        this.supportingFiles.add(new SupportingFile("app.yml.mustache", "application" + File.separator + "config", "app.yml"));
        this.supportingFiles.add(new SupportingFile("path_handler.yml.mustache", "application" + File.separator + "config", "path_handler.yml"));
        this.supportingFiles.add(new SupportingFile("data_transfer.yml.mustache", "application" + File.separator + "config", "data_transfer.yml"));
        this.supportingFiles.add(new SupportingFile("Factory.php.mustache", this.srcBasePath, "Factory.php"));
        this.supportingFiles.add(new SupportingFile("InternalServerError.php.mustache", this.srcBasePath + File.separator + "Middleware", "InternalServerError.php"));
        this.supportingFiles.add(new SupportingFile("Date.php.mustache", this.srcBasePath + File.separator + "Strategy", "Date.php"));
        this.supportingFiles.add(new SupportingFile("DateTime.php.mustache", this.srcBasePath + File.separator + "Strategy", "DateTime.php"));
        this.supportingFiles.add(new SupportingFile("QueryParameter.php.mustache", this.srcBasePath + File.separator + "Strategy", "QueryParameter.php"));
        this.supportingFiles.add(new SupportingFile("QueryParameterArray.php.mustache", this.srcBasePath + File.separator + "Strategy", "QueryParameterArray.php"));
        this.supportingFiles.add(new SupportingFile("Type.php.mustache", this.srcBasePath + File.separator + "Validator", "Type.php"));
        this.supportingFiles.add(new SupportingFile("QueryParameterType.php.mustache", this.srcBasePath + File.separator + "Validator", "QueryParameterType.php"));
        this.supportingFiles.add(new SupportingFile("QueryParameterArrayType.php.mustache", this.srcBasePath + File.separator + "Validator", "QueryParameterArrayType.php"));
        this.additionalProperties.put("artifactVersion", "1.0.0");
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(resourcePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(resourcePath, opList);
        }
        int counter = 0;
        for (CodegenOperation op : opList) {
            if (!co.operationId.equals(op.operationId)) continue;
            ++counter;
        }
        if (counter == 0) {
            co.operationIdLowerCase = co.operationId.toLowerCase(Locale.ROOT);
            opList.add(co);
            co.baseName = tag;
        }
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiName(String name) {
        name = name.replaceAll("[\\}]", "");
        return super.toModelName(name);
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        Paths paths = openAPI.getPaths();
        if (paths != null) {
            for (String pathname : paths.keySet()) {
                PathItem path = (PathItem)paths.get(pathname);
                Map operationMap = path.readOperationsMap();
                if (operationMap == null) continue;
                for (PathItem.HttpMethod method : operationMap.keySet()) {
                    Operation operation = (Operation)operationMap.get(method);
                    HashMap<String, Schema> schemas = new HashMap<String, Schema>();
                    if (operation == null || operation.getParameters() == null) continue;
                    ArrayList<String> requiredProperties = new ArrayList<String>();
                    for (Parameter parameter : operation.getParameters()) {
                        Schema schema = this.convertParameterToSchema(parameter);
                        if (schema == null) continue;
                        schemas.put(schema.getName(), schema);
                        if (!Boolean.TRUE.equals(parameter.getRequired())) continue;
                        requiredProperties.add(schema.getName());
                    }
                    if (schemas.isEmpty()) continue;
                    ObjectSchema model = new ObjectSchema();
                    String operationId = this.getOrGenerateOperationId(operation, pathname, method.name());
                    model.setDescription("Query parameters for " + operationId);
                    model.setProperties(schemas);
                    model.setRequired(requiredProperties);
                    this.addInternalExtensionToSchema((Schema)model, VEN_FROM_QUERY, Boolean.TRUE);
                    String definitionName = this.generateUniqueDefinitionName(operationId + "QueryData", openAPI);
                    openAPI.getComponents().addSchemas(definitionName, (Schema)model);
                    String definitionModel = "\\" + this.modelPackage + "\\" + this.toModelName(definitionName);
                    this.addInternalExtensionToOperation(operation, VEN_QUERY_DATA_TYPE, definitionModel);
                    this.addInternalExtensionToOperation(operation, VEN_HAS_QUERY_DATA, Boolean.TRUE);
                }
            }
        }
    }

    protected Schema convertParameterToSchema(Parameter parameter) {
        BooleanSchema property = null;
        if (parameter instanceof QueryParameter) {
            QueryParameter queryParameter = (QueryParameter)parameter;
            if (ModelUtils.isArraySchema(queryParameter.getSchema())) {
                Schema inner = ((ArraySchema)queryParameter.getSchema()).getItems();
                ArraySchema arraySchema = new ArraySchema();
                arraySchema.setMinItems(queryParameter.getSchema().getMinItems());
                arraySchema.setMaxItems(queryParameter.getSchema().getMaxItems());
                arraySchema.setItems(inner);
                String collectionFormat = this.getCollectionFormat((Parameter)queryParameter);
                if (collectionFormat == null) {
                    collectionFormat = "csv";
                }
                this.addInternalExtensionToSchema((Schema)arraySchema, VEN_COLLECTION_FORMAT, collectionFormat);
                property = arraySchema;
            } else {
                switch (queryParameter.getSchema().getType()) {
                    case "string": {
                        StringSchema stringSchema = new StringSchema();
                        stringSchema.setMinLength(queryParameter.getSchema().getMinLength());
                        stringSchema.setMaxLength(queryParameter.getSchema().getMaxLength());
                        stringSchema.setPattern(queryParameter.getSchema().getPattern());
                        stringSchema.setEnum(queryParameter.getSchema().getEnum());
                        property = stringSchema;
                        break;
                    }
                    case "integer": {
                        IntegerSchema integerSchema = new IntegerSchema();
                        integerSchema.setMinimum(queryParameter.getSchema().getMinimum());
                        integerSchema.setMaximum(queryParameter.getSchema().getMaximum());
                        property = integerSchema;
                        break;
                    }
                    case "number": {
                        NumberSchema floatSchema = new NumberSchema();
                        floatSchema.setMinimum(queryParameter.getSchema().getMinimum());
                        floatSchema.setMaximum(queryParameter.getSchema().getMaximum());
                        property = floatSchema;
                        break;
                    }
                    case "boolean": {
                        property = new BooleanSchema();
                        break;
                    }
                    case "date": {
                        property = new DateSchema();
                        break;
                    }
                    case "date-time": {
                        property = new DateTimeSchema();
                    }
                }
            }
            if (property != null) {
                property.setName(queryParameter.getName());
                property.setDescription(queryParameter.getDescription());
                this.addInternalExtensionToSchema((Schema)property, VEN_FROM_QUERY, Boolean.TRUE);
            }
        }
        return property;
    }

    protected void addInternalExtensionToSchema(Schema schema, String name, Object value) {
        if (schema.getExtensions() == null) {
            schema.setExtensions(new HashMap());
        }
        schema.getExtensions().put(name, value);
    }

    protected void addInternalExtensionToOperation(Operation operation, String name, Object value) {
        if (operation.getExtensions() == null) {
            operation.setExtensions(new HashMap());
        }
        operation.getExtensions().put(name, value);
    }

    protected String generateUniqueDefinitionName(String name, OpenAPI openAPI) {
        String result = name;
        if (openAPI.getComponents().getSchemas() != null) {
            int count = 1;
            while (openAPI.getComponents().getSchemas().containsKey(result)) {
                result = name + "_" + count;
                ++count;
            }
        }
        return result;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        String pathPattern = null;
        for (CodegenOperation op : operationList) {
            String httpMethodDeclaration;
            switch (op.httpMethod) {
                case "GET": {
                    httpMethodDeclaration = "Get()";
                    break;
                }
                case "POST": {
                    httpMethodDeclaration = "Post()";
                    break;
                }
                case "PATCH": {
                    httpMethodDeclaration = "Patch()";
                    break;
                }
                case "PUT": {
                    httpMethodDeclaration = "Put()";
                    break;
                }
                case "DELETE": {
                    httpMethodDeclaration = "Delete()";
                    break;
                }
                default: {
                    httpMethodDeclaration = "HttpMethod(\"" + op.httpMethod + "\")";
                }
            }
            op.httpMethod = httpMethodDeclaration;
            if (op.produces != null) {
                for (Map p : op.produces) {
                    if (!p.replace("mediaType", "*/*", "n/a")) continue;
                    LOGGER.warn("Media type range '*/*' is not supported, using 'n/a' for code generation instead");
                }
            }
            if (pathPattern != null) continue;
            pathPattern = this.generatePathPattern(op);
        }
        operations.put("pathPattern", pathPattern);
        return objs;
    }

    protected String generatePathPattern(CodegenOperation op) {
        String result = op.path;
        for (CodegenParameter pp : op.pathParams) {
            StringBuilder replacement = new StringBuilder("{" + pp.paramName);
            if (pp.isEnum) {
                StringBuilder enumRegExp = new StringBuilder();
                for (String enumValue : pp._enum) {
                    if (enumRegExp.length() > 0) {
                        enumRegExp.append("|");
                    }
                    enumRegExp.append(enumValue.replaceAll("[\\Q<>()[]{}|^$-=!?*+.\\\\E]", "\\\\$0"));
                }
                replacement.append(":");
                replacement.append((CharSequence)enumRegExp);
            } else if (pp.isInteger) {
                replacement.append(":0|(?:-?[1-9][0-9]*)");
            } else if (pp.isString && pp.pattern != null && !pp.pattern.isEmpty()) {
                replacement.append(":");
                replacement.append(pp.pattern);
            }
            replacement.append("}");
            result = result.replace("{" + pp.paramName + "}", replacement);
        }
        return result;
    }
}

