/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Escapers;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAdaCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAdaCodegen.class);
    protected String packageName = "defaultPackage";
    protected String projectName = "defaultProject";
    protected List<Map<String, Object>> orderedModels;
    protected final Map<String, List<String>> modelDepends;
    protected final Map<String, String> nullableTypeMapping;
    protected final HashMap<String, String> operationsScopes;
    protected int scopeIndex = 0;

    public AbstractAdaCodegen() {
        this.setReservedWordsLowerCase(Arrays.asList("abort", "abs", "abstract", "accept", "access", "aliased", "all", "and", "array", "at", "begin", "body", "case", "constant", "declare", "delay", "digits", "do", "else", "elsif", "end", "entry", "exception", "exit", "for", "function", "generic", "goto", "if", "in", "interface", "is", "limited", "loop", "mod", "new", "not", "null", "of", "or", "others", "out", "overriding", "package", "pragma", "private", "procedure", "protected", "raise", "range", "record", "rem", "renames", "requeue", "return", "reverse", "select", "separate", "some", "subtype", "synchronized", "tagged", "task", "terminate", "then", "type", "until", "use", "when", "while", "with", "xor"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "Swagger.Date");
        this.typeMapping.put("DateTime", "Swagger.Datetime");
        this.typeMapping.put("string", "Swagger.UString");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("long", "Swagger.Long");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("array", "Swagger.Vector");
        this.typeMapping.put("map", "Swagger.Map");
        this.typeMapping.put("object", "Swagger.Object");
        this.typeMapping.put("number", "Swagger.Number");
        this.typeMapping.put("UUID", "Swagger.UString");
        this.typeMapping.put("URI", "Swagger.UString");
        this.typeMapping.put("file", "Swagger.Http_Content_Type");
        this.typeMapping.put("binary", "Swagger.Binary");
        this.nullableTypeMapping = new HashMap<String, String>();
        this.nullableTypeMapping.put("Swagger.Date", "Swagger.Nullable_Date");
        this.nullableTypeMapping.put("Swagger.Datetime", "Swagger.Nullable_Date");
        this.nullableTypeMapping.put("Swagger.UString", "Swagger.Nullable_UString");
        this.nullableTypeMapping.put("Integer", "Swagger.Nullable_Integer");
        this.nullableTypeMapping.put("Swagger.Long", "Swagger.Nullable_Long");
        this.nullableTypeMapping.put("Boolean", "Swagger.Nullable_Boolean");
        this.nullableTypeMapping.put("Swagger.Object", "Swagger.Object");
        this.modelDepends = new HashMap<String, List<String>>();
        this.orderedModels = new ArrayList<Map<String, Object>>();
        this.operationsScopes = new HashMap();
        this.importMapping = new HashMap<String, String>();
        this.addOption("projectName", "GNAT project name", this.projectName);
        this.modelNameSuffix = "Type";
        this.templateDir = "Ada";
        this.embeddedTemplateDir = "Ada";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("integer", "boolean", "Integer", "Character", "Boolean", "long", "float", "double"));
    }

    public String toFilename(String name) {
        return name.replace(".", "-").toLowerCase(Locale.ROOT);
    }

    protected String toAdaIdentifier(String name, String prefix) {
        if (this.isReservedWord(name)) {
            LOGGER.warn("Identifier '" + name + "' is a reserved word, renamed to " + prefix + name);
            name = prefix + name;
        }
        StringBuilder result = new StringBuilder();
        boolean needUpperCase = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (needUpperCase) {
                needUpperCase = false;
                result.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                if (!needUpperCase) {
                    result.append('_');
                }
                result.append(c);
                needUpperCase = false;
                continue;
            }
            result.append(c);
            if (c != '_') continue;
            needUpperCase = true;
        }
        return result.toString();
    }

    @Override
    public String toOperationId(String operationId) {
        return this.toAdaIdentifier(this.sanitizeName(operationId), "Call_");
    }

    @Override
    public String toVarName(String name) {
        return this.toAdaIdentifier(this.sanitizeName(name), "P_");
    }

    @Override
    public String toParamName(String name) {
        return this.toAdaIdentifier(super.toParamName(name), "P_");
    }

    @Override
    public String toModelName(String name) {
        String result = StringUtils.camelize(this.sanitizeName(name));
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            result = this.modelNamePrefix + "_" + result;
        }
        if (this.isReservedWord(name)) {
            String modelName = "Model_" + result;
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (result.matches("^\\d.*")) {
            String modelName = "Model_" + result;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (this.languageSpecificPrimitives.contains(result)) {
            String modelName = "Model_" + result;
            LOGGER.warn(name + " (model name matches existing language type) cannot be used as a model name. Renamed to " + modelName);
            return modelName;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            result = result + "_" + this.modelNameSuffix;
        }
        return result;
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty property = super.fromProperty(name, p);
        if (property != null) {
            String nameInCamelCase = property.nameInCamelCase;
            property.nameInCamelCase = nameInCamelCase = this.sanitizeName(nameInCamelCase);
        }
        return property;
    }

    @Override
    public String escapeReservedWord(String name) {
        return "p_" + name;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*").replace("-", "_");
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        compiler = super.processCompiler(compiler).emptyStringIsFalse(true);
        return compiler.withEscaper(Escapers.NONE);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String schemaType = this.getSchemaType(p);
        if (schemaType != null) {
            schemaType = schemaType.replace("-", "_");
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getTypeDeclaration(inner) + "_Vectors.Vector";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            String name = this.getTypeDeclaration(inner) + "_Map";
            if (name.startsWith("Swagger.")) {
                return name;
            }
            return "Swagger." + name;
        }
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType;
        }
        String modelType = this.toModelName(schemaType).replace("-", "_");
        if (ModelUtils.isStringSchema(p) || ModelUtils.isFileSchema(p) || this.languageSpecificPrimitives.contains(modelType)) {
            return modelType;
        }
        return this.modelPackage + ".Models." + modelType;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        if (parameter.dataType == null) {
            return;
        }
        boolean isModel = parameter.dataType.startsWith(this.modelPackage);
        if (!(isModel || parameter.isPrimitiveType || parameter.isDate || parameter.isString || parameter.isContainer || parameter.isFile)) {
            isModel = true;
        }
        parameter.vendorExtensions.put("x-is-model-type", isModel);
    }

    protected int postProcessMediaTypes(List<Map<String, String>> types) {
        int count = 0;
        if (types != null) {
            for (Map<String, String> media : types) {
                String mt = media.get("mediaType");
                if (mt == null) continue;
                mt = mt.replace('/', '_');
                media.put("adaMediaType", mt.toUpperCase(Locale.ROOT));
                ++count;
            }
        }
        return count;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        List securities;
        ApiResponse methodResponse;
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (methodResponse = this.findMethodResponse(operation.getResponses())) != null && ModelUtils.getSchemaFromResponse(methodResponse) != null) {
            CodegenProperty cm = this.fromProperty("response", ModelUtils.getSchemaFromResponse(methodResponse));
            op.vendorExtensions.put("x-codegen-response", cm);
            if ("HttpContent".equals(cm.dataType)) {
                op.vendorExtensions.put("x-codegen-response-ishttpcontent", true);
            }
        }
        if ((securities = operation.getSecurity()) != null && securities.size() > 0) {
            Map securitySchemes = this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null;
            List globalSecurities = this.openAPI.getSecurity();
            Map<String, List<String>> scopes = this.getAuthScopes(securities, securitySchemes);
            if (scopes.isEmpty() && globalSecurities != null) {
                scopes = this.getAuthScopes(globalSecurities, securitySchemes);
            }
            op.vendorExtensions.put("x-scopes", scopes);
        }
        return op;
    }

    private Map<String, List<String>> getAuthScopes(List<SecurityRequirement> securities, Map<String, SecurityScheme> securitySchemes) {
        HashMap<String, List<String>> scopes = new HashMap<String, List<String>>();
        Optional.ofNullable(securitySchemes).ifPresent(_securitySchemes -> {
            for (SecurityRequirement requirement : securities) {
                for (String key : requirement.keySet()) {
                    Optional.ofNullable(securitySchemes.get(key)).ifPresent(securityScheme -> {
                        List cfr_ignored_0 = (List)scopes.put(key, (List<String>)requirement.get((Object)key));
                    });
                }
            }
        });
        return scopes;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op1 : operationList) {
            if (op1.summary != null) {
                op1.summary = op1.summary.trim();
            }
            if (op1.notes != null) {
                op1.notes = op1.notes.trim();
            }
            op1.vendorExtensions.put("x-has-uniq-produces", this.postProcessMediaTypes(op1.produces) == 1);
            op1.vendorExtensions.put("x-has-uniq-consumes", this.postProcessMediaTypes(op1.consumes) == 1);
            op1.vendorExtensions.put("x-has-notes", op1.notes != null && op1.notes.length() > 0);
            for (CodegenParameter p : op1.allParams) {
                if (p.isFormParam && p.isFile) {
                    p.dataType = "Swagger.File_Part_Type";
                }
                if (p.required || !this.nullableTypeMapping.containsKey(p.dataType)) continue;
                p.dataType = this.nullableTypeMapping.get(p.dataType);
            }
            for (CodegenParameter p : op1.formParams) {
                if (!p.isFile) continue;
                p.dataType = "Swagger.File_Part_Type";
            }
            Map scopes = (Map)op1.vendorExtensions.get("x-scopes");
            List<CodegenSecurity> opScopes = this.postProcessAuthMethod(op1.authMethods, scopes);
            if (opScopes != null) {
                op1.vendorExtensions.put("x-auth-scopes", opScopes);
            }
            for (CodegenParameter p : op1.pathParams) {
                String path = op1.path;
                int pos = 0;
                int index = 0;
                while (pos >= 0 && pos < path.length() && (pos = path.indexOf(123, pos)) >= 0) {
                    int last = path.indexOf(125, ++pos);
                    ++index;
                    if (last < 0 || path.substring(pos, last - 1).equals(p.baseName)) break;
                    pos = last + 1;
                }
                p.vendorExtensions.put("x-path-index", index);
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Map model : models) {
            Object v = model.get("model");
            if (!(v instanceof CodegenModel)) continue;
            CodegenModel m = (CodegenModel)v;
            ArrayList<String> d = new ArrayList<String>();
            for (CodegenProperty p : m.vars) {
                boolean isModel = false;
                CodegenProperty item = p;
                if (p.isContainer) {
                    item = p.items;
                }
                if (!(item == null || item.isString || item.isPrimitiveType || item.isContainer || item.isInteger)) {
                    if (!d.contains(item.dataType)) {
                        d.add(item.dataType);
                    }
                    isModel = true;
                }
                p.vendorExtensions.put("x-is-model-type", isModel);
                Boolean required = p.getRequired();
                if (Boolean.TRUE.equals(required) || !this.nullableTypeMapping.containsKey(p.dataType)) continue;
                p.dataType = this.nullableTypeMapping.get(p.dataType);
            }
            this.modelDepends.put(this.modelPackage + ".Models." + m.classname, d);
            this.orderedModels.add(model);
        }
        ArrayList<Map<String, Object>> revisedOrderedModels = new ArrayList<Map<String, Object>>();
        ArrayList<String> collectedModelNames = new ArrayList<String>();
        int sizeOrderedModels = this.orderedModels.size();
        for (int i = 0; i < sizeOrderedModels; ++i) {
            Map<String, Object> independentModel = null;
            String independentModelName = null;
            for (Map<String, Object> model : this.orderedModels) {
                String modelName = this.modelPackage + ".Models." + ((CodegenModel)model.get((Object)"model")).classname;
                boolean dependent = false;
                for (String dependency : this.modelDepends.get(modelName)) {
                    if (collectedModelNames.contains(dependency)) continue;
                    dependent = true;
                }
                if (dependent) continue;
                independentModel = model;
                independentModelName = modelName;
            }
            if (null == independentModel) continue;
            revisedOrderedModels.add(independentModel);
            collectedModelNames.add(independentModelName);
            this.orderedModels.remove(independentModel);
        }
        revisedOrderedModels.addAll(this.orderedModels);
        this.orderedModels = revisedOrderedModels;
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        objs.put("orderedModels", this.orderedModels);
        this.generateJSONSpecFile(objs);
        List authMethods = (List)objs.get("authMethods");
        this.postProcessAuthMethod(authMethods, null);
        return super.postProcessSupportingFileData(objs);
    }

    private List<CodegenSecurity> postProcessAuthMethod(List<CodegenSecurity> authMethods, Map<String, List<String>> scopes) {
        ArrayList<CodegenSecurity> result;
        ArrayList<CodegenSecurity> arrayList = result = scopes == null ? null : new ArrayList<CodegenSecurity>();
        if (authMethods != null) {
            for (CodegenSecurity authMethod : authMethods) {
                if (authMethod.scopes != null) {
                    for (Map<String, Object> scope : authMethod.scopes) {
                        String ident;
                        String name = (String)scope.get("scope");
                        if (this.operationsScopes.containsKey(name)) {
                            scope.put("ident", this.operationsScopes.get(name));
                            continue;
                        }
                        if (name.startsWith("https://")) {
                            int pos = name.lastIndexOf(47);
                            ident = name.substring(pos + 1);
                        } else {
                            ident = name;
                        }
                        ++this.scopeIndex;
                        ident = this.toAdaIdentifier(this.sanitizeName(ident.replaceAll(":", "_")), "S_");
                        if (this.operationsScopes.containsValue(ident)) {
                            ident = ident + "_" + this.scopeIndex;
                        }
                        this.operationsScopes.put(name, ident);
                        scope.put("ident", ident);
                    }
                }
                List<String> opScopes = scopes == null ? null : scopes.get(authMethod.name);
                authMethod.name = StringUtils.camelize(this.sanitizeName(authMethod.name), true);
                if (opScopes == null) continue;
                CodegenSecurity opSecurity = new CodegenSecurity();
                opSecurity.name = authMethod.name;
                opSecurity.type = authMethod.type;
                opSecurity.hasMore = false;
                opSecurity.isBasic = authMethod.isBasic;
                opSecurity.isApiKey = authMethod.isApiKey;
                opSecurity.isKeyInCookie = authMethod.isKeyInCookie;
                opSecurity.isKeyInHeader = authMethod.isKeyInHeader;
                opSecurity.isKeyInQuery = authMethod.isKeyInQuery;
                opSecurity.flow = authMethod.flow;
                opSecurity.tokenUrl = authMethod.tokenUrl;
                ArrayList<Map<String, Object>> opAuthScopes = new ArrayList<Map<String, Object>>();
                block2: for (String opScopeName : opScopes) {
                    for (Map<String, Object> scope : authMethod.scopes) {
                        String name = (String)scope.get("scope");
                        if (!opScopeName.equals(name)) continue;
                        opAuthScopes.add(scope);
                        continue block2;
                    }
                }
                opSecurity.scopes = opAuthScopes;
                result.add(opSecurity);
            }
        }
        return result;
    }
}

