/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openapitools.codegen.config.GeneratorSettings;
import org.openapitools.codegen.config.WorkflowSettings;

public class DynamicSettings {
    @JsonAnySetter
    private Map<String, Object> dynamicProperties = new HashMap<String, Object>();
    @JsonUnwrapped
    @JsonDeserialize(builder=GeneratorSettings.Builder.class)
    private GeneratorSettings generatorSettings;
    @JsonUnwrapped
    @JsonDeserialize(builder=WorkflowSettings.Builder.class)
    private WorkflowSettings workflowSettings;

    public GeneratorSettings getGeneratorSettings() {
        this.excludeSettingsFromDynamicProperties();
        GeneratorSettings.Builder builder = GeneratorSettings.newBuilder((GeneratorSettings)this.generatorSettings);
        for (Map.Entry<String, Object> entry : this.dynamicProperties.entrySet()) {
            builder.withAdditionalProperty(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public WorkflowSettings getWorkflowSettings() {
        this.excludeSettingsFromDynamicProperties();
        return WorkflowSettings.newBuilder((WorkflowSettings)this.workflowSettings).build();
    }

    @JsonCreator
    public DynamicSettings() {
    }

    public Map<String, Object> getDynamicProperties() {
        return this.dynamicProperties;
    }

    private void excludeSettingsFromDynamicProperties() {
        HashSet<String> fieldNames = new HashSet<String>();
        for (Field field : GeneratorSettings.class.getDeclaredFields()) {
            fieldNames.add(field.getName());
        }
        for (Field field : WorkflowSettings.class.getDeclaredFields()) {
            fieldNames.add(field.getName());
        }
        this.dynamicProperties.keySet().removeAll(fieldNames);
    }
}

