/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.GoClientCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoClientExperimentalCodegen
extends GoClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoClientExperimentalCodegen.class);

    public GoClientExperimentalCodegen() {
        this.outputFolder = "generated-code/go-experimental";
        this.templateDir = "go-experimental";
        this.embeddedTemplateDir = "go-experimental";
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
    }

    @Override
    public String getName() {
        return "go-experimental";
    }

    @Override
    public String getHelp() {
        return "Generates a Go client library (experimental and may subject to breaking changes without further notice).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("utils.mustache", "", "utils.go"));
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        List models = (List)objs.get("models");
        for (Map m : models) {
            Object v = m.get("model");
            if (!(v instanceof CodegenModel)) continue;
            CodegenModel model = (CodegenModel)v;
            if (model.isEnum) continue;
            for (CodegenProperty param : model.vars) {
                if (!param.isNullable) continue;
                param.dataType = "Nullable" + Character.toUpperCase(param.dataType.charAt(0)) + param.dataType.substring(1);
            }
        }
        return objs;
    }
}

