/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.DartClientCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DartDioClientCodegen
extends DartClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(DartDioClientCodegen.class);
    private static final String NULLABLE_FIELDS = "nullableFields";
    private static final String IS_FORMAT_JSON = "jsonFormat";
    private static final String CLIENT_NAME = "clientName";
    private static Set<String> modelToIgnore = new HashSet<String>();
    private static final String SERIALIZATION_JSON = "json";
    private boolean nullableFields = true;

    public DartDioClientCodegen() {
        this.browserClient = false;
        this.outputFolder = "generated-code/dart-dio";
        this.templateDir = "dart-dio";
        this.embeddedTemplateDir = "dart-dio";
        this.modelTestTemplateFiles.clear();
        this.apiTestTemplateFiles.clear();
        this.cliOptions.add(new CliOption(NULLABLE_FIELDS, "Is the null fields should be in the JSON payload"));
        this.typeMapping.put("file", "Uint8List");
        this.typeMapping.put("binary", "Uint8List");
        this.importMapping.put("BuiltList", "package:built_collection/built_collection.dart");
        this.importMapping.put("BuiltMap", "package:built_collection/built_collection.dart");
        this.importMapping.put("Uint8List", "dart:typed_data");
    }

    @Override
    public String getName() {
        return "dart-dio";
    }

    @Override
    public String getHelp() {
        return "Generates a Dart Dio client library.";
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            return "const {}";
        }
        if (ModelUtils.isArraySchema(p)) {
            return "const []";
        }
        return super.toDefaultValue(p);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "empty";
        }
        if ("number".equalsIgnoreCase(datatype) || "int".equalsIgnoreCase(datatype)) {
            name = "Number" + name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public void processOpts() {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("DART_POST_PROCESS_FILE"))) {
            LOGGER.info("Environment variable DART_POST_PROCESS_FILE not defined so the Dart code may not be properly formatted. To define it, try `export DART_POST_PROCESS_FILE=\"/usr/local/bin/dartfmt -w\"` (Linux/Mac)");
            LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(NULLABLE_FIELDS)) {
            this.nullableFields = this.convertPropertyToBooleanAndWriteBack(NULLABLE_FIELDS);
        } else {
            this.additionalProperties.put(NULLABLE_FIELDS, this.nullableFields);
        }
        this.additionalProperties.put(IS_FORMAT_JSON, true);
        if (this.additionalProperties.containsKey("pubName")) {
            this.setPubName((String)this.additionalProperties.get("pubName"));
        } else {
            this.additionalProperties.put("pubName", this.pubName);
        }
        if (!this.additionalProperties.containsKey(CLIENT_NAME)) {
            this.additionalProperties.put(CLIENT_NAME, StringUtils.camelize(this.pubName));
        }
        if (this.additionalProperties.containsKey("pubVersion")) {
            this.setPubVersion((String)this.additionalProperties.get("pubVersion"));
        } else {
            this.additionalProperties.put("pubVersion", this.pubVersion);
        }
        if (this.additionalProperties.containsKey("pubDescription")) {
            this.setPubDescription((String)this.additionalProperties.get("pubDescription"));
        } else {
            this.additionalProperties.put("pubDescription", this.pubDescription);
        }
        if (this.additionalProperties.containsKey("useEnumExtension")) {
            this.setUseEnumExtension(this.convertPropertyToBooleanAndWriteBack("useEnumExtension"));
        } else {
            this.additionalProperties.put("useEnumExtension", this.useEnumExtension);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        String libFolder = this.sourceFolder + File.separator + "lib";
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("analysis_options.mustache", "", "analysis_options.yaml"));
        this.supportingFiles.add(new SupportingFile("apilib.mustache", libFolder, "api.dart"));
        this.supportingFiles.add(new SupportingFile("serializers.mustache", libFolder, "serializers.dart"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        List models = (List)objs.get("models");
        ProcessUtils.addIndexToProperties(models, 1);
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            HashSet<String> modelImports = new HashSet<String>();
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (String modelImport : cm.imports) {
                if (this.importMapping.containsKey(modelImport)) {
                    modelImports.add((String)this.importMapping.get(modelImport));
                    continue;
                }
                if (modelToIgnore.contains(modelImport.toLowerCase(Locale.ROOT))) continue;
                modelImports.add("package:" + this.pubName + "/model/" + StringUtils.underscore(modelImport) + ".dart");
            }
            cm.imports = modelImports;
            cm.vendorExtensions.put("hasVars", cm.vars.size() > 0);
        }
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (this.nullableFields) {
            property.isNullable = true;
        }
        if (property.isListContainer && "List".equals(property.baseType)) {
            property.setDatatype(property.dataType.replaceAll(property.baseType, "BuiltList"));
            property.setBaseType("BuiltList");
            model.imports.add("BuiltList");
        }
        if (property.isMapContainer && "Map".equals(property.baseType)) {
            property.setDatatype(property.dataType.replaceAll(property.baseType, "BuiltMap"));
            property.setBaseType("BuiltMap");
            model.imports.add("BuiltMap");
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        HashSet<String> modelImports = new HashSet<String>();
        HashSet<String> fullImports = new HashSet<String>();
        for (CodegenOperation op : operationList) {
            op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
            boolean isJson = true;
            boolean isForm = false;
            boolean isMultipart = false;
            if (op.consumes != null) {
                for (Map map : op.consumes) {
                    if (!map.containsKey("mediaType")) continue;
                    String type = (String)map.get("mediaType");
                    isJson = type.equalsIgnoreCase("application/json");
                    isForm = type.equalsIgnoreCase("application/x-www-form-urlencoded");
                    isMultipart = type.equalsIgnoreCase("multipart/form-data");
                    break;
                }
            }
            for (CodegenParameter codegenParameter : op.bodyParams) {
                if (codegenParameter.baseType == null || !codegenParameter.baseType.equalsIgnoreCase("Uint8List") || !isMultipart) continue;
                codegenParameter.baseType = "MultipartFile";
                codegenParameter.dataType = "MultipartFile";
            }
            op.vendorExtensions.put("isJson", isJson);
            op.vendorExtensions.put("isForm", isForm);
            op.vendorExtensions.put("isMultipart", isMultipart);
            HashSet<String> imports = new HashSet<String>();
            for (String item : op.imports) {
                if (!modelToIgnore.contains(item.toLowerCase(Locale.ROOT))) {
                    imports.add(StringUtils.underscore(item));
                    continue;
                }
                if (!item.equalsIgnoreCase("Uint8List")) continue;
                fullImports.add("dart:typed_data");
            }
            modelImports.addAll(imports);
            op.imports = imports;
        }
        objs.put("modelImports", modelImports);
        objs.put("fullImports", fullImports);
        return objs;
    }

    static {
        modelToIgnore.add("datetime");
        modelToIgnore.add("map");
        modelToIgnore.add("object");
        modelToIgnore.add("list");
        modelToIgnore.add("file");
        modelToIgnore.add("uint8list");
    }
}

