/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLPathUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLPathUtils.class);
    public static final String LOCAL_HOST = "http://localhost";
    public static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{([^\\}]+)\\}");

    public static URL getServerURL(OpenAPI openAPI) {
        List servers = openAPI.getServers();
        if (servers == null || servers.isEmpty()) {
            LOGGER.warn("Server information seems not defined in the spec. Default to {}.", (Object)LOCAL_HOST);
            return URLPathUtils.getDefaultUrl();
        }
        return URLPathUtils.getServerURL((Server)servers.get(0));
    }

    public static URL getServerURL(Server server) {
        String url = server.getUrl();
        ServerVariables variables = server.getVariables();
        if (variables == null) {
            variables = new ServerVariables();
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            url = URLPathUtils.extractUrl(server, url, variables);
            url = URLPathUtils.sanitizeUrl(url);
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Not valid URL: {}. Default to {}.", (Object)server.getUrl(), (Object)LOCAL_HOST);
            }
        }
        return URLPathUtils.getDefaultUrl();
    }

    private static String extractUrl(Server server, String url, ServerVariables variables) {
        HashSet<String> replacedVariables = new HashSet<String>();
        Matcher matcher = VARIABLE_PATTERN.matcher(url);
        while (matcher.find()) {
            String replacement;
            if (replacedVariables.contains(matcher.group())) continue;
            ServerVariable variable = (ServerVariable)variables.get((Object)matcher.group(1));
            if (variable != null) {
                if (variable.getDefault() != null) {
                    replacement = variable.getDefault();
                } else if (variable.getEnum() != null && !variable.getEnum().isEmpty()) {
                    replacement = (String)variable.getEnum().get(0);
                } else {
                    LOGGER.warn("No value found for variable '{}' in server definition '{}', default to empty string.", (Object)matcher.group(1), (Object)server.getUrl());
                    replacement = "";
                }
            } else {
                LOGGER.warn("No variable '{}' found in server definition '{}', default to empty string.", (Object)matcher.group(1), (Object)server.getUrl());
                replacement = "";
            }
            url = url.replace(matcher.group(), replacement);
            replacedVariables.add(matcher.group());
            matcher = VARIABLE_PATTERN.matcher(url);
        }
        return url;
    }

    public static String getScheme(OpenAPI openAPI, CodegenConfig config) {
        URL url = URLPathUtils.getServerURL(openAPI);
        return URLPathUtils.getScheme(url, config);
    }

    public static String getScheme(URL url, CodegenConfig config) {
        String scheme = url != null ? url.getProtocol() : "https";
        if (config != null) {
            scheme = config.escapeText(scheme);
        }
        return scheme;
    }

    public static String getPort(URL url, int defaultPort) {
        return URLPathUtils.getPort(url, String.valueOf(defaultPort));
    }

    public static String getPort(URL url, String defaultPort) {
        if (url == null || url.getPort() == -1) {
            return defaultPort;
        }
        return String.valueOf(url.getPort());
    }

    public static String getPath(URL url, String defaultPath) {
        if (url == null || url.getPath() == null || url.getPath().isEmpty()) {
            return defaultPath;
        }
        return url.getPath();
    }

    public static String getProtocolAndHost(URL url) {
        if (url == null) {
            return LOCAL_HOST;
        }
        String protocol = url.getProtocol() == null ? "http" : url.getProtocol();
        return protocol + "://" + url.getHost();
    }

    public static String getHost(OpenAPI openAPI) {
        if (openAPI.getServers() != null && openAPI.getServers().size() > 0) {
            return URLPathUtils.sanitizeUrl(URLPathUtils.getServerURL((Server)openAPI.getServers().get(0)).toString());
        }
        return LOCAL_HOST;
    }

    private static String sanitizeUrl(String url) {
        if (url.startsWith("//")) {
            url = "http:" + url;
            LOGGER.warn("'scheme' not defined in the spec (2.0). Default to [http] for server URL [{}]", (Object)url);
        } else if (url.startsWith("/")) {
            url = LOCAL_HOST + url;
            LOGGER.warn("'host' (OAS 2.0) or 'servers' (OAS 3.0) not defined in the spec. Default to [{}] for server URL [{}]", (Object)LOCAL_HOST, (Object)url);
        } else if (!url.matches("[a-zA-Z][0-9a-zA-Z.+\\-]+://.+")) {
            url = "http://" + url;
            LOGGER.warn("'scheme' not defined in the spec (2.0). Default to [http] for server URL [{}]", (Object)url);
        }
        return url;
    }

    private static URL getDefaultUrl() {
        try {
            return new URL(LOCAL_HOST);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

