/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.AbstractGenerator;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenServer;
import org.openapitools.codegen.Generator;
import org.openapitools.codegen.GlobalSupportingFile;
import org.openapitools.codegen.InlineModelResolver;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.api.TemplatingGenerator;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.ignore.CodegenIgnoreProcessor;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.templating.MustacheEngineAdapter;
import org.openapitools.codegen.utils.ImplementationVersion;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenerator
extends AbstractGenerator
implements Generator {
    protected final Logger LOGGER = LoggerFactory.getLogger(DefaultGenerator.class);
    protected CodegenConfig config;
    protected ClientOptInput opts;
    protected OpenAPI openAPI;
    protected CodegenIgnoreProcessor ignoreProcessor;
    protected TemplatingEngineAdapter templatingEngine;
    private Boolean generateApis = null;
    private Boolean generateModels = null;
    private Boolean generateSupportingFiles = null;
    private Boolean generateApiTests = null;
    private Boolean generateApiDocumentation = null;
    private Boolean generateModelTests = null;
    private Boolean generateModelDocumentation = null;
    private Boolean generateMetadata = true;
    private String basePath;
    private String basePathWithoutHost;
    private String contextPath;
    private Map<String, String> generatorPropertyDefaults = new HashMap<String, String>();

    @Override
    public boolean getEnableMinimalUpdate() {
        return this.config.isEnableMinimalUpdate();
    }

    @Override
    public Generator opts(ClientOptInput opts) {
        this.opts = opts;
        this.openAPI = opts.getOpenAPI();
        this.config = opts.getConfig();
        this.templatingEngine = this.config.getTemplatingEngine();
        String ignoreFileLocation = this.config.getIgnoreFilePathOverride();
        if (ignoreFileLocation != null) {
            File ignoreFile = new File(ignoreFileLocation);
            if (ignoreFile.exists() && ignoreFile.canRead()) {
                this.ignoreProcessor = new CodegenIgnoreProcessor(ignoreFile);
            } else {
                this.LOGGER.warn("Ignore file specified at {} is not valid. This will fall back to an existing ignore file if present in the output directory.", (Object)ignoreFileLocation);
            }
        }
        if (this.ignoreProcessor == null) {
            this.ignoreProcessor = new CodegenIgnoreProcessor(this.config.getOutputDir());
        }
        return this;
    }

    private void configPostProcessMustacheCompiler() {
        if (this.templatingEngine instanceof MustacheEngineAdapter) {
            MustacheEngineAdapter mustacheEngineAdapter = (MustacheEngineAdapter)this.templatingEngine;
            mustacheEngineAdapter.setCompiler(this.config.processCompiler(mustacheEngineAdapter.getCompiler()));
        }
    }

    public void setGenerateMetadata(Boolean generateMetadata) {
        this.generateMetadata = generateMetadata;
    }

    public void setGeneratorPropertyDefault(String key, String value) {
        this.generatorPropertyDefaults.put(key, value);
    }

    private Boolean getGeneratorPropertyDefaultSwitch(String key, Boolean defaultValue) {
        String result = null;
        if (this.generatorPropertyDefaults.containsKey(key)) {
            result = this.generatorPropertyDefaults.get(key);
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return defaultValue;
    }

    private void configureGeneratorProperties() {
        this.generateApis = GlobalSettings.getProperty("apis") != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("apis", null);
        this.generateModels = GlobalSettings.getProperty("models") != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("models", null);
        Boolean bl = this.generateSupportingFiles = GlobalSettings.getProperty("supportingFiles") != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("supportingFiles", null);
        if (this.generateApis == null && this.generateModels == null && this.generateSupportingFiles == null) {
            this.generateModels = this.generateSupportingFiles = Boolean.valueOf(true);
            this.generateApis = this.generateSupportingFiles;
        } else {
            if (this.generateApis == null) {
                this.generateApis = false;
            }
            if (this.generateModels == null) {
                this.generateModels = false;
            }
            if (this.generateSupportingFiles == null) {
                this.generateSupportingFiles = false;
            }
        }
        this.generateModelTests = GlobalSettings.getProperty("modelTests") != null ? Boolean.valueOf(GlobalSettings.getProperty("modelTests")) : this.getGeneratorPropertyDefaultSwitch("modelTests", true);
        this.generateModelDocumentation = GlobalSettings.getProperty("modelDocs") != null ? Boolean.valueOf(GlobalSettings.getProperty("modelDocs")) : this.getGeneratorPropertyDefaultSwitch("modelDocs", true);
        this.generateApiTests = GlobalSettings.getProperty("apiTests") != null ? Boolean.valueOf(GlobalSettings.getProperty("apiTests")) : this.getGeneratorPropertyDefaultSwitch("apiTests", true);
        this.generateApiDocumentation = GlobalSettings.getProperty("apiDocs") != null ? Boolean.valueOf(GlobalSettings.getProperty("apiDocs")) : this.getGeneratorPropertyDefaultSwitch("apiDocs", true);
        this.config.additionalProperties().put("generateApiTests", this.generateApiTests);
        this.config.additionalProperties().put("generateModelTests", this.generateModelTests);
        this.config.additionalProperties().put("generateApiDocs", this.generateApiDocumentation);
        this.config.additionalProperties().put("generateModelDocs", this.generateModelDocumentation);
        this.config.additionalProperties().put("generateApis", this.generateApis);
        this.config.additionalProperties().put("generateModels", this.generateModels);
        if (!this.generateApiTests.booleanValue() && !this.generateModelTests.booleanValue()) {
            this.config.additionalProperties().put("excludeTests", true);
        }
        if (GlobalSettings.getProperty("debugOpenAPI") != null) {
            Json.prettyPrint((Object)this.openAPI);
        } else if (GlobalSettings.getProperty("debugSwagger") != null) {
            this.LOGGER.info("Please use system property 'debugOpenAPI' instead of 'debugSwagger'.");
            Json.prettyPrint((Object)this.openAPI);
        }
        this.config.processOpts();
        this.config.preprocessOpenAPI(this.openAPI);
        this.config.setOpenAPI(this.openAPI);
        this.config.additionalProperties().put("generatorVersion", ImplementationVersion.read());
        this.config.additionalProperties().put("generatedDate", ZonedDateTime.now().toString());
        this.config.additionalProperties().put("generatedYear", String.valueOf(ZonedDateTime.now().getYear()));
        this.config.additionalProperties().put("generatorClass", this.config.getClass().getName());
        this.config.additionalProperties().put("inputSpec", this.config.getInputSpec());
        if (this.openAPI.getExtensions() != null) {
            this.config.vendorExtensions().putAll(this.openAPI.getExtensions());
        }
        URL url = URLPathUtils.getServerURL(this.openAPI);
        this.basePathWithoutHost = this.contextPath = this.config.escapeText(url.getPath()).replaceAll("/$", "");
        this.basePath = this.config.escapeText(URLPathUtils.getHost(this.openAPI)).replaceAll("/$", "");
    }

    private void configureOpenAPIInfo() {
        Info info = this.openAPI.getInfo();
        if (info == null) {
            return;
        }
        if (info.getTitle() != null) {
            this.config.additionalProperties().put("appName", this.config.escapeText(info.getTitle()));
        }
        if (info.getVersion() != null) {
            this.config.additionalProperties().put("appVersion", this.config.escapeText(info.getVersion()));
        } else {
            this.LOGGER.error("Missing required field info version. Default appVersion set to 1.0.0");
            this.config.additionalProperties().put("appVersion", "1.0.0");
        }
        if (StringUtils.isEmpty((CharSequence)info.getDescription())) {
            this.config.additionalProperties().put("appDescription", "No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)");
            this.config.additionalProperties().put("appDescriptionWithNewLines", this.config.additionalProperties().get("appDescription"));
            this.config.additionalProperties().put("unescapedAppDescription", "No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)");
        } else {
            this.config.additionalProperties().put("appDescription", this.config.escapeText(info.getDescription()));
            this.config.additionalProperties().put("appDescriptionWithNewLines", this.config.escapeTextWhileAllowingNewLines(info.getDescription()));
            this.config.additionalProperties().put("unescapedAppDescription", info.getDescription());
        }
        if (info.getContact() != null) {
            Contact contact = info.getContact();
            if (contact.getEmail() != null) {
                this.config.additionalProperties().put("infoEmail", this.config.escapeText(contact.getEmail()));
            }
            if (contact.getName() != null) {
                this.config.additionalProperties().put("infoName", this.config.escapeText(contact.getName()));
            }
            if (contact.getUrl() != null) {
                this.config.additionalProperties().put("infoUrl", this.config.escapeText(contact.getUrl()));
            }
        }
        if (info.getLicense() != null) {
            License license = info.getLicense();
            if (license.getName() != null) {
                this.config.additionalProperties().put("licenseInfo", this.config.escapeText(license.getName()));
            }
            if (license.getUrl() != null) {
                this.config.additionalProperties().put("licenseUrl", this.config.escapeText(license.getUrl()));
            }
        }
        if (info.getVersion() != null) {
            this.config.additionalProperties().put("version", this.config.escapeText(info.getVersion()));
        } else {
            this.LOGGER.error("Missing required field info version. Default version set to 1.0.0");
            this.config.additionalProperties().put("version", "1.0.0");
        }
        if (info.getTermsOfService() != null) {
            this.config.additionalProperties().put("termsOfService", this.config.escapeText(info.getTermsOfService()));
        }
    }

    private void generateModelTests(List<File> files, Map<String, Object> models, String modelName) throws IOException {
        for (String templateName : this.config.modelTestTemplateFiles().keySet()) {
            String suffix = this.config.modelTestTemplateFiles().get(templateName);
            String filename = this.config.modelTestFileFolder() + File.separator + this.config.toModelTestFilename(modelName) + suffix;
            if (new File(filename).exists()) {
                this.LOGGER.info("File exists. Skipped overwriting " + filename);
                continue;
            }
            File written = this.processTemplateToFile(models, templateName, filename);
            if (written == null) continue;
            files.add(written);
            if (!this.config.isEnablePostProcessFile()) continue;
            this.config.postProcessFile(written, "model-test");
        }
    }

    private void generateModelDocumentation(List<File> files, Map<String, Object> models, String modelName) throws IOException {
        for (String templateName : this.config.modelDocTemplateFiles().keySet()) {
            String docExtension = this.config.getDocExtension();
            String suffix = docExtension != null ? docExtension : this.config.modelDocTemplateFiles().get(templateName);
            String filename = this.config.modelDocFileFolder() + File.separator + this.config.toModelDocFilename(modelName) + suffix;
            if (!this.config.shouldOverwrite(filename)) {
                this.LOGGER.info("Skipped overwriting " + filename);
                continue;
            }
            File written = this.processTemplateToFile(models, templateName, filename);
            if (written == null) continue;
            files.add(written);
            if (!this.config.isEnablePostProcessFile()) continue;
            this.config.postProcessFile(written, "model-doc");
        }
    }

    private void generateModel(List<File> files, Map<String, Object> models, String modelName) throws IOException {
        for (String templateName : this.config.modelTemplateFiles().keySet()) {
            String suffix = this.config.modelTemplateFiles().get(templateName);
            String filename = this.config.modelFileFolder() + File.separator + this.config.toModelFilename(modelName) + suffix;
            if (!this.config.shouldOverwrite(filename)) {
                this.LOGGER.info("Skipped overwriting " + filename);
                continue;
            }
            File written = this.processTemplateToFile(models, templateName, filename);
            if (written == null) continue;
            files.add(written);
            if (!this.config.isEnablePostProcessFile()) continue;
            this.config.postProcessFile(written, "model");
        }
    }

    private void generateModels(List<File> files, List<Object> allModels, List<String> unusedModels) {
        if (!this.generateModels.booleanValue()) {
            return;
        }
        Map<String, Schema> schemas = ModelUtils.getSchemas(this.openAPI);
        if (schemas == null) {
            return;
        }
        String modelNames = GlobalSettings.getProperty("models");
        HashSet<String> modelsToGenerate = null;
        if (modelNames != null && !modelNames.isEmpty()) {
            modelsToGenerate = new HashSet<String>(Arrays.asList(modelNames.split(",")));
        }
        Set<String> modelKeys = schemas.keySet();
        if (modelsToGenerate != null && !modelsToGenerate.isEmpty()) {
            HashSet<String> updatedKeys = new HashSet<String>();
            for (String m : modelKeys) {
                if (!modelsToGenerate.contains(m)) continue;
                updatedKeys.add(m);
            }
            modelKeys = updatedKeys;
        }
        Map<String, Object> allProcessedModels = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ObjectUtils.compare((Comparable)((Object)DefaultGenerator.this.config.toModelName(o1)), (Comparable)((Object)DefaultGenerator.this.config.toModelName(o2)));
            }
        });
        Boolean skipFormModel = GlobalSettings.getProperty("skipFormModel") != null ? Boolean.valueOf(GlobalSettings.getProperty("skipFormModel")) : this.getGeneratorPropertyDefaultSwitch("skipFormModel", false);
        for (String name : modelKeys) {
            try {
                Schema schema;
                if (this.config.importMapping().containsKey(name)) {
                    this.LOGGER.debug("Model " + name + " not imported due to import mapping");
                    continue;
                }
                if (unusedModels.contains(name)) {
                    if (Boolean.FALSE.equals(skipFormModel)) {
                        this.LOGGER.info("Model " + name + " (marked as unused due to form parameters) is generated due to the system property skipFormModel=false (default)");
                    } else {
                        this.LOGGER.info("Model " + name + " not generated since it's marked as unused (due to form parameters) and skipFormModel (system property) set to true");
                        continue;
                    }
                }
                if (ModelUtils.isFreeFormObject(schema = schemas.get(name))) {
                    this.LOGGER.info("Model " + name + " not generated since it's a free-form object");
                    continue;
                }
                if (ModelUtils.isMapSchema(schema)) {
                    if (!ModelUtils.isGenerateAliasAsModel() && (schema.getProperties() == null || schema.getProperties().isEmpty())) {
                        this.LOGGER.info("Model " + name + " not generated since it's an alias to map (without property) and `generateAliasAsModel` is set to false (default)");
                        continue;
                    }
                } else if (ModelUtils.isArraySchema(schema) && !ModelUtils.isGenerateAliasAsModel() && (schema.getProperties() == null || schema.getProperties().isEmpty())) {
                    this.LOGGER.info("Model " + name + " not generated since it's an alias to array (without property) and `generateAliasAsModel` is set to false (default)");
                    continue;
                }
                HashMap<String, Schema> schemaMap = new HashMap<String, Schema>();
                schemaMap.put(name, schema);
                Map<String, Object> models = this.processModels(this.config, schemaMap);
                models.put("classname", this.config.toModelName(name));
                models.putAll(this.config.additionalProperties());
                allProcessedModels.put(name, models);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not process model '" + name + "'.Please make sure that your schema is correct!", e);
            }
        }
        allProcessedModels = this.config.updateAllModels(allProcessedModels);
        allProcessedModels = this.config.postProcessAllModels(allProcessedModels);
        for (String modelName : allProcessedModels.keySet()) {
            Map models = (Map)allProcessedModels.get(modelName);
            models.put("modelPackage", this.config.modelPackage());
            try {
                if (this.config.importMapping().containsKey(modelName)) continue;
                Map modelTemplate = (Map)((List)models.get("models")).get(0);
                if (modelTemplate != null && modelTemplate.containsKey("model")) {
                    CodegenModel m = (CodegenModel)modelTemplate.get("model");
                    if (m.isAlias) continue;
                }
                allModels.add(modelTemplate);
                this.generateModel(files, models, modelName);
                if (this.generateModelTests.booleanValue()) {
                    this.generateModelTests(files, models, modelName);
                }
                if (!this.generateModelDocumentation.booleanValue()) continue;
                this.generateModelDocumentation(files, models, modelName);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate model '" + modelName + "'", e);
            }
        }
        if (GlobalSettings.getProperty("debugModels") != null) {
            this.LOGGER.info("############ Model info ############");
            Json.prettyPrint(allModels);
        }
    }

    private void generateApis(List<File> files, List<Object> allOperations, List<Object> allModels) {
        if (!this.generateApis.booleanValue()) {
            return;
        }
        Map<String, List<CodegenOperation>> paths = this.processPaths(this.openAPI.getPaths());
        HashSet<String> apisToGenerate = null;
        String apiNames = GlobalSettings.getProperty("apis");
        if (apiNames != null && !apiNames.isEmpty()) {
            apisToGenerate = new HashSet<String>(Arrays.asList(apiNames.split(",")));
        }
        if (apisToGenerate != null && !apisToGenerate.isEmpty()) {
            TreeMap<String, List<CodegenOperation>> updatedPaths = new TreeMap<String, List<CodegenOperation>>();
            for (String m : paths.keySet()) {
                if (!apisToGenerate.contains(m)) continue;
                updatedPaths.put(m, paths.get(m));
            }
            paths = updatedPaths;
        }
        for (String tag : paths.keySet()) {
            try {
                File written;
                String filename;
                List<CodegenOperation> ops = paths.get(tag);
                Collections.sort(ops, new Comparator<CodegenOperation>(){

                    @Override
                    public int compare(CodegenOperation one, CodegenOperation another) {
                        return ObjectUtils.compare((Comparable)((Object)one.operationId), (Comparable)((Object)another.operationId));
                    }
                });
                Map<String, Object> operation = this.processOperations(this.config, tag, ops, allModels);
                URL url = URLPathUtils.getServerURL(this.openAPI);
                operation.put("basePath", this.basePath);
                operation.put("basePathWithoutHost", this.config.encodePath(url.getPath()).replaceAll("/$", ""));
                operation.put("contextPath", this.contextPath);
                operation.put("baseName", tag);
                operation.put("apiPackage", this.config.apiPackage());
                operation.put("modelPackage", this.config.modelPackage());
                operation.putAll(this.config.additionalProperties());
                operation.put("classname", this.config.toApiName(tag));
                operation.put("classVarName", this.config.toApiVarName(tag));
                operation.put("importPath", this.config.toApiImport(tag));
                operation.put("classFilename", this.config.toApiFilename(tag));
                operation.put("strictSpecBehavior", this.config.isStrictSpecBehavior());
                if (allModels == null || allModels.isEmpty()) {
                    operation.put("hasModel", false);
                } else {
                    operation.put("hasModel", true);
                }
                if (!this.config.vendorExtensions().isEmpty()) {
                    operation.put("vendorExtensions", this.config.vendorExtensions());
                }
                if (this.config.vendorExtensions().containsKey("x-group-parameters")) {
                    Boolean isGroupParameters = Boolean.valueOf(this.config.vendorExtensions().get("x-group-parameters").toString());
                    Map objectMap = (Map)operation.get("operations");
                    List operations = (List)objectMap.get("operation");
                    for (CodegenOperation op : operations) {
                        if (!isGroupParameters.booleanValue() || op.vendorExtensions.containsKey("x-group-parameters")) continue;
                        op.vendorExtensions.put("x-group-parameters", Boolean.TRUE);
                    }
                }
                boolean sortParamsByRequiredFlag = true;
                if (this.config.additionalProperties().containsKey("sortParamsByRequiredFlag")) {
                    sortParamsByRequiredFlag = Boolean.valueOf(this.config.additionalProperties().get("sortParamsByRequiredFlag").toString());
                }
                operation.put("sortParamsByRequiredFlag", sortParamsByRequiredFlag);
                allOperations.add(new HashMap<String, Object>(operation));
                for (int i = 0; i < allOperations.size(); ++i) {
                    Map oo = (Map)allOperations.get(i);
                    if (i >= allOperations.size() - 1) continue;
                    oo.put("hasMore", "true");
                }
                for (String templateName : this.config.apiTemplateFiles().keySet()) {
                    filename = this.config.apiFilename(templateName, tag);
                    if (!this.config.shouldOverwrite(filename) && new File(filename).exists()) {
                        this.LOGGER.info("Skipped overwriting " + filename);
                        continue;
                    }
                    written = this.processTemplateToFile(operation, templateName, filename);
                    if (written == null) continue;
                    files.add(written);
                    if (!this.config.isEnablePostProcessFile()) continue;
                    this.config.postProcessFile(written, "api");
                }
                if (this.generateApiTests.booleanValue()) {
                    for (String templateName : this.config.apiTestTemplateFiles().keySet()) {
                        filename = this.config.apiTestFilename(templateName, tag);
                        if (new File(filename).exists()) {
                            this.LOGGER.info("File exists. Skipped overwriting " + filename);
                            continue;
                        }
                        written = this.processTemplateToFile(operation, templateName, filename);
                        if (written == null) continue;
                        files.add(written);
                        if (!this.config.isEnablePostProcessFile()) continue;
                        this.config.postProcessFile(written, "api-test");
                    }
                }
                if (!this.generateApiDocumentation.booleanValue()) continue;
                for (String templateName : this.config.apiDocTemplateFiles().keySet()) {
                    filename = this.config.apiDocFilename(templateName, tag);
                    if (!this.config.shouldOverwrite(filename) && new File(filename).exists()) {
                        this.LOGGER.info("Skipped overwriting " + filename);
                        continue;
                    }
                    written = this.processTemplateToFile(operation, templateName, filename);
                    if (written == null) continue;
                    files.add(written);
                    if (!this.config.isEnablePostProcessFile()) continue;
                    this.config.postProcessFile(written, "api-doc");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate api file for '" + tag + "'", e);
            }
        }
        if (GlobalSettings.getProperty("debugOperations") != null) {
            this.LOGGER.info("############ Operation info ############");
            Json.prettyPrint(allOperations);
        }
    }

    private void generateSupportingFiles(List<File> files, Map<String, Object> bundle) {
        if (!this.generateSupportingFiles.booleanValue()) {
            return;
        }
        HashSet<String> supportingFilesToGenerate = null;
        String supportingFiles = GlobalSettings.getProperty("supportingFiles");
        if (supportingFiles != null && !supportingFiles.isEmpty()) {
            supportingFilesToGenerate = new HashSet<String>(Arrays.asList(supportingFiles.split(",")));
        }
        for (SupportingFile support : this.config.supportingFiles()) {
            try {
                String outputFilename;
                File of;
                String outputFolder = this.config.outputFolder();
                if (StringUtils.isNotEmpty((CharSequence)support.folder)) {
                    outputFolder = outputFolder + File.separator + support.folder;
                }
                if (!(of = new File(outputFolder)).isDirectory()) {
                    of.mkdirs();
                }
                String string = outputFilename = new File(support.destinationFilename).isAbsolute() ? support.destinationFilename : outputFolder + File.separator + support.destinationFilename.replace('/', File.separatorChar);
                if (!this.config.shouldOverwrite(outputFilename)) {
                    this.LOGGER.info("Skipped overwriting " + outputFilename);
                    continue;
                }
                String templateFile = support instanceof GlobalSupportingFile ? this.config.getCommonTemplateDir() + File.separator + support.templateFile : this.getFullTemplateFile(this.config, support.templateFile);
                boolean shouldGenerate = true;
                if (supportingFilesToGenerate != null && !supportingFilesToGenerate.isEmpty()) {
                    shouldGenerate = supportingFilesToGenerate.contains(support.destinationFilename);
                }
                if (!shouldGenerate) continue;
                if (this.ignoreProcessor.allowsFile(new File(outputFilename))) {
                    if (Arrays.stream(this.templatingEngine.getFileExtensions()).anyMatch(templateFile::endsWith)) {
                        String templateContent = this.templatingEngine.compileTemplate((TemplatingGenerator)this, bundle, support.templateFile);
                        this.writeToFile(outputFilename, templateContent);
                        File written = new File(outputFilename);
                        files.add(written);
                        if (!this.config.isEnablePostProcessFile()) continue;
                        this.config.postProcessFile(written, "supporting-mustache");
                        continue;
                    }
                    InputStream in = null;
                    try {
                        in = new FileInputStream(templateFile);
                    }
                    catch (Exception written) {
                        // empty catch block
                    }
                    if (in == null) {
                        in = this.getClass().getClassLoader().getResourceAsStream(this.getCPResourcePath(templateFile));
                    }
                    File outputFile = this.writeInputStreamToFile(outputFilename, in, templateFile);
                    files.add(outputFile);
                    if (!this.config.isEnablePostProcessFile()) continue;
                    this.config.postProcessFile(outputFile, "supporting-common");
                    continue;
                }
                this.LOGGER.info("Skipped generation of " + outputFilename + " due to rule in .openapi-generator-ignore");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate supporting file '" + support + "'", e);
            }
        }
        String openapiGeneratorIgnore = ".openapi-generator-ignore";
        String ignoreFileNameTarget = this.config.outputFolder() + File.separator + ".openapi-generator-ignore";
        File ignoreFile = new File(ignoreFileNameTarget);
        if (this.generateMetadata.booleanValue() && !ignoreFile.exists()) {
            String ignoreFileNameSource = File.separator + this.config.getCommonTemplateDir() + File.separator + ".openapi-generator-ignore";
            String ignoreFileContents = this.readResourceContents(ignoreFileNameSource);
            try {
                this.writeToFile(ignoreFileNameTarget, ignoreFileContents);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not generate supporting file '.openapi-generator-ignore'", e);
            }
            files.add(ignoreFile);
            if (this.config.isEnablePostProcessFile()) {
                this.config.postProcessFile(ignoreFile, "openapi-generator-ignore");
            }
        }
        if (this.generateMetadata.booleanValue()) {
            String versionMetadata = this.config.outputFolder() + File.separator + ".openapi-generator" + File.separator + "VERSION";
            File versionMetadataFile = new File(versionMetadata);
            try {
                this.writeToFile(versionMetadata, ImplementationVersion.read());
                files.add(versionMetadataFile);
                if (this.config.isEnablePostProcessFile()) {
                    this.config.postProcessFile(ignoreFile, "openapi-generator-version");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not generate supporting file '" + versionMetadata + "'", e);
            }
        }
    }

    protected File writeInputStreamToFile(String filename, InputStream in, String templateFile) throws FileNotFoundException, IOException {
        if (in != null) {
            byte[] bytes = IOUtils.toByteArray((InputStream)in);
            return this.writeToFile(filename, bytes);
        }
        this.LOGGER.error("can't open '" + templateFile + "' for input; cannot write '" + filename + "'");
        return null;
    }

    private Map<String, Object> buildSupportFileBundle(List<Object> allOperations, List<Object> allModels) {
        List<CodegenServer> servers;
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        bundle.putAll(this.config.additionalProperties());
        bundle.put("apiPackage", this.config.apiPackage());
        HashMap<String, List<Object>> apis = new HashMap<String, List<Object>>();
        apis.put("apis", allOperations);
        URL url = URLPathUtils.getServerURL(this.openAPI);
        bundle.put("openAPI", this.openAPI);
        bundle.put("basePath", this.basePath);
        bundle.put("basePathWithoutHost", this.basePathWithoutHost);
        bundle.put("scheme", URLPathUtils.getScheme(url, this.config));
        bundle.put("host", url.getHost());
        bundle.put("contextPath", this.contextPath);
        bundle.put("apiInfo", apis);
        bundle.put("models", allModels);
        bundle.put("apiFolder", this.config.apiPackage().replace('.', File.separatorChar));
        bundle.put("modelPackage", this.config.modelPackage());
        Map securitySchemeMap = this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null;
        List<CodegenSecurity> authMethods = this.config.fromSecurity(securitySchemeMap);
        if (authMethods != null && !authMethods.isEmpty()) {
            bundle.put("authMethods", authMethods);
            bundle.put("hasAuthMethods", true);
            if (this.hasOAuthMethods(authMethods)) {
                bundle.put("hasOAuthMethods", true);
                bundle.put("oauthMethods", this.getOAuthMethods(authMethods));
            }
            if (this.hasBearerMethods(authMethods)) {
                bundle.put("hasBearerMethods", true);
            }
        }
        if ((servers = this.config.fromServers(this.openAPI.getServers())) != null && !servers.isEmpty()) {
            bundle.put("servers", servers);
            bundle.put("hasServers", true);
        }
        if (this.openAPI.getExternalDocs() != null) {
            bundle.put("externalDocs", this.openAPI.getExternalDocs());
        }
        for (int i = 0; i < allModels.size() - 1; ++i) {
            HashMap cm = (HashMap)allModels.get(i);
            CodegenModel m = (CodegenModel)cm.get("model");
            m.hasMoreModels = true;
        }
        this.config.postProcessSupportingFileData(bundle);
        if (GlobalSettings.getProperty("debugSupportingFiles") != null) {
            this.LOGGER.info("############ Supporting file info ############");
            Json.prettyPrint(bundle);
        }
        return bundle;
    }

    @Override
    public List<File> generate() {
        if (this.openAPI == null) {
            throw new RuntimeException("missing OpenAPI input!");
        }
        if (this.config == null) {
            throw new RuntimeException("missing config!");
        }
        if (this.config.getGeneratorMetadata() == null) {
            this.LOGGER.warn(String.format(Locale.ROOT, "Generator '%s' is missing generator metadata!", this.config.getName()));
        } else {
            GeneratorMetadata generatorMetadata = this.config.getGeneratorMetadata();
            if (StringUtils.isNotEmpty((CharSequence)generatorMetadata.getGenerationMessage())) {
                this.LOGGER.info(generatorMetadata.getGenerationMessage());
            }
            Stability stability = generatorMetadata.getStability();
            String stabilityMessage = String.format(Locale.ROOT, "Generator '%s' is considered %s.", this.config.getName(), stability.value());
            if (stability == Stability.DEPRECATED) {
                this.LOGGER.warn(stabilityMessage);
            } else {
                this.LOGGER.info(stabilityMessage);
            }
        }
        InlineModelResolver inlineModelResolver = new InlineModelResolver();
        inlineModelResolver.flatten(this.openAPI);
        this.configureGeneratorProperties();
        this.configureOpenAPIInfo();
        this.configPostProcessMustacheCompiler();
        ArrayList<File> files = new ArrayList<File>();
        List<String> filteredSchemas = ModelUtils.getSchemasUsedOnlyInFormParam(this.openAPI);
        ArrayList<Object> allModels = new ArrayList<Object>();
        this.generateModels(files, allModels, filteredSchemas);
        ArrayList<Object> allOperations = new ArrayList<Object>();
        this.generateApis(files, allOperations, allModels);
        Map<String, Object> bundle = this.buildSupportFileBundle(allOperations, allModels);
        this.generateSupportingFiles(files, bundle);
        this.config.processOpenAPI(this.openAPI);
        GlobalSettings.reset();
        return files;
    }

    public String getFullTemplateContents(String templateName) {
        return this.readTemplate(this.getFullTemplateFile(this.config, templateName));
    }

    public Path getFullTemplatePath(String name) {
        String fullPath = this.getFullTemplateFile(this.config, name);
        return java.nio.file.Paths.get(fullPath, new String[0]);
    }

    protected File processTemplateToFile(Map<String, Object> templateData, String templateName, String outputFilename) throws IOException {
        String adjustedOutputFilename = outputFilename.replaceAll("//", "/").replace('/', File.separatorChar);
        if (this.ignoreProcessor.allowsFile(new File(adjustedOutputFilename))) {
            String templateContent = this.templatingEngine.compileTemplate((TemplatingGenerator)this, templateData, templateName);
            this.writeToFile(adjustedOutputFilename, templateContent);
            return new File(adjustedOutputFilename);
        }
        this.LOGGER.info("Skipped generation of " + adjustedOutputFilename + " due to rule in .openapi-generator-ignore");
        return null;
    }

    public Map<String, List<CodegenOperation>> processPaths(Paths paths) {
        TreeMap<String, List<CodegenOperation>> ops = new TreeMap<String, List<CodegenOperation>>();
        for (String resourcePath : paths.keySet()) {
            PathItem path = (PathItem)paths.get((Object)resourcePath);
            this.processOperation(resourcePath, "get", path.getGet(), ops, path);
            this.processOperation(resourcePath, "head", path.getHead(), ops, path);
            this.processOperation(resourcePath, "put", path.getPut(), ops, path);
            this.processOperation(resourcePath, "post", path.getPost(), ops, path);
            this.processOperation(resourcePath, "delete", path.getDelete(), ops, path);
            this.processOperation(resourcePath, "patch", path.getPatch(), ops, path);
            this.processOperation(resourcePath, "options", path.getOptions(), ops, path);
        }
        return ops;
    }

    private void processOperation(String resourcePath, String httpMethod, Operation operation, Map<String, List<CodegenOperation>> operations, PathItem path) {
        if (operation == null) {
            return;
        }
        if (GlobalSettings.getProperty("debugOperations") != null) {
            this.LOGGER.info("processOperation: resourcePath= " + resourcePath + "\t;" + httpMethod + " " + operation + "\n");
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        List tagNames = operation.getTags();
        List swaggerTags = this.openAPI.getTags();
        if (tagNames != null) {
            if (swaggerTags == null) {
                for (Iterator tagName : tagNames) {
                    tags.add(new Tag().name(tagName));
                }
            } else {
                for (Iterator tagName : tagNames) {
                    boolean foundTag = false;
                    for (Tag tag : swaggerTags) {
                        if (!tag.getName().equals(tagName)) continue;
                        tags.add(tag);
                        foundTag = true;
                        break;
                    }
                    if (foundTag) continue;
                    tags.add(new Tag().name(tagName));
                }
            }
        }
        if (tags.isEmpty()) {
            tags.add(new Tag().name("default"));
        }
        HashSet<String> operationParameters = new HashSet<String>();
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                operationParameters.add(DefaultGenerator.generateParameterId(parameter));
            }
        }
        if (path.getParameters() != null) {
            for (Parameter parameter : path.getParameters()) {
                if (operationParameters.contains(DefaultGenerator.generateParameterId(parameter))) continue;
                operation.addParametersItem(parameter);
            }
        }
        Map schemas = this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSchemas() : null;
        Map securitySchemes = this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null;
        List globalSecurities = this.openAPI.getSecurity();
        for (Tag tag : tags) {
            try {
                CodegenOperation codegenOperation = this.config.fromOperation(resourcePath, httpMethod, operation, path.getServers());
                codegenOperation.tags = new ArrayList<Tag>(tags);
                this.config.addOperationToGroup(this.config.sanitizeTag(tag.getName()), resourcePath, operation, codegenOperation, operations);
                List securities = operation.getSecurity();
                if (securities != null && securities.isEmpty()) continue;
                Map<String, SecurityScheme> authMethods = this.getAuthMethods(securities, securitySchemes);
                if (authMethods == null || authMethods.isEmpty()) {
                    authMethods = this.getAuthMethods(globalSecurities, securitySchemes);
                }
                if (authMethods == null || authMethods.isEmpty()) continue;
                codegenOperation.authMethods = this.config.fromSecurity(authMethods);
                ArrayList<Map<String, Object>> scopes = new ArrayList<Map<String, Object>>();
                if (codegenOperation.authMethods != null) {
                    for (CodegenSecurity security : codegenOperation.authMethods) {
                        if (security == null || security.isBasicBearer == null || !security.isBasicBearer.booleanValue() || securities == null) continue;
                        block9: for (SecurityRequirement req : securities) {
                            if (req == null) continue;
                            for (String key : req.keySet()) {
                                if (security.name == null || !key.equals(security.name)) continue;
                                int count = 0;
                                for (String sc : (List)req.get((Object)key)) {
                                    HashMap<String, String> scope = new HashMap<String, String>();
                                    scope.put("scope", sc);
                                    scope.put("description", "");
                                    if (req.get((Object)key) != null && ++count < ((List)req.get((Object)key)).size()) {
                                        scope.put("hasMore", "true");
                                    } else {
                                        scope.put("hasMore", null);
                                    }
                                    scopes.add(scope);
                                }
                                continue block9;
                            }
                        }
                        security.hasScopes = scopes.size() > 0;
                        security.scopes = scopes;
                    }
                }
                codegenOperation.hasAuthMethods = true;
            }
            catch (Exception ex) {
                String msg = "Could not process operation:\n  Tag: " + tag + "\n  Operation: " + operation.getOperationId() + "\n  Resource: " + httpMethod + " " + resourcePath + "\n  Schemas: " + this.openAPI.getComponents().getSchemas() + "\n  Exception: " + ex.getMessage();
                throw new RuntimeException(msg, ex);
            }
        }
    }

    private static String generateParameterId(Parameter parameter) {
        return parameter.getName() + ":" + parameter.getIn();
    }

    private Map<String, Object> processOperations(CodegenConfig config, String tag, List<CodegenOperation> ops, List<Object> allModels) {
        List os;
        HashMap<String, Object> operations = new HashMap<String, Object>();
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("classname", config.toApiName(tag));
        objs.put("pathPrefix", config.toApiVarName(tag));
        HashSet<String> opIds = new HashSet<String>();
        int counter = 0;
        for (CodegenOperation codegenOperation : ops) {
            String opId = codegenOperation.nickname;
            if (opIds.contains(opId)) {
                codegenOperation.nickname = codegenOperation.nickname + "_" + ++counter;
            }
            opIds.add(opId);
        }
        objs.put("operation", ops);
        operations.put("operations", objs);
        operations.put("package", config.apiPackage());
        TreeSet<String> allImports = new TreeSet<String>();
        for (CodegenOperation op : ops) {
            allImports.addAll(op.imports);
        }
        ArrayList arrayList = new ArrayList();
        TreeSet<String> mappingSet = new TreeSet<String>();
        for (String nextImport : allImports) {
            LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping == null || mappingSet.contains(mapping)) continue;
            mappingSet.add(mapping);
            im.put("import", mapping);
            im.put("classname", nextImport);
            if (arrayList.contains(im)) continue;
            arrayList.add(im);
        }
        operations.put("imports", arrayList);
        if (arrayList.size() > 0) {
            operations.put("hasImport", true);
        }
        config.postProcessOperationsWithModels(operations, allModels);
        if (objs.size() > 0 && (os = (List)objs.get("operation")) != null && os.size() > 0) {
            CodegenOperation op = (CodegenOperation)os.get(os.size() - 1);
            op.hasMore = false;
        }
        return operations;
    }

    private Map<String, Object> processModels(CodegenConfig config, Map<String, Schema> definitions) {
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("package", config.modelPackage());
        ArrayList models = new ArrayList();
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (String string : definitions.keySet()) {
            Schema schema = definitions.get(string);
            if (schema == null) {
                throw new RuntimeException("schema cannot be null in processMoels");
            }
            CodegenModel cm = config.fromModel(string, schema);
            HashMap<String, Object> mo = new HashMap<String, Object>();
            mo.put("model", cm);
            mo.put("importPath", config.toModelImport(cm.classname));
            models.add(mo);
            cm.removeSelfReferenceImport();
            allImports.addAll(cm.imports);
        }
        objs.put("models", models);
        TreeSet<String> importSet = new TreeSet<String>();
        for (String nextImport : allImports) {
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping != null && !config.defaultIncludes().contains(mapping)) {
                importSet.add(mapping);
            }
            if ((mapping = config.instantiationTypes().get(nextImport)) == null || config.defaultIncludes().contains(mapping)) continue;
            importSet.add(mapping);
        }
        ArrayList arrayList = new ArrayList();
        for (String s : importSet) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("import", s);
            arrayList.add(item);
        }
        objs.put("imports", arrayList);
        config.postProcessModels(objs);
        return objs;
    }

    private Map<String, SecurityScheme> getAuthMethods(List<SecurityRequirement> securities, Map<String, SecurityScheme> securitySchemes) {
        if (securities == null || securitySchemes == null || securitySchemes.isEmpty()) {
            return null;
        }
        HashMap<String, SecurityScheme> authMethods = new HashMap<String, SecurityScheme>();
        for (SecurityRequirement requirement : securities) {
            for (Map.Entry entry : requirement.entrySet()) {
                String key = (String)entry.getKey();
                SecurityScheme securityScheme = securitySchemes.get(key);
                if (securityScheme == null) continue;
                if (securityScheme.getType().equals((Object)SecurityScheme.Type.OAUTH2)) {
                    OAuthFlow updatedFlow;
                    OAuthFlows oautUpdatedFlows = new OAuthFlows();
                    oautUpdatedFlows.extensions(securityScheme.getFlows().getExtensions());
                    SecurityScheme oauthUpdatedScheme = new SecurityScheme().type(securityScheme.getType()).description(securityScheme.getDescription()).name(securityScheme.getName()).$ref(securityScheme.get$ref()).in(securityScheme.getIn()).scheme(securityScheme.getScheme()).bearerFormat(securityScheme.getBearerFormat()).openIdConnectUrl(securityScheme.getOpenIdConnectUrl()).extensions(securityScheme.getExtensions()).flows(oautUpdatedFlows);
                    OAuthFlows securitySchemeFlows = securityScheme.getFlows();
                    if (securitySchemeFlows.getAuthorizationCode() != null) {
                        updatedFlow = DefaultGenerator.cloneOAuthFlow(securitySchemeFlows.getAuthorizationCode(), (List)entry.getValue());
                        oautUpdatedFlows.setAuthorizationCode(updatedFlow);
                    }
                    if (securitySchemeFlows.getImplicit() != null) {
                        updatedFlow = DefaultGenerator.cloneOAuthFlow(securitySchemeFlows.getImplicit(), (List)entry.getValue());
                        oautUpdatedFlows.setImplicit(updatedFlow);
                    }
                    if (securitySchemeFlows.getPassword() != null) {
                        updatedFlow = DefaultGenerator.cloneOAuthFlow(securitySchemeFlows.getPassword(), (List)entry.getValue());
                        oautUpdatedFlows.setPassword(updatedFlow);
                    }
                    if (securitySchemeFlows.getClientCredentials() != null) {
                        updatedFlow = DefaultGenerator.cloneOAuthFlow(securitySchemeFlows.getClientCredentials(), (List)entry.getValue());
                        oautUpdatedFlows.setClientCredentials(updatedFlow);
                    }
                    authMethods.put(key, oauthUpdatedScheme);
                    continue;
                }
                authMethods.put(key, securityScheme);
            }
        }
        return authMethods;
    }

    private static OAuthFlow cloneOAuthFlow(OAuthFlow originFlow, List<String> operationScopes) {
        Scopes newScopes = new Scopes();
        for (String operationScope : operationScopes) {
            newScopes.put((Object)operationScope, originFlow.getScopes().get((Object)operationScope));
        }
        return new OAuthFlow().authorizationUrl(originFlow.getAuthorizationUrl()).tokenUrl(originFlow.getTokenUrl()).refreshUrl(originFlow.getRefreshUrl()).extensions(originFlow.getExtensions()).scopes(newScopes);
    }

    private boolean hasOAuthMethods(List<CodegenSecurity> authMethods) {
        for (CodegenSecurity cs : authMethods) {
            if (!Boolean.TRUE.equals(cs.isOAuth)) continue;
            return true;
        }
        return false;
    }

    private boolean hasBearerMethods(List<CodegenSecurity> authMethods) {
        for (CodegenSecurity cs : authMethods) {
            if (!Boolean.TRUE.equals(cs.isBasicBearer)) continue;
            return true;
        }
        return false;
    }

    private List<CodegenSecurity> getOAuthMethods(List<CodegenSecurity> authMethods) {
        ArrayList<CodegenSecurity> oauthMethods = new ArrayList<CodegenSecurity>();
        for (CodegenSecurity cs : authMethods) {
            if (!Boolean.TRUE.equals(cs.isOAuth)) continue;
            oauthMethods.add(cs);
        }
        return oauthMethods;
    }
}

