/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;

public class TypeScriptAngularJsClientCodegen
extends AbstractTypeScriptClientCodegen {
    public TypeScriptAngularJsClientCodegen() {
        this.outputFolder = "generated-code/typescript-angularjs";
        this.modelTemplateFiles.put("model.mustache", ".ts");
        this.apiTemplateFiles.put("api.mustache", ".ts");
        this.templateDir = "typescript-angularjs";
        this.embeddedTemplateDir = "typescript-angularjs";
        this.apiPackage = "api";
        this.modelPackage = "model";
    }

    @Override
    public String getName() {
        return "typescript-angularjs";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript AngularJS client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("models.mustache", this.modelPackage().replace('.', File.separatorChar), "models.ts"));
        this.supportingFiles.add(new SupportingFile("apis.mustache", this.apiPackage().replace('.', File.separatorChar), "api.ts"));
        this.supportingFiles.add(new SupportingFile("index.mustache", this.getIndexDirectory(), "index.ts"));
        this.supportingFiles.add(new SupportingFile("api.module.mustache", this.getIndexDirectory(), "api.module.ts"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (this.isLanguagePrimitive(openAPIType) || this.isLanguageGenericType(openAPIType)) {
            return openAPIType;
        }
        return this.addModelPrefix(openAPIType);
    }

    @Override
    public String getTypeDeclaration(String name) {
        return this.addModelPrefix(name);
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
    }

    private String getIndexDirectory() {
        String indexPackage = this.modelPackage.substring(0, Math.max(0, this.modelPackage.lastIndexOf(46)));
        return indexPackage.replace('.', File.separatorChar);
    }

    private String addModelPrefix(String openAPIType) {
        String type = null;
        type = this.typeMapping.containsKey(openAPIType) ? (String)this.typeMapping.get(openAPIType) : openAPIType;
        if (!this.isLanguagePrimitive(type) && !this.isLanguageGenericType(type)) {
            type = "models." + openAPIType;
        }
        return type;
    }

    private boolean isLanguagePrimitive(String type) {
        return this.languageSpecificPrimitives.contains(type);
    }

    private boolean isLanguageGenericType(String type) {
        for (String genericType : this.languageGenericTypes) {
            if (!type.startsWith(genericType + "<")) continue;
            return true;
        }
        return false;
    }
}

