/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.utils.StringUtils;

public class GroovyClientCodegen
extends AbstractJavaCodegen {
    public static final String CONFIG_PACKAGE = "configPackage";
    protected String title = "Petstore Server";
    protected String configPackage = "";

    public GroovyClientCodegen() {
        this.languageSpecificPrimitives.add("Date");
        this.languageSpecificPrimitives.add("ArrayList");
        this.languageSpecificPrimitives.add("File");
        this.languageSpecificPrimitives.add("Map");
        this.sourceFolder = this.projectFolder + File.separator + "groovy";
        this.outputFolder = "generated-code/groovy";
        this.modelTemplateFiles.put("model.mustache", ".groovy");
        this.apiTemplateFiles.put("api.mustache", ".groovy");
        this.apiTestTemplateFiles.clear();
        this.templateDir = "Groovy";
        this.embeddedTemplateDir = "Groovy";
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.configPackage = "org.openapitools.configuration";
        this.invokerPackage = "org.openapitools.api";
        this.artifactId = "openapi-groovy";
        this.dateLibrary = "legacy";
        this.additionalProperties.put("title", this.title);
        this.additionalProperties.put(CONFIG_PACKAGE, this.configPackage);
        this.cliOptions.add(new CliOption(CONFIG_PACKAGE, "configuration package for generated code"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "groovy";
    }

    @Override
    public String getHelp() {
        return "Generates a Groovy API client (beta).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CONFIG_PACKAGE)) {
            this.setConfigPackage((String)this.additionalProperties.get(CONFIG_PACKAGE));
        }
        this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("ApiUtils.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiUtils.groovy"));
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return StringUtils.camelize(name) + "Api";
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

