/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphQLCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGraphQLCodegen.class);
    protected String specFolder = "spec";
    protected String packageName = "openapi2graphql";
    protected String packageVersion = "1.0.0";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String graphQlInputsPackage = "";

    public AbstractGraphQLCodegen() {
        this.setReservedWordsLowerCase(Arrays.asList("null", "Int", "Float", "String", "Boolean", "ID", "type", "implements", "query", "union", "interface"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("null", "ID", "Int", "String", "Float", "Boolean"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Int");
        this.typeMapping.put("number", "Float");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Float");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("UUID", "ID");
        this.typeMapping.put("date", "String");
        this.typeMapping.put("DateTime", "String");
        this.typeMapping.put("password", "String");
        this.typeMapping.put("file", "String");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("object", "TODO_OBJECT_MAPPING");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return StringUtils.camelize(name) + '_';
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.packageName + File.separator + "api" + File.separator;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.packageName + File.separator + "model" + File.separator;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name.replaceAll("-", "_"))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true))) {
            name = this.escapeReservedWord(name);
        }
        if (name.matches("^\\d.*")) {
            name = StringUtils.camelize("var_" + name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        return StringUtils.camelize(this.toModelFilename(name));
    }

    @Override
    public String toModelFilename(String name) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        return StringUtils.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name) + "_api";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "_spec";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "_spec";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder.replace("/", File.separator);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder.replace("/", File.separator);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiName(String name) {
        return StringUtils.underscore(super.toApiName(name));
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String nullable;
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return this.getTypeDeclaration(inner);
        }
        String schemaType = this.getSchemaType(p);
        String string = nullable = ModelUtils.isNullable(p) ? "" : "!";
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType) + nullable;
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType + nullable;
        }
        return this.toModelName(schemaType);
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = schemaType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        String sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord(sanitizedOperationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.underscore("call_" + operationId));
            sanitizedOperationId = "call_" + sanitizedOperationId;
        }
        return StringUtils.camelize(sanitizedOperationId, false);
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("]]", "] ]");
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, value);
        return customImport;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase(Locale.ROOT);
        }
        String enumName = this.sanitizeName(StringUtils.underscore(name).toUpperCase(Locale.ROOT));
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", "")) || enumName.matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = this.toModelName(property.name);
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toModelImport(String name) {
        if (this.needToImport(this.toModelName(name))) {
            return this.toModelName(name);
        }
        return name;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> operations) {
        Map objs = (Map)operations.get("operations");
        for (CodegenOperation op : (List)objs.get("operation")) {
            if (!"GET".equals(op.httpMethod.toUpperCase(Locale.ROOT)) && !"HEAD".equals(op.httpMethod.toUpperCase(Locale.ROOT))) {
                op.vendorExtensions.put("x-is-mutation", Boolean.TRUE);
            }
            for (CodegenParameter p : op.allParams) {
                if (p.required) {
                    op.vendorExtensions.put("x-graphql-nullable", Boolean.FALSE);
                    continue;
                }
                op.vendorExtensions.put("x-graphql-nullable", Boolean.TRUE);
            }
        }
        return objs;
    }

    public String graphQlInputsPackage() {
        return this.graphQlInputsPackage;
    }

    public String graphQlInputsFileFolder() {
        return this.outputFolder + File.separator + this.graphQlInputsPackage().replace('.', File.separatorChar);
    }

    public String graphQlInputsFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        return this.graphQlInputsFileFolder() + File.separator + this.tographQlInputsFilename(tag) + suffix;
    }

    public String tographQlInputsFilename(String name) {
        return this.tographQlInputsName(name);
    }

    public String tographQlInputsName(String name) {
        if (name.length() == 0) {
            return "EmptyInput";
        }
        return StringUtils.camelize(name) + "Input";
    }
}

