/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractRubyCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubyClientCodegen
extends AbstractRubyCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(RubyClientCodegen.class);
    public static final String GEM_NAME = "gemName";
    public static final String MODULE_NAME = "moduleName";
    public static final String GEM_VERSION = "gemVersion";
    public static final String GEM_LICENSE = "gemLicense";
    public static final String GEM_REQUIRED_RUBY_VERSION = "gemRequiredRubyVersion";
    public static final String GEM_HOMEPAGE = "gemHomepage";
    public static final String GEM_SUMMARY = "gemSummary";
    public static final String GEM_DESCRIPTION = "gemDescription";
    public static final String GEM_AUTHOR = "gemAuthor";
    public static final String GEM_AUTHOR_EMAIL = "gemAuthorEmail";
    protected String gemName;
    protected String moduleName;
    protected String gemVersion = "1.0.0";
    protected String specFolder = "spec";
    protected String libFolder = "lib";
    protected String gemLicense = "proprietary";
    protected String gemRequiredRubyVersion = ">= 1.9";
    protected String gemHomepage = "http://org.openapitools";
    protected String gemSummary = "A ruby wrapper for the REST APIs";
    protected String gemDescription = "This gem maps to a REST API";
    protected String gemAuthor = "";
    protected String gemAuthorEmail = "";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected static int emptyMethodNameCounter = 0;

    public RubyClientCodegen() {
        this.importMapping.clear();
        this.modelPackage = "models";
        this.apiPackage = "api";
        this.outputFolder = "generated-code" + File.separator + "ruby";
        this.modelTemplateFiles.put("model.mustache", ".rb");
        this.apiTemplateFiles.put("api.mustache", ".rb");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "ruby-client";
        this.embeddedTemplateDir = "ruby-client";
        this.modelTestTemplateFiles.put("model_test.mustache", ".rb");
        this.apiTestTemplateFiles.put("api_test.mustache", ".rb");
        this.hideGenerationTimestamp = Boolean.TRUE;
        for (String word : Arrays.asList("local_var_path", "query_params", "header_params", "_header_accept", "_header_accept_result", "_header_content_type", "form_params", "post_body", "auth_names")) {
            this.reservedWords.add(word.toLowerCase(Locale.ROOT));
        }
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("array");
        this.languageSpecificPrimitives.add("map");
        this.languageSpecificPrimitives.add("string");
        this.languageSpecificPrimitives.add("BOOLEAN");
        this.typeMapping.put("boolean", "BOOLEAN");
        Iterator itr = this.cliOptions.iterator();
        while (itr.hasNext()) {
            CliOption opt = (CliOption)itr.next();
            if (!"modelPackage".equals(opt.getOpt()) && !"apiPackage".equals(opt.getOpt())) continue;
            itr.remove();
        }
        this.cliOptions.add(new CliOption(GEM_NAME, "gem name (convention: underscore_case).").defaultValue("openapi_client"));
        this.cliOptions.add(new CliOption(MODULE_NAME, "top module name (convention: CamelCase, usually corresponding to gem name).").defaultValue("OpenAPIClient"));
        this.cliOptions.add(new CliOption(GEM_VERSION, "gem version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(GEM_LICENSE, "gem license. ").defaultValue("proprietary"));
        this.cliOptions.add(new CliOption(GEM_REQUIRED_RUBY_VERSION, "gem required Ruby version. ").defaultValue(">= 1.9"));
        this.cliOptions.add(new CliOption(GEM_HOMEPAGE, "gem homepage. ").defaultValue("http://org.openapitools"));
        this.cliOptions.add(new CliOption(GEM_SUMMARY, "gem summary. ").defaultValue("A ruby wrapper for the REST APIs"));
        this.cliOptions.add(new CliOption(GEM_DESCRIPTION, "gem description. ").defaultValue("This gem maps to a REST API"));
        this.cliOptions.add(new CliOption(GEM_AUTHOR, "gem author (only one is supported)."));
        this.cliOptions.add(new CliOption(GEM_AUTHOR_EMAIL, "gem author email (only one is supported)."));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(GEM_NAME)) {
            this.setGemName((String)this.additionalProperties.get(GEM_NAME));
        }
        if (this.additionalProperties.containsKey(MODULE_NAME)) {
            this.setModuleName((String)this.additionalProperties.get(MODULE_NAME));
        }
        if (this.gemName == null && this.moduleName == null) {
            this.setGemName("openapi_client");
            this.setModuleName(this.generateModuleName(this.gemName));
        } else if (this.gemName == null) {
            this.setGemName(this.generateGemName(this.moduleName));
        } else if (this.moduleName == null) {
            this.setModuleName(this.generateModuleName(this.gemName));
        }
        this.additionalProperties.put(GEM_NAME, this.gemName);
        this.additionalProperties.put(MODULE_NAME, this.moduleName);
        if (this.additionalProperties.containsKey(GEM_VERSION)) {
            this.setGemVersion((String)this.additionalProperties.get(GEM_VERSION));
        } else {
            this.additionalProperties.put(GEM_VERSION, this.gemVersion);
        }
        if (this.additionalProperties.containsKey(GEM_LICENSE)) {
            this.setGemLicense((String)this.additionalProperties.get(GEM_LICENSE));
        }
        if (this.additionalProperties.containsKey(GEM_REQUIRED_RUBY_VERSION)) {
            this.setGemRequiredRubyVersion((String)this.additionalProperties.get(GEM_REQUIRED_RUBY_VERSION));
        }
        if (this.additionalProperties.containsKey(GEM_HOMEPAGE)) {
            this.setGemHomepage((String)this.additionalProperties.get(GEM_HOMEPAGE));
        }
        if (this.additionalProperties.containsKey(GEM_SUMMARY)) {
            this.setGemSummary((String)this.additionalProperties.get(GEM_SUMMARY));
        }
        if (this.additionalProperties.containsKey(GEM_DESCRIPTION)) {
            this.setGemDescription((String)this.additionalProperties.get(GEM_DESCRIPTION));
        }
        if (this.additionalProperties.containsKey(GEM_AUTHOR)) {
            this.setGemAuthor((String)this.additionalProperties.get(GEM_AUTHOR));
        }
        if (this.additionalProperties.containsKey(GEM_AUTHOR_EMAIL)) {
            this.setGemAuthorEmail((String)this.additionalProperties.get(GEM_AUTHOR_EMAIL));
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.setModelPackage("models");
        this.setApiPackage("api");
        this.supportingFiles.add(new SupportingFile("gemspec.mustache", "", this.gemName + ".gemspec"));
        this.supportingFiles.add(new SupportingFile("gem.mustache", this.libFolder, this.gemName + ".rb"));
        String gemFolder = this.libFolder + File.separator + this.gemName;
        this.supportingFiles.add(new SupportingFile("api_client.mustache", gemFolder, "api_client.rb"));
        this.supportingFiles.add(new SupportingFile("api_error.mustache", gemFolder, "api_error.rb"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", gemFolder, "configuration.rb"));
        this.supportingFiles.add(new SupportingFile("version.mustache", gemFolder, "version.rb"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("Rakefile.mustache", "", "Rakefile"));
        this.supportingFiles.add(new SupportingFile("Gemfile.mustache", "", "Gemfile"));
        this.supportingFiles.add(new SupportingFile("rubocop.mustache", "", ".rubocop.yml"));
        this.writeOptional(this.outputFolder, new SupportingFile("rspec.mustache", "", ".rspec"));
        this.writeOptional(this.outputFolder, new SupportingFile("spec_helper.mustache", this.specFolder, "spec_helper.rb"));
        this.writeOptional(this.outputFolder, new SupportingFile("configuration_spec.mustache", this.specFolder, "configuration_spec.rb"));
        this.writeOptional(this.outputFolder, new SupportingFile("api_client_spec.mustache", this.specFolder, "api_client_spec.rb"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "ruby";
    }

    @Override
    public String getHelp() {
        return "Generates a Ruby client library.";
    }

    public String generateModuleName(String gemName) {
        return RubyClientCodegen.camelize(gemName.replaceAll("[^\\w]+", "_"));
    }

    public String generateGemName(String moduleName) {
        return RubyClientCodegen.underscore(moduleName.replaceAll("[^\\w]+", ""));
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.libFolder + File.separator + this.gemName + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.libFolder + File.separator + this.gemName + File.separator + this.modelPackage.replace("/", File.separator);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder + File.separator + this.modelPackage.replace("/", File.separator);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String getSchemaType(Schema schema) {
        String openAPIType = super.getSchemaType(schema);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        if (type == null) {
            return null;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name)) {
            String modelName = RubyClientCodegen.camelize("Model" + name);
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + RubyClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return RubyClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return RubyClientCodegen.underscore(this.toModelName(name));
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return RubyClientCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "_spec";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "_spec";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return RubyClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Float".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("Integer".equals(datatype) || "Float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String enumName = this.sanitizeName(RubyClientCodegen.underscore(name).toUpperCase(Locale.ROOT));
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return "N" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = RubyClientCodegen.underscore(this.toModelName(property.name)).toUpperCase(Locale.ROOT);
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return "N" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            operationId = RubyClientCodegen.underscore("empty_method_name_" + emptyMethodNameCounter++);
            LOGGER.warn("Empty method name (operationId) found. Renamed to " + operationId);
            return operationId;
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = RubyClientCodegen.underscore("call_" + operationId);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + RubyClientCodegen.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return RubyClientCodegen.underscore(this.sanitizeName(operationId));
    }

    @Override
    public String toApiImport(String name) {
        return this.gemName + "/" + this.apiPackage() + "/" + this.toApiFilename(name);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        String example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equals(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("Integer".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equals(type)) {
            if (example == null) {
                example = "true";
            }
        } else if ("File".equals(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "File.new('" + this.escapeText(example) + "')";
        } else if ("Date".equals(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "Date.parse('" + this.escapeText(example) + "')";
        } else if ("DateTime".equals(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "DateTime.parse('" + this.escapeText(example) + "')";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = this.moduleName + "::" + type + ".new";
        }
        if (example == null) {
            example = "nil";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            example = "[" + example + "]";
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = "{'key' => " + example + "}";
        }
        p.example = example;
    }

    public void setGemName(String gemName) {
        this.gemName = gemName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setGemVersion(String gemVersion) {
        this.gemVersion = gemVersion;
    }

    public void setGemDescription(String gemDescription) {
        this.gemDescription = gemDescription;
    }

    public void setGemSummary(String gemSummary) {
        this.gemSummary = gemSummary;
    }

    public void setGemLicense(String gemLicense) {
        this.gemLicense = gemLicense;
    }

    public void setGemRequiredRubyVersion(String gemRequiredRubyVersion) {
        this.gemRequiredRubyVersion = gemRequiredRubyVersion;
    }

    public void setGemHomepage(String gemHomepage) {
        this.gemHomepage = gemHomepage;
    }

    public void setGemAuthor(String gemAuthor) {
        this.gemAuthor = gemAuthor;
    }

    public void setGemAuthorEmail(String gemAuthorEmail) {
        this.gemAuthorEmail = gemAuthorEmail;
    }

    @Override
    public boolean shouldOverwrite(String filename) {
        return !this.skipOverwrite || !new File(filename).exists();
    }
}

