/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGoCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGoCodegen.class);
    protected boolean withGoCodegenComment = false;
    protected boolean withXml = false;
    protected String packageName = "openapi";

    public AbstractGoCodegen() {
        this.hideGenerationTimestamp = Boolean.FALSE;
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.setReservedWordsLowerCase(Arrays.asList("string", "bool", "uint", "uint8", "uint16", "uint32", "uint64", "int", "int8", "int16", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte", "uintptr", "break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var", "error", "nil"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("string", "bool", "uint", "uint32", "uint64", "int", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int32");
        this.typeMapping.put("long", "int64");
        this.typeMapping.put("number", "float32");
        this.typeMapping.put("float", "float32");
        this.typeMapping.put("double", "float64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "time.Time");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("File", "*os.File");
        this.typeMapping.put("file", "*os.File");
        this.typeMapping.put("binary", "*os.File");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("object", "map[string]interface{}");
        this.importMapping = new HashMap();
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Go package name (convention: lowercase).").defaultValue("openapi"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return AbstractGoCodegen.camelize(name) + '_';
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = AbstractGoCodegen.camelize(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as variable name. Renamed to " + this.escapeReservedWord(name));
            name = this.escapeReservedWord(name);
        }
        if (name.matches("^\\d.*")) {
            name = "Var" + name;
        }
        return name;
    }

    @Override
    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word);
    }

    @Override
    public String toParamName(String name) {
        if (this.isReservedWord(name = AbstractGoCodegen.camelize(this.toVarName(name), true))) {
            LOGGER.warn(name + " (reserved word) cannot be used as parameter name. Renamed to " + name + "_");
            name = name + "_";
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        return AbstractGoCodegen.camelize(this.toModel(name));
    }

    @Override
    public String toModelFilename(String name) {
        name = this.toModel("model_" + name);
        if (name.endsWith("_test")) {
            LOGGER.warn(name + ".go with `_test.go` suffix (reserved word) cannot be used as filename. Renamed to " + name + "_.go");
            name = name + "_";
        }
        return name;
    }

    public String toModel(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        return AbstractGoCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        name = "api_" + AbstractGoCodegen.underscore(name);
        if (name.endsWith("_test")) {
            LOGGER.warn(name + ".go with `_test.go` suffix (reserved word) cannot be used as filename. Renamed to " + name + "_.go");
            name = name + "_";
        }
        return name;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "[]" + this.getTypeDeclaration(inner);
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[string]" + this.getTypeDeclaration(inner);
        }
        String openAPIType = this.getSchemaType(p);
        String ref = p.get$ref();
        if (ref != null && !ref.isEmpty()) {
            String tryRefV2 = "#/definitions/" + openAPIType;
            String tryRefV3 = "#/components/schemas/" + openAPIType;
            if (ref.equals(tryRefV2) || ref.equals(tryRefV3)) {
                return this.toModelName(openAPIType);
            }
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if (this.typeMapping.containsValue(openAPIType)) {
            return openAPIType;
        }
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return openAPIType;
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String ref = p.get$ref();
        String type = null;
        if (ref != null && !ref.isEmpty()) {
            type = openAPIType;
        } else if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        String sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord(sanitizedOperationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + AbstractGoCodegen.camelize("call_" + sanitizedOperationId));
            sanitizedOperationId = "call_" + sanitizedOperationId;
        }
        if (sanitizedOperationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + AbstractGoCodegen.camelize("call_" + sanitizedOperationId));
            sanitizedOperationId = "call_" + sanitizedOperationId;
        }
        return AbstractGoCodegen.camelize(sanitizedOperationId);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation operation : operations) {
            operation.httpMethod = AbstractGoCodegen.camelize(operation.httpMethod.toLowerCase(Locale.ROOT));
        }
        List imports = (List)objs.get("imports");
        if (imports == null) {
            return objs;
        }
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(this.apiPackage())) continue;
            iterator.remove();
        }
        for (CodegenOperation operation : operations) {
            if (operation.pathParams == null || operation.pathParams.size() <= 0) continue;
            imports.add(this.createMapping("import", "fmt"));
            break;
        }
        boolean addedOptionalImport = false;
        boolean addedTimeImport = false;
        boolean addedOSImport = false;
        for (CodegenOperation operation : operations) {
            for (CodegenParameter param : operation.allParams) {
                char nameFirstChar;
                if (!addedOSImport && "*os.File".equals(param.dataType)) {
                    imports.add(this.createMapping("import", "os"));
                    addedOSImport = true;
                }
                if (param.required && !addedTimeImport && "time.Time".equals(param.dataType)) {
                    imports.add(this.createMapping("import", "time"));
                    addedTimeImport = true;
                }
                if (!param.required && param.isPrimitiveType) {
                    if (!addedOptionalImport) {
                        imports.add(this.createMapping("import", "github.com/antihax/optional"));
                        addedOptionalImport = true;
                    }
                    if ("time.Time".equals(param.dataType)) {
                        param.vendorExtensions.put("x-optionalDataType", "Time");
                    } else {
                        param.vendorExtensions.put("x-optionalDataType", param.dataType.substring(0, 1).toUpperCase(Locale.ROOT) + param.dataType.substring(1));
                    }
                }
                if (Character.isUpperCase(nameFirstChar = param.paramName.charAt(0))) {
                    param.vendorExtensions.put("x-exportParamName", param.paramName);
                    continue;
                }
                StringBuilder sb = new StringBuilder(param.paramName);
                sb.setCharAt(0, Character.toUpperCase(nameFirstChar));
                param.vendorExtensions.put("x-exportParamName", sb.toString());
            }
            this.setExportParameterName(operation.queryParams);
            this.setExportParameterName(operation.formParams);
            this.setExportParameterName(operation.headerParams);
            this.setExportParameterName(operation.bodyParams);
            this.setExportParameterName(operation.cookieParams);
            this.setExportParameterName(operation.optionalParams);
            this.setExportParameterName(operation.requiredParams);
        }
        List recursiveImports = (List)objs.get("imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return objs;
    }

    private void setExportParameterName(List<CodegenParameter> codegenParameters) {
        for (CodegenParameter param : codegenParameters) {
            char nameFirstChar = param.paramName.charAt(0);
            if (Character.isUpperCase(nameFirstChar)) {
                param.vendorExtensions.put("x-exportParamName", param.paramName);
                continue;
            }
            StringBuilder sb = new StringBuilder(param.paramName);
            sb.setCharAt(0, Character.toUpperCase(nameFirstChar));
            param.vendorExtensions.put("x-exportParamName", sb.toString());
        }
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List imports = (List)objs.get("imports");
        String prefix = this.modelPackage();
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(prefix)) continue;
            iterator.remove();
        }
        boolean addedTimeImport = false;
        boolean addedOSImport = false;
        List models = (List)objs.get("models");
        for (Map m : models) {
            Object v = m.get("model");
            if (!(v instanceof CodegenModel)) continue;
            CodegenModel model = (CodegenModel)v;
            for (CodegenProperty param : model.vars) {
                if (!addedTimeImport && "time.Time".equals(param.baseType)) {
                    imports.add(this.createMapping("import", "time"));
                    addedTimeImport = true;
                }
                if (addedOSImport || !"*os.File".equals(param.baseType)) continue;
                imports.add(this.createMapping("import", "os"));
                addedOSImport = true;
            }
        }
        List recursiveImports = (List)objs.get("imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, value);
        return customImport;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase(Locale.ROOT);
        }
        String enumName = this.sanitizeName(AbstractGoCodegen.underscore(name).toUpperCase(Locale.ROOT));
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", ""))) {
            return this.escapeReservedWord(enumName);
        }
        if (enumName.matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = AbstractGoCodegen.underscore(this.toModelName(property.name)).toUpperCase(Locale.ROOT);
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    public void setWithGoCodegenComment(boolean withGoCodegenComment) {
        this.withGoCodegenComment = withGoCodegenComment;
    }

    public void setWithXml(boolean withXml) {
        this.withXml = withXml;
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema.getDefault() != null) {
            return schema.getDefault().toString();
        }
        return null;
    }
}

