/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.Strings;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavascriptClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavascriptClientCodegen.class);
    public static final String PROJECT_NAME = "projectName";
    public static final String MODULE_NAME = "moduleName";
    public static final String PROJECT_DESCRIPTION = "projectDescription";
    public static final String PROJECT_VERSION = "projectVersion";
    public static final String USE_PROMISES = "usePromises";
    public static final String USE_INHERITANCE = "useInheritance";
    public static final String EMIT_MODEL_METHODS = "emitModelMethods";
    public static final String EMIT_JS_DOC = "emitJSDoc";
    public static final String USE_ES6 = "useES6";
    final String[][] JAVASCRIPT_SUPPORTING_FILES = new String[][]{{"package.mustache", "package.json"}, {"index.mustache", "src/index.js"}, {"ApiClient.mustache", "src/ApiClient.js"}, {"git_push.sh.mustache", "git_push.sh"}, {"README.mustache", "README.md"}, {"mocha.opts", "mocha.opts"}, {"travis.yml", ".travis.yml"}};
    final String[][] JAVASCRIPT_ES6_SUPPORTING_FILES = new String[][]{{"package.mustache", "package.json"}, {"index.mustache", "src/index.js"}, {"ApiClient.mustache", "src/ApiClient.js"}, {"git_push.sh.mustache", "git_push.sh"}, {"README.mustache", "README.md"}, {"mocha.opts", "mocha.opts"}, {"travis.yml", ".travis.yml"}, {".babelrc.mustache", ".babelrc"}};
    protected String projectName;
    protected String moduleName;
    protected String projectDescription;
    protected String projectVersion;
    protected String licenseName;
    protected String invokerPackage;
    protected String sourceFolder = "src";
    protected String localVariablePrefix = "";
    protected boolean usePromises;
    protected boolean emitModelMethods;
    protected boolean emitJSDoc = true;
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String apiTestPath = "api/";
    protected String modelTestPath = "model/";
    protected boolean useES6 = false;
    private String modelPropertyNaming = "camelCase";

    public JavascriptClientCodegen() {
        this.outputFolder = "generated-code/js";
        this.modelTemplateFiles.put("model.mustache", ".js");
        this.modelTestTemplateFiles.put("model_test.mustache", ".js");
        this.apiTemplateFiles.put("api.mustache", ".js");
        this.apiTestTemplateFiles.put("api_test.mustache", ".js");
        this.embeddedTemplateDir = this.templateDir = "Javascript" + File.separator + "es6";
        this.apiPackage = "api";
        this.modelPackage = "model";
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "arguments", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "eval", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield", "Array", "Date", "eval", "function", "hasOwnProperty", "Infinity", "isFinite", "isNaN", "isPrototypeOf", "Math", "NaN", "Number", "Object", "prototype", "String", "toString", "undefined", "valueOf"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "Boolean", "Number", "Array", "Object", "Date", "File", "Blob"));
        this.defaultIncludes = new HashSet(this.languageSpecificPrimitives);
        this.instantiationTypes.put("array", "Array");
        this.instantiationTypes.put("list", "Array");
        this.instantiationTypes.put("map", "Object");
        this.typeMapping.clear();
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("map", "Object");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Number");
        this.typeMapping.put("float", "Number");
        this.typeMapping.put("number", "Number");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("long", "Number");
        this.typeMapping.put("short", "Number");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("double", "Number");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "Number");
        this.typeMapping.put("ByteArray", "Blob");
        this.typeMapping.put("binary", "File");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("UUID", "String");
        this.importMapping.clear();
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code").defaultValue("src"));
        this.cliOptions.add(new CliOption("localVariablePrefix", "prefix for generated code members and local variables"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption(PROJECT_NAME, "name of the project (Default: generated from info.title or \"openapi-js-client\")"));
        this.cliOptions.add(new CliOption(MODULE_NAME, "module name for AMD, Node or globals (Default: generated from <projectName>)"));
        this.cliOptions.add(new CliOption(PROJECT_DESCRIPTION, "description of the project (Default: using info.description or \"Client library of <projectName>\")"));
        this.cliOptions.add(new CliOption(PROJECT_VERSION, "version of the project (Default: using info.version or \"1.0.0\")"));
        this.cliOptions.add(new CliOption("licenseName", "name of the license the project uses (Default: using info.license.name)"));
        this.cliOptions.add(new CliOption(USE_PROMISES, "use Promises as return values from the client API, instead of superagent callbacks").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(EMIT_MODEL_METHODS, "generate getters and setters for model properties").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(EMIT_JS_DOC, "generate JSDoc comments").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(USE_INHERITANCE, "use JavaScript prototype chains & delegation for inheritance").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(USE_ES6, "use JavaScript ES6 (ECMAScript 6) (beta). Default is ES5.").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name").defaultValue("camelCase"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "javascript";
    }

    @Override
    public String getHelp() {
        return "Generates a Javascript client library.";
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey(USE_ES6)) {
            this.setUseES6(this.convertPropertyToBooleanAndWriteBack(USE_ES6));
        } else {
            this.setUseES6(false);
        }
        super.processOpts();
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.setProjectName((String)this.additionalProperties.get(PROJECT_NAME));
        }
        if (this.additionalProperties.containsKey(MODULE_NAME)) {
            this.setModuleName((String)this.additionalProperties.get(MODULE_NAME));
        }
        if (this.additionalProperties.containsKey(PROJECT_DESCRIPTION)) {
            this.setProjectDescription((String)this.additionalProperties.get(PROJECT_DESCRIPTION));
        }
        if (this.additionalProperties.containsKey(PROJECT_VERSION)) {
            this.setProjectVersion((String)this.additionalProperties.get(PROJECT_VERSION));
        }
        if (this.additionalProperties.containsKey("licenseName")) {
            this.setLicenseName((String)this.additionalProperties.get("licenseName"));
        }
        if (this.additionalProperties.containsKey("localVariablePrefix")) {
            this.setLocalVariablePrefix((String)this.additionalProperties.get("localVariablePrefix"));
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
        }
        if (this.additionalProperties.containsKey(USE_PROMISES)) {
            this.setUsePromises(this.convertPropertyToBooleanAndWriteBack(USE_PROMISES));
        }
        if (this.additionalProperties.containsKey(USE_INHERITANCE)) {
            this.setUseInheritance(this.convertPropertyToBooleanAndWriteBack(USE_INHERITANCE));
        } else {
            this.supportsInheritance = true;
            this.supportsMixins = true;
        }
        if (this.additionalProperties.containsKey(EMIT_MODEL_METHODS)) {
            this.setEmitModelMethods(this.convertPropertyToBooleanAndWriteBack(EMIT_MODEL_METHODS));
        }
        if (this.additionalProperties.containsKey(EMIT_JS_DOC)) {
            this.setEmitJSDoc(this.convertPropertyToBooleanAndWriteBack(EMIT_JS_DOC));
        }
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            if (StringUtils.isBlank((CharSequence)this.projectName) && info.getTitle() != null) {
                this.projectName = this.sanitizeName(this.dashize(info.getTitle()));
            }
            if (StringUtils.isBlank((CharSequence)this.projectVersion)) {
                this.projectVersion = this.escapeUnsafeCharacters(this.escapeQuotationMark(info.getVersion()));
            }
            if (this.projectDescription == null) {
                this.projectDescription = this.sanitizeName(info.getDescription());
            }
            if (this.additionalProperties.get("licenseName") == null && info.getLicense() != null) {
                License license = info.getLicense();
                this.licenseName = license.getName();
            }
        }
        if (StringUtils.isBlank((CharSequence)this.projectName)) {
            this.projectName = "openapi-js-client";
        }
        if (StringUtils.isBlank((CharSequence)this.moduleName)) {
            this.moduleName = JavascriptClientCodegen.camelize(JavascriptClientCodegen.underscore(this.projectName));
        }
        if (StringUtils.isBlank((CharSequence)this.projectVersion)) {
            this.projectVersion = "1.0.0";
        }
        if (this.projectDescription == null) {
            this.projectDescription = "Client library of " + this.projectName;
        }
        if (StringUtils.isBlank((CharSequence)this.licenseName)) {
            this.licenseName = "Unlicense";
        }
        this.additionalProperties.put(PROJECT_NAME, this.projectName);
        this.additionalProperties.put(MODULE_NAME, this.moduleName);
        this.additionalProperties.put(PROJECT_DESCRIPTION, this.escapeText(this.projectDescription));
        this.additionalProperties.put(PROJECT_VERSION, this.projectVersion);
        this.additionalProperties.put("licenseName", this.licenseName);
        this.additionalProperties.put("apiPackage", this.apiPackage);
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("localVariablePrefix", this.localVariablePrefix);
        this.additionalProperties.put("modelPackage", this.modelPackage);
        this.additionalProperties.put("sourceFolder", this.sourceFolder);
        this.additionalProperties.put(USE_PROMISES, this.usePromises);
        this.additionalProperties.put(USE_INHERITANCE, this.supportsInheritance);
        this.additionalProperties.put(EMIT_MODEL_METHODS, this.emitModelMethods);
        this.additionalProperties.put(EMIT_JS_DOC, this.emitJSDoc);
        this.additionalProperties.put(USE_ES6, this.useES6);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        String[][] supportingTemplateFiles = this.JAVASCRIPT_SUPPORTING_FILES;
        if (this.useES6) {
            supportingTemplateFiles = this.JAVASCRIPT_ES6_SUPPORTING_FILES;
        }
        for (String[] supportingTemplateFile : supportingTemplateFiles) {
            this.supportingFiles.add(new SupportingFile(supportingTemplateFile[0], "", supportingTemplateFile[1]));
        }
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    private String createPath(String ... segments) {
        StringBuilder buf = new StringBuilder();
        for (String segment : segments) {
            if (StringUtils.isEmpty((CharSequence)segment) || segment.equals(".")) continue;
            if (buf.length() != 0) {
                buf.append(File.separatorChar);
            }
            buf.append(segment);
        }
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c != '/' && c != '\\' || c == File.separatorChar) continue;
            buf.setCharAt(i, File.separatorChar);
        }
        return buf.toString();
    }

    @Override
    public String apiTestFileFolder() {
        return (this.outputFolder + "/test/" + this.apiTestPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return (this.outputFolder + "/test/" + this.modelTestPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.createPath(this.outputFolder, this.sourceFolder, this.invokerPackage, this.apiPackage());
    }

    @Override
    public String modelFileFolder() {
        return this.createPath(this.outputFolder, this.sourceFolder, this.invokerPackage, this.modelPackage());
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setLocalVariablePrefix(String localVariablePrefix) {
        this.localVariablePrefix = localVariablePrefix;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setUsePromises(boolean usePromises) {
        this.usePromises = usePromises;
    }

    public void setUseES6(boolean useES6) {
        this.useES6 = useES6;
        if (useES6) {
            this.templateDir = "Javascript/es6";
            this.embeddedTemplateDir = "Javascript/es6";
            LOGGER.info("Using JS ES6 templates");
        } else {
            this.templateDir = "Javascript";
            this.embeddedTemplateDir = "Javascript";
            LOGGER.info("Using JS ES5 templates");
        }
    }

    public void setUseInheritance(boolean useInheritance) {
        this.supportsInheritance = useInheritance;
        this.supportsMixins = useInheritance;
    }

    public void setEmitModelMethods(boolean emitModelMethods) {
        this.emitModelMethods = emitModelMethods;
    }

    public void setEmitJSDoc(boolean emitJSDoc) {
        this.emitJSDoc = emitJSDoc;
    }

    @Override
    public String apiDocFileFolder() {
        return this.createPath(this.outputFolder, this.apiDocPath);
    }

    @Override
    public String modelDocFileFolder() {
        return this.createPath(this.outputFolder, this.modelDocPath);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + ".spec";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + ".spec";
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    private String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return JavascriptClientCodegen.camelize(name, true);
            }
            case PascalCase: {
                return JavascriptClientCodegen.camelize(name);
            }
            case snake_case: {
                return JavascriptClientCodegen.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public String toVarName(String name) {
        if ("_".equals(name = this.sanitizeName(name))) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = JavascriptClientCodegen.camelize(name))) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toModelImport(String name) {
        return name;
    }

    @Override
    public String toApiImport(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return "{String: " + this.getTypeDeclaration(inner) + "}";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
                return "'" + p.getDefault() + "'";
            }
        }
        return null;
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    @Override
    public String toDefaultValueWithParam(String name, Schema p) {
        String type = this.normalizeType(this.getTypeDeclaration(p));
        if (!StringUtils.isEmpty((CharSequence)p.get$ref())) {
            return " = " + type + ".constructFromObject(data['" + name + "']);";
        }
        return " = ApiClient.convertToType(data['" + name + "'], " + type + ");";
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if (Boolean.TRUE.equals(p.isInteger)) {
            if (example == null) {
                example = "56";
            }
        } else if (Boolean.TRUE.equals(p.isLong)) {
            if (example == null) {
                example = "789";
            }
        } else if (Boolean.TRUE.equals(p.isDouble) || Boolean.TRUE.equals(p.isFloat) || Boolean.TRUE.equals(p.isNumber)) {
            if (example == null) {
                example = "3.4";
            }
        } else if (Boolean.TRUE.equals(p.isBoolean)) {
            if (example == null) {
                example = "true";
            }
        } else if (Boolean.TRUE.equals(p.isFile) || Boolean.TRUE.equals(p.isBinary)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if (Boolean.TRUE.equals(p.isDate)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "new Date(\"" + this.escapeText(example) + "\")";
        } else if (Boolean.TRUE.equals(p.isDateTime)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "new Date(\"" + this.escapeText(example) + "\")";
        } else if (Boolean.TRUE.equals(p.isString)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + this.moduleName + "." + type + "()";
        }
        if (Boolean.TRUE.equals(p.isListContainer)) {
            example = this.setPropertyExampleValue(p.items);
            example = "[" + example + "]";
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = this.setPropertyExampleValue(p.items);
            example = "{key: " + example + "}";
        } else if (example == null) {
            example = "null";
        }
        p.example = example;
    }

    protected String setPropertyExampleValue(CodegenProperty p) {
        if (p == null) {
            return "null";
        }
        String example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if (Boolean.TRUE.equals(p.isInteger)) {
            if (example == null) {
                example = "56";
            }
        } else if (Boolean.TRUE.equals(p.isLong)) {
            if (example == null) {
                example = "789";
            }
        } else if (Boolean.TRUE.equals(p.isDouble) || Boolean.TRUE.equals(p.isFloat) || Boolean.TRUE.equals(p.isNumber)) {
            if (example == null) {
                example = "3.4";
            }
        } else if (Boolean.TRUE.equals(p.isBoolean)) {
            if (example == null) {
                example = "true";
            }
        } else if (Boolean.TRUE.equals(p.isFile) || Boolean.TRUE.equals(p.isBinary)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if (Boolean.TRUE.equals(p.isDate)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "new Date(\"" + this.escapeText(example) + "\")";
        } else if (Boolean.TRUE.equals(p.isDateTime)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "new Date(\"" + this.escapeText(example) + "\")";
        } else if (Boolean.TRUE.equals(p.isString)) {
            if (example == null) {
                example = p.name + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + this.moduleName + "." + type + "()";
        }
        return example;
    }

    public String normalizeType(String type) {
        return type.replaceAll("\\b(Boolean|Integer|Number|String|Date|Blob)\\b", "'$1'");
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (!this.needToImport(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        if (null == type) {
            LOGGER.error("No Type defined for Schema " + p);
        }
        return this.toModelName(type);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = JavascriptClientCodegen.camelize(this.sanitizeName(operationId), true))) {
            String newOperationId = JavascriptClientCodegen.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            String newOperationId = JavascriptClientCodegen.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return operationId;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model, Map<String, Schema> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        if (allDefinitions != null && codegenModel != null && codegenModel.parent != null && codegenModel.hasEnums) {
            Schema parentModel = allDefinitions.get(codegenModel.parentSchema);
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel, allDefinitions);
            codegenModel = JavascriptClientCodegen.reconcileInlineEnums(codegenModel, parentCodegenModel);
        }
        if (ModelUtils.isArraySchema(model)) {
            ArraySchema am = (ArraySchema)model;
            if (am.getItems() != null) {
                codegenModel.getVendorExtensions().put("x-isArray", true);
                codegenModel.getVendorExtensions().put("x-itemType", this.getSchemaType(am.getItems()));
            }
        } else if (ModelUtils.isMapSchema(model)) {
            if (model.getAdditionalProperties() != null) {
                codegenModel.getVendorExtensions().put("x-isMap", true);
                codegenModel.getVendorExtensions().put("x-itemType", this.getSchemaType((Schema)model.getAdditionalProperties()));
            } else {
                String type = model.getType();
                if (this.isPrimitiveType(type)) {
                    codegenModel.vendorExtensions.put("x-isPrimitive", true);
                }
            }
        }
        return codegenModel;
    }

    private String sanitizePath(String p) {
        return p.replaceAll("'", "%27");
    }

    private String trimBrackets(String s) {
        if (s != null) {
            int beginIdx = s.charAt(0) == '[' ? 1 : 0;
            int endIdx = s.length();
            if (s.charAt(endIdx - 1) == ']') {
                --endIdx;
            }
            return s.substring(beginIdx, endIdx);
        }
        return null;
    }

    private String getModelledType(String dataType) {
        return "module:" + (StringUtils.isEmpty((CharSequence)this.invokerPackage) ? "" : this.invokerPackage + "/") + (StringUtils.isEmpty((CharSequence)this.modelPackage) ? "" : this.modelPackage + "/") + dataType;
    }

    private String getJSDocType(CodegenModel cm, CodegenProperty cp) {
        if (Boolean.TRUE.equals(cp.isContainer)) {
            if (cp.containerType.equals("array")) {
                return "Array.<" + this.getJSDocType(cm, cp.items) + ">";
            }
            if (cp.containerType.equals("map")) {
                return "Object.<String, " + this.getJSDocType(cm, cp.items) + ">";
            }
        }
        String dataType = this.trimBrackets(cp.datatypeWithEnum);
        if (cp.isEnum) {
            dataType = cm.classname + '.' + dataType;
        }
        if (this.isModelledType(cp)) {
            dataType = this.getModelledType(dataType);
        }
        return dataType;
    }

    private boolean isModelledType(CodegenProperty cp) {
        return cp.isEnum || !this.languageSpecificPrimitives.contains(cp.baseType == null ? cp.dataType : cp.baseType);
    }

    private String getJSDocType(CodegenParameter cp) {
        String dataType = this.trimBrackets(cp.dataType);
        if (this.isModelledType(cp)) {
            dataType = this.getModelledType(dataType);
        }
        if (Boolean.TRUE.equals(cp.isListContainer)) {
            return "Array.<" + dataType + ">";
        }
        if (Boolean.TRUE.equals(cp.isMapContainer)) {
            return "Object.<String, " + dataType + ">";
        }
        return dataType;
    }

    private boolean isModelledType(CodegenParameter cp) {
        return cp.isEnum || !this.languageSpecificPrimitives.contains(cp.baseType == null ? cp.dataType : cp.baseType);
    }

    private String getJSDocType(CodegenOperation co) {
        String returnType = this.trimBrackets(co.returnType);
        if (returnType != null) {
            if (this.isModelledType(co)) {
                returnType = this.getModelledType(returnType);
            }
            if (Boolean.TRUE.equals(co.isListContainer)) {
                return "Array.<" + returnType + ">";
            }
            if (Boolean.TRUE.equals(co.isMapContainer)) {
                return "Object.<String, " + returnType + ">";
            }
        }
        return returnType;
    }

    private boolean isModelledType(CodegenOperation co) {
        return !Boolean.TRUE.equals(co.returnTypeIsPrimitive);
    }

    private boolean isPrimitiveType(String type) {
        String[] primitives = new String[]{"number", "integer", "string", "boolean", "null"};
        return Arrays.asList(primitives).contains(type);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                ArrayList<String> argList = new ArrayList<String>();
                boolean hasOptionalParams = false;
                for (CodegenParameter p : operation.allParams) {
                    if (p.required) {
                        argList.add(p.paramName);
                        continue;
                    }
                    hasOptionalParams = true;
                }
                if (hasOptionalParams) {
                    argList.add("opts");
                }
                if (!this.usePromises) {
                    argList.add("callback");
                }
                operation.vendorExtensions.put("x-codegen-argList", StringUtils.join(argList, (String)", "));
                for (CodegenParameter cp : operation.allParams) {
                    String jsdocType = this.getJSDocType(cp);
                    cp.vendorExtensions.put("x-jsdoc-type", jsdocType);
                }
                String jsdocType = this.getJSDocType(operation);
                operation.vendorExtensions.put("x-jsdoc-type", jsdocType);
                if (operation.returnType == null) continue;
                operation.vendorExtensions.put("x-return-type", this.normalizeType(operation.returnType));
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            ArrayList<CodegenProperty> required = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> allRequired = this.supportsInheritance || this.supportsMixins ? new ArrayList<CodegenProperty>() : required;
            cm.vendorExtensions.put("x-required", required);
            cm.vendorExtensions.put("x-all-required", allRequired);
            for (CodegenProperty var : cm.vars) {
                String jsDocType = this.getJSDocType(cm, var);
                var.vendorExtensions.put("x-jsdoc-type", jsDocType);
                if (!Boolean.TRUE.equals(var.required)) continue;
                required.add(var);
            }
            if (this.supportsInheritance || this.supportsMixins) {
                for (CodegenProperty var : cm.allVars) {
                    if (!Boolean.TRUE.equals(var.required)) continue;
                    allRequired.add(var);
                }
            }
            CodegenProperty lastRequired = null;
            for (CodegenProperty var : cm.vars) {
                if (!var.required) continue;
                lastRequired = var;
            }
            for (CodegenProperty var : cm.vars) {
                if (var == lastRequired) {
                    var.vendorExtensions.put("x-codegen-hasMoreRequired", false);
                    continue;
                }
                if (!var.required) continue;
                var.vendorExtensions.put("x-codegen-hasMoreRequired", true);
            }
        }
        return objs;
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    private static CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (parentCodegenModel.hasEnums) {
            List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
            List<CodegenProperty> codegenProperties = codegenModel.vars;
            boolean removedChildEnum = false;
            for (CodegenProperty parentModelCodegenPropery : parentModelCodegenProperties) {
                if (!parentModelCodegenPropery.isEnum) continue;
                Iterator<CodegenProperty> iterator = codegenProperties.iterator();
                while (iterator.hasNext()) {
                    CodegenProperty codegenProperty = iterator.next();
                    if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenPropery)) continue;
                    iterator.remove();
                    removedChildEnum = true;
                }
            }
            if (removedChildEnum) {
                int count = 0;
                int numVars = codegenProperties.size();
                for (CodegenProperty codegenProperty : codegenProperties) {
                    codegenProperty.hasMore = ++count < numVars;
                }
                codegenModel.vars = codegenProperties;
            }
        }
        return codegenModel;
    }

    private static String sanitizePackageName(String packageName) {
        packageName = packageName.trim();
        if (Strings.isNullOrEmpty((String)(packageName = packageName.replaceAll("[^a-zA-Z0-9_\\.]", "_")))) {
            return "invalidPackageName";
        }
        return packageName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(JavascriptClientCodegen.camelize(property.name)) + "Enum";
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "empty";
        }
        if (this.getSymbolName(value) != null) {
            return this.getSymbolName(value).toUpperCase();
        }
        return value;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Number".equals(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "").replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

