/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubySinatraServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RubySinatraServerCodegen.class);
    protected String gemName;
    protected String moduleName;
    protected String gemVersion = "1.0.0";
    protected String libFolder = "lib";

    public RubySinatraServerCodegen() {
        this.apiPackage = "lib";
        this.outputFolder = "generated-code" + File.separator + "sinatra";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.put("api.mustache", ".rb");
        this.templateDir = "sinatra";
        this.embeddedTemplateDir = "sinatra";
        this.typeMapping.clear();
        this.languageSpecificPrimitives.clear();
        this.setReservedWordsLowerCase(Arrays.asList("__FILE__", "and", "def", "end", "in", "or", "self", "unless", "__LINE__", "begin", "defined?", "ensure", "module", "redo", "super", "until", "BEGIN", "break", "do", "false", "next", "rescue", "then", "when", "END", "case", "else", "for", "nil", "retry", "true", "while", "alias", "class", "elsif", "if", "not", "return", "undef", "yield"));
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("array");
        this.languageSpecificPrimitives.add("map");
        this.languageSpecificPrimitives.add("string");
        this.languageSpecificPrimitives.add("DateTime");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("Array", "array");
        this.typeMapping.put("String", "string");
        this.typeMapping.put("List", "array");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("UUID", "string");
        this.cliOptions.clear();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.setApiPackage("api");
        this.supportingFiles.add(new SupportingFile("my_app.mustache", "", "my_app.rb"));
        this.supportingFiles.add(new SupportingFile("OpenAPIing.rb", this.libFolder, "openapiing.rb"));
        this.supportingFiles.add(new SupportingFile("config.ru", "", "config.ru"));
        this.supportingFiles.add(new SupportingFile("Gemfile", "", "Gemfile"));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "", "openapi.yaml"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "ruby-sinatra";
    }

    @Override
    public String getHelp() {
        return "Generates a Ruby Sinatra server library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return this.getSchemaType(p) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        if (type == null) {
            return null;
        }
        return type;
    }

    @Override
    public String toDefaultValue(Schema p) {
        return "null";
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.isReservedWord(name = RubySinatraServerCodegen.underscore(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.isReservedWord(name)) {
            LOGGER.warn(name + " (reserved word) cannot be used as model filename. Renamed to " + RubySinatraServerCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return RubySinatraServerCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.isReservedWord(name)) {
            LOGGER.warn(name + " (reserved word) cannot be used as model filename. Renamed to " + RubySinatraServerCodegen.underscore("model_" + name));
            name = "model_" + name;
        }
        return RubySinatraServerCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return RubySinatraServerCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return RubySinatraServerCodegen.camelize(name) + "Api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            String newOperationId = RubySinatraServerCodegen.underscore("call_" + operationId);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return RubySinatraServerCodegen.underscore(operationId);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("=end", "=_end").replace("=begin", "=_begin");
    }
}

