/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.common.navigation.InvalidNavigationException;
import org.odftoolkit.simple.common.navigation.TextSelection;
import org.odftoolkit.simple.style.DefaultStyleHandler;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Span
extends Component {
    private TextSpanElement mSpanElement;
    private Document mOwnerDocument;
    private DefaultStyleHandler mStyleHandler;

    private Span(TextSpanElement element) {
        this.mSpanElement = element;
        this.mOwnerDocument = (Document)((OdfFileDom)element.getOwnerDocument()).getDocument();
        this.mStyleHandler = new DefaultStyleHandler((OdfStylableElement)element);
    }

    public static Span getInstanceof(TextSpanElement sElement) {
        if (sElement == null) {
            return null;
        }
        Span span = null;
        span = (Span)Component.getComponentByElement((OdfElement)sElement);
        if (span != null) {
            return span;
        }
        span = new Span(sElement);
        Component.registerComponent(span, (OdfElement)sElement);
        return span;
    }

    public static Span newSpan(TextSelection textSelection) {
        try {
            TextSpanElement element = textSelection.createSpanElement();
            return Span.getInstanceof(element);
        }
        catch (InvalidNavigationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DefaultStyleHandler getStyleHandler() {
        if (this.mStyleHandler != null) {
            return this.mStyleHandler;
        }
        this.mStyleHandler = new DefaultStyleHandler((OdfStylableElement)this.mSpanElement);
        return this.mStyleHandler;
    }

    public Document getOwnerDocument() {
        return this.mOwnerDocument;
    }

    public TextSpanElement getOdfElement() {
        return this.mSpanElement;
    }

    public void removeTextContent() {
        NodeList nodeList = this.mSpanElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodename;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                this.mSpanElement.removeChild(node);
                continue;
            }
            if (node.getNodeType() != 1 || !(nodename = node.getNodeName()).equals("text:s") && !nodename.equals("text:tab") && !nodename.equals("text:line-break")) continue;
            this.mSpanElement.removeChild(node);
        }
    }

    public void setTextContent(String content) {
        this.removeTextContent();
        if (content != null && !content.equals("")) {
            this.appendTextElements(content, true);
        }
    }

    public String getTextContent() {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = this.mSpanElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                buffer.append(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("text:s")) {
                int count = ((TextSElement)node).getTextCAttribute();
                for (int j = 0; j < count; ++j) {
                    buffer.append(' ');
                }
                continue;
            }
            if (node.getNodeName().equals("text:tab")) {
                buffer.append('\t');
                continue;
            }
            if (!node.getNodeName().equals("text:line-break")) continue;
            String lineseperator = System.getProperty("line.separator");
            buffer.append(lineseperator);
        }
        return buffer.toString();
    }

    public void appendTextContent(String content) {
        if (content != null && !content.equals("")) {
            this.appendTextElements(content, true);
        }
    }

    private void appendTextElements(String content, boolean isWhitespaceCollapsed) {
        if (isWhitespaceCollapsed) {
            int i = 0;
            int length = content.length();
            String str = "";
            while (i < length) {
                char ch = content.charAt(i);
                if (ch == ' ') {
                    int j = 1;
                    ++i;
                    while (i < length && content.charAt(i) == ' ') {
                        ++j;
                        ++i;
                    }
                    if (j == 1) {
                        str = str + ' ';
                        continue;
                    }
                    str = str + ' ';
                    Text textnode = this.mSpanElement.getOwnerDocument().createTextNode(str);
                    this.mSpanElement.appendChild((Node)textnode);
                    str = "";
                    TextSElement spaceElement = this.mSpanElement.newTextSElement();
                    spaceElement.setTextCAttribute(Integer.valueOf(j - 1));
                    continue;
                }
                if (ch == '\n') {
                    if (str.length() > 0) {
                        Text textnode = this.mSpanElement.getOwnerDocument().createTextNode(str);
                        this.mSpanElement.appendChild((Node)textnode);
                        str = "";
                    }
                    this.mSpanElement.newTextLineBreakElement();
                    ++i;
                    continue;
                }
                if (ch == '\t') {
                    if (str.length() > 0) {
                        Text textnode = this.mSpanElement.getOwnerDocument().createTextNode(str);
                        this.mSpanElement.appendChild((Node)textnode);
                        str = "";
                    }
                    this.mSpanElement.newTextTabElement();
                    ++i;
                    continue;
                }
                if (ch == '\r') {
                    ++i;
                    continue;
                }
                str = str + ch;
                ++i;
            }
            if (str.length() > 0) {
                Text textnode = this.mSpanElement.getOwnerDocument().createTextNode(str);
                this.mSpanElement.appendChild((Node)textnode);
            }
        } else {
            Text textnode = this.mSpanElement.getOwnerDocument().createTextNode(content);
            this.mSpanElement.appendChild((Node)textnode);
        }
    }
}

