/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaConstraint;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnchorTypeAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentContentElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSectionElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfTextProperties;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawFrame;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawImage;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfNamespace;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.odftoolkit.odfdom.type.Duration;
import org.odftoolkit.simple.ChartDocument;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.GraphicsDocument;
import org.odftoolkit.simple.PresentationDocument;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.meta.Meta;
import org.odftoolkit.simple.table.AbstractTableContainer;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.table.TableContainer;
import org.odftoolkit.simple.text.Section;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Document
extends OdfSchemaDocument
implements TableContainer {
    private static final String SLASH = "/";
    private OdfMediaType mMediaType;
    private Meta mOfficeMeta;
    private long documentOpeningTime;
    private TableContainerImpl tableContainerImpl;
    private static final Pattern CONTROL_CHAR_PATTERN = Pattern.compile("\\p{Cntrl}");
    private static final String EMPTY_STRING = "";
    private IdentityHashMap<OdfElement, Component> mComponentRepository = new IdentityHashMap();
    private File mFile = null;
    private HashMap<String, List<String>> styleRenameMap = new HashMap();
    private HashMap<String, Boolean> styleAppendMap = new HashMap();
    private static final HashSet<String> CJKLanguage = new HashSet();
    private static final HashSet<String> CTLLanguage = new HashSet();
    private static final String DOUBLE_DOT = "..";
    private static final String DOT = ".";
    private static final String COLON = ":";
    private static final Pattern BACK_SLASH_PATTERN = Pattern.compile("\\\\");
    private static final Pattern DOUBLE_SLASH_PATTERN = Pattern.compile("//");

    protected Document(OdfPackage pkg, String internalPath, OdfMediaType mediaType) {
        super(pkg, internalPath, mediaType.getMediaTypeString());
        CJKLanguage.add("zh");
        CJKLanguage.add("ja");
        CJKLanguage.add("ko");
        CTLLanguage.add("am");
        CTLLanguage.add("ar");
        CTLLanguage.add("as");
        CTLLanguage.add("bn");
        CTLLanguage.add("bo");
        CTLLanguage.add("brx");
        CTLLanguage.add("dgo");
        CTLLanguage.add("dv");
        CTLLanguage.add("dz");
        CTLLanguage.add("fa");
        CTLLanguage.add("gu");
        CTLLanguage.add("he");
        CTLLanguage.add("hi");
        CTLLanguage.add("km");
        CTLLanguage.add("kn");
        CTLLanguage.add("ks");
        CTLLanguage.add("ku");
        CTLLanguage.add("lo");
        CTLLanguage.add("mai");
        CTLLanguage.add("ml");
        CTLLanguage.add("mn");
        CTLLanguage.add("mni");
        CTLLanguage.add("mr");
        CTLLanguage.add("my");
        CTLLanguage.add("ne");
        CTLLanguage.add("or");
        CTLLanguage.add("pa");
        CTLLanguage.add("sa");
        CTLLanguage.add("sd");
        CTLLanguage.add("si");
        CTLLanguage.add("syr");
        CTLLanguage.add("ta");
        CTLLanguage.add("te");
        CTLLanguage.add("th");
        CTLLanguage.add("ug");
        CTLLanguage.add("ur");
        CTLLanguage.add("yi");
        this.mMediaType = mediaType;
        this.documentOpeningTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Document loadTemplate(OdfPackageDocument.Resource res, OdfMediaType odfMediaType) throws Exception {
        InputStream in = res.createInputStream();
        OdfPackage pkg = null;
        try {
            pkg = OdfPackage.loadPackage((InputStream)in);
        }
        finally {
            in.close();
        }
        Document newDocument = Document.newDocument(pkg, EMPTY_STRING, odfMediaType);
        Document.initializeMetaData(newDocument);
        return newDocument;
    }

    public static Document loadDocument(String documentPath) throws Exception {
        File file = new File(documentPath);
        Document doc = Document.loadDocument(OdfPackage.loadPackage((String)documentPath));
        doc.setFile(file);
        return doc;
    }

    public static Document loadDocument(InputStream inStream) throws Exception {
        return Document.loadDocument(OdfPackage.loadPackage((InputStream)inStream));
    }

    public static Document loadDocument(File file) throws Exception {
        Document doc = Document.loadDocument(OdfPackage.loadPackage((File)file));
        doc.setFile(file);
        return doc;
    }

    public static Document loadDocument(OdfPackage odfPackage) throws Exception {
        return Document.loadDocument(odfPackage, EMPTY_STRING);
    }

    public static Document loadDocument(OdfPackage odfPackage, String internalPath) throws Exception {
        String documentMediaType = odfPackage.getMediaTypeString(internalPath);
        OdfMediaType odfMediaType = null;
        try {
            odfMediaType = OdfMediaType.getOdfMediaType(documentMediaType);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (odfMediaType == null) {
            ErrorHandler errorHandler = odfPackage.getErrorHandler();
            Matcher matcherCTRL = CONTROL_CHAR_PATTERN.matcher(documentMediaType);
            if (matcherCTRL.find()) {
                documentMediaType = matcherCTRL.replaceAll(EMPTY_STRING);
            }
            OdfValidationException ve = new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.DOCUMENT_WITHOUT_ODF_MIMETYPE, internalPath, new Object[]{documentMediaType});
            if (errorHandler != null) {
                errorHandler.fatalError((SAXParseException)ve);
            }
            throw ve;
        }
        return Document.newDocument(odfPackage, internalPath, odfMediaType);
    }

    private static Document loadDocumentFromTemplate(OdfMediaType odfMediaType) throws Exception {
        switch (odfMediaType) {
            case TEXT: 
            case TEXT_TEMPLATE: 
            case TEXT_MASTER: 
            case TEXT_WEB: {
                TextDocument document = TextDocument.newTextDocument();
                document.changeMode(TextDocument.OdfMediaType.TEXT_WEB);
                return document;
            }
            case SPREADSHEET: {
                SpreadsheetDocument spreadsheet = SpreadsheetDocument.newSpreadsheetDocument();
                spreadsheet.changeMode(SpreadsheetDocument.OdfMediaType.SPREADSHEET);
                return spreadsheet;
            }
            case SPREADSHEET_TEMPLATE: {
                SpreadsheetDocument spreadsheettemplate = SpreadsheetDocument.newSpreadsheetDocument();
                spreadsheettemplate.changeMode(SpreadsheetDocument.OdfMediaType.SPREADSHEET_TEMPLATE);
                return spreadsheettemplate;
            }
            case PRESENTATION: {
                PresentationDocument presentation = PresentationDocument.newPresentationDocument();
                presentation.changeMode(PresentationDocument.OdfMediaType.PRESENTATION);
                return presentation;
            }
            case PRESENTATION_TEMPLATE: {
                PresentationDocument presentationtemplate = PresentationDocument.newPresentationDocument();
                presentationtemplate.changeMode(PresentationDocument.OdfMediaType.PRESENTATION_TEMPLATE);
                return presentationtemplate;
            }
            case GRAPHICS: {
                GraphicsDocument graphics = GraphicsDocument.newGraphicsDocument();
                graphics.changeMode(GraphicsDocument.OdfMediaType.GRAPHICS);
                return graphics;
            }
            case GRAPHICS_TEMPLATE: {
                GraphicsDocument graphicstemplate = GraphicsDocument.newGraphicsDocument();
                graphicstemplate.changeMode(GraphicsDocument.OdfMediaType.GRAPHICS_TEMPLATE);
                return graphicstemplate;
            }
            case CHART: {
                ChartDocument chart = ChartDocument.newChartDocument();
                chart.changeMode(ChartDocument.OdfMediaType.CHART);
                return chart;
            }
            case CHART_TEMPLATE: {
                ChartDocument charttemplate = ChartDocument.newChartDocument();
                charttemplate.changeMode(ChartDocument.OdfMediaType.CHART_TEMPLATE);
                return charttemplate;
            }
        }
        throw new IllegalArgumentException("Given mediaType '" + odfMediaType.toString() + "' is either not yet supported or not an ODF mediatype!");
    }

    private static Document newDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) {
        Document newDoc = null;
        switch (odfMediaType) {
            case TEXT: {
                newDoc = new TextDocument(pkg, internalPath, TextDocument.OdfMediaType.TEXT);
                break;
            }
            case TEXT_TEMPLATE: {
                newDoc = new TextDocument(pkg, internalPath, TextDocument.OdfMediaType.TEXT_TEMPLATE);
                break;
            }
            case TEXT_MASTER: {
                newDoc = new TextDocument(pkg, internalPath, TextDocument.OdfMediaType.TEXT_MASTER);
                break;
            }
            case TEXT_WEB: {
                newDoc = new TextDocument(pkg, internalPath, TextDocument.OdfMediaType.TEXT_WEB);
                break;
            }
            case SPREADSHEET: {
                newDoc = new SpreadsheetDocument(pkg, internalPath, SpreadsheetDocument.OdfMediaType.SPREADSHEET);
                break;
            }
            case SPREADSHEET_TEMPLATE: {
                newDoc = new SpreadsheetDocument(pkg, internalPath, SpreadsheetDocument.OdfMediaType.SPREADSHEET_TEMPLATE);
                break;
            }
            case PRESENTATION: {
                newDoc = new PresentationDocument(pkg, internalPath, PresentationDocument.OdfMediaType.PRESENTATION);
                break;
            }
            case PRESENTATION_TEMPLATE: {
                newDoc = new PresentationDocument(pkg, internalPath, PresentationDocument.OdfMediaType.PRESENTATION_TEMPLATE);
                break;
            }
            case GRAPHICS: {
                newDoc = new GraphicsDocument(pkg, internalPath, GraphicsDocument.OdfMediaType.GRAPHICS);
                break;
            }
            case GRAPHICS_TEMPLATE: {
                newDoc = new GraphicsDocument(pkg, internalPath, GraphicsDocument.OdfMediaType.GRAPHICS_TEMPLATE);
                break;
            }
            case CHART: {
                newDoc = new ChartDocument(pkg, internalPath, ChartDocument.OdfMediaType.CHART);
                break;
            }
            case CHART_TEMPLATE: {
                newDoc = new ChartDocument(pkg, internalPath, ChartDocument.OdfMediaType.CHART_TEMPLATE);
                break;
            }
            default: {
                newDoc = null;
                throw new IllegalArgumentException("Given mediaType '" + odfMediaType.mMediaType + "' is not yet supported!");
            }
        }
        return newDoc;
    }

    public Document getEmbeddedDocument(String documentPath) {
        String internalPath = this.getDocumentPath() + documentPath;
        Document embeddedDocument = (Document)this.mPackage.getCachedDocument(internalPath = Document.normalizeDocumentPath((String)internalPath));
        if (embeddedDocument == null) {
            String mediaTypeString = this.getMediaTypeString();
            OdfMediaType odfMediaType = OdfMediaType.getOdfMediaType(mediaTypeString);
            if (odfMediaType == null) {
                embeddedDocument = Document.newDocument(this.mPackage, internalPath, odfMediaType);
            } else {
                try {
                    String documentMediaType = this.mPackage.getMediaTypeString(internalPath);
                    odfMediaType = OdfMediaType.getOdfMediaType(documentMediaType);
                    if (odfMediaType == null) {
                        return null;
                    }
                    embeddedDocument = Document.loadDocument(this.mPackage, internalPath);
                }
                catch (Exception ex) {
                    Logger.getLogger(OdfPackageDocument.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return embeddedDocument;
    }

    public List<Document> getEmbeddedDocuments() {
        ArrayList<Document> embeddedObjects = new ArrayList<Document>();
        for (OdfMediaType mediaType : OdfMediaType.values()) {
            embeddedObjects.addAll(this.getEmbeddedDocuments(mediaType));
        }
        return embeddedObjects;
    }

    public List<Document> getEmbeddedDocuments(OdfMediaType mediaType) {
        String wantedMediaString = null;
        if (mediaType != null) {
            wantedMediaString = mediaType.getMediaTypeString();
        }
        ArrayList<Document> embeddedObjects = new ArrayList<Document>();
        Set manifestEntries = this.mPackage.getFilePaths();
        for (String path : manifestEntries) {
            String entryMediaType;
            if (path.length() <= 1 || !path.endsWith(SLASH) || (entryMediaType = this.mPackage.getFileEntry(path).getMediaTypeString()) == null) continue;
            if (wantedMediaString != null) {
                if (!entryMediaType.equals(wantedMediaString)) continue;
                Document.normalizeDocumentPath((String)path);
                embeddedObjects.add(this.getEmbeddedDocument(path));
                continue;
            }
            for (OdfMediaType type : OdfMediaType.values()) {
                if (!entryMediaType.equals(type.getMediaTypeString())) continue;
                embeddedObjects.add(this.getEmbeddedDocument(path));
            }
        }
        return embeddedObjects;
    }

    public void insertDocument(OdfPackageDocument sourceDocument, String documentPath) {
        super.insertDocument(sourceDocument, documentPath);
    }

    protected void setOdfMediaType(OdfMediaType odfMediaType) {
        this.mMediaType = odfMediaType;
        super.setMediaTypeString(odfMediaType.getMediaTypeString());
    }

    protected OdfMediaType getOdfMediaType() {
        return this.mMediaType;
    }

    public Meta getOfficeMetadata() {
        if (this.mOfficeMeta == null) {
            try {
                this.mOfficeMeta = new Meta((OdfFileDom)this.getMetaDom());
            }
            catch (Exception ex) {
                Logger.getLogger(Document.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.mOfficeMeta;
    }

    public void save(OutputStream out) throws Exception {
        this.flushDoms();
        this.updateMetaData();
        if (!this.isRootDocument()) {
            Document newDoc = Document.loadDocumentFromTemplate(this.getOdfMediaType());
            newDoc.insertDocument((OdfPackageDocument)this, EMPTY_STRING);
            newDoc.updateMetaData();
            newDoc.mPackage.save(out);
        } else {
            this.mPackage.save(out);
        }
    }

    public void save(File file) throws Exception {
        this.flushDoms();
        this.updateMetaData();
        if (!this.isRootDocument()) {
            Document newDoc = Document.loadDocumentFromTemplate(this.getOdfMediaType());
            newDoc.insertDocument((OdfPackageDocument)this, EMPTY_STRING);
            newDoc.updateMetaData();
            newDoc.mPackage.save(file);
        } else {
            this.mPackage.save(file);
        }
    }

    public void close() {
        this.mMediaType = null;
        this.mOfficeMeta = null;
        this.mComponentRepository.clear();
        super.close();
    }

    protected <T extends OdfElement> T getContentRoot(Class<T> clazz) throws Exception {
        OfficeDocumentContentElement contentRoot = this.getContentDom().getRootElement();
        OfficeBodyElement contentBody = (OfficeBodyElement)OdfElement.findFirstChildNode(OfficeBodyElement.class, (Node)contentRoot);
        NodeList childs = contentBody.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node cur = childs.item(i);
            if (cur == null || !clazz.isInstance(cur)) continue;
            return (T)((OdfElement)cur);
        }
        return null;
    }

    public OdfElement getContentRoot() throws Exception {
        return this.getContentRoot(OdfElement.class);
    }

    public String toString() {
        return "\n" + this.getMediaTypeString() + " - ID: " + this.hashCode() + " " + this.getPackage().getBaseURI();
    }

    public String newImage(URI imageUri) {
        try {
            OdfContentDom contentDom = this.getContentDom();
            OdfDrawFrame drawFrame = (OdfDrawFrame)contentDom.newOdfElement(OdfDrawFrame.class);
            XPath xpath = contentDom.getXPath();
            if (this instanceof SpreadsheetDocument) {
                TableTableCellElement lastCell = (TableTableCellElement)xpath.evaluate("//table:table-cell[last()]", contentDom, XPathConstants.NODE);
                lastCell.appendChild((Node)drawFrame);
                drawFrame.removeAttribute("text:anchor-type");
            } else if (this instanceof TextDocument) {
                TextPElement lastPara = (TextPElement)xpath.evaluate("//text:p[last()]", contentDom, XPathConstants.NODE);
                if (lastPara == null) {
                    lastPara = ((TextDocument)this).newParagraph();
                }
                lastPara.appendChild((Node)drawFrame);
                drawFrame.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PARAGRAPH.toString());
            } else if (this instanceof PresentationDocument) {
                DrawPageElement lastPage = (DrawPageElement)xpath.evaluate("//draw:page[last()]", contentDom, XPathConstants.NODE);
                lastPage.appendChild((Node)drawFrame);
            }
            OdfDrawImage image = (OdfDrawImage)drawFrame.newDrawImageElement();
            String imagePath = image.newImage(imageUri);
            return imagePath;
        }
        catch (Exception ex) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static void initializeMetaData(Document newDoc) {
        Meta metaData = newDoc.getOfficeMetadata();
        String creator = System.getProperty("user.name");
        metaData.setInitialCreator(creator);
        Calendar calendar = Calendar.getInstance();
        metaData.setCreationDate(calendar);
        metaData.setEditingCycles(0);
        String language = System.getProperty("user.language");
        if (language != null) {
            metaData.setLanguage(language);
        }
    }

    private void updateMetaData() throws Exception {
        if (this.mMetaDom != null) {
            Meta metaData = this.getOfficeMetadata();
            String creator = System.getProperty("user.name");
            metaData.setCreator(creator);
            Calendar calendar = Calendar.getInstance();
            metaData.setDcdate(calendar);
            Integer cycle = metaData.getEditingCycles();
            if (cycle != null) {
                cycle = cycle + 1;
                metaData.setEditingCycles(cycle);
            } else {
                metaData.setEditingCycles(1);
            }
            long editingDuration = calendar.getTimeInMillis() - this.documentOpeningTime;
            editingDuration = editingDuration < 1L ? 1L : editingDuration;
            try {
                DatatypeFactory aFactory = DatatypeFactory.newInstance();
                metaData.setEditingDuration(new Duration(aFactory.newDurationDayTime(editingDuration)));
            }
            catch (DatatypeConfigurationException e) {
                Logger.getLogger(Document.class.getName()).log(Level.SEVERE, "editing duration update fail as DatatypeFactory can not be instanced", e);
            }
        }
    }

    public void setLocale(Locale locale) {
        this.setLocale(locale, Document.getScriptType(locale));
    }

    public static ScriptType getScriptType(Locale locale) {
        String language = locale.getLanguage();
        if (CJKLanguage.contains(language)) {
            return ScriptType.CJK;
        }
        if (CTLLanguage.contains(language)) {
            return ScriptType.CTL;
        }
        return ScriptType.WESTERN;
    }

    public void setLocale(Locale locale, ScriptType scriptType) {
        try {
            switch (scriptType) {
                case WESTERN: {
                    this.setWesternLanguage(locale);
                    break;
                }
                case CJK: {
                    this.setDefaultAsianLanguage(locale);
                    break;
                }
                case CTL: {
                    this.setDefaultComplexLanguage(locale);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, "Failed to set locale", e);
        }
    }

    public Locale getLocale(ScriptType scriptType) {
        try {
            switch (scriptType) {
                case WESTERN: {
                    return this.getDefaultLanguageByProperty(OdfTextProperties.Country, OdfTextProperties.Language);
                }
                case CJK: {
                    return this.getDefaultLanguageByProperty(OdfTextProperties.CountryAsian, OdfTextProperties.LanguageAsian);
                }
                case CTL: {
                    return this.getDefaultLanguageByProperty(OdfTextProperties.CountryComplex, OdfTextProperties.LanguageComplex);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, "Failed to get locale", e);
        }
        return null;
    }

    private void setWesternLanguage(Locale locale) throws Exception {
        if (Document.getScriptType(locale) != ScriptType.WESTERN) {
            return;
        }
        OdfOfficeStyles styles = this.getStylesDom().getOfficeStyles();
        Iterable defaultStyles = styles.getDefaultStyles();
        if (defaultStyles != null) {
            for (OdfDefaultStyle style : defaultStyles) {
                if (!style.getFamily().getProperties().contains(OdfTextProperties.Language)) continue;
                style.setProperty(OdfTextProperties.Language, locale.getLanguage());
                style.setProperty(OdfTextProperties.Country, locale.getCountry());
            }
        }
    }

    private Locale getDefaultLanguageByProperty(OdfStyleProperty countryProp, OdfStyleProperty languageProp) throws Exception {
        String lang = null;
        String ctry = null;
        OdfOfficeStyles styles = this.getStylesDom().getOfficeStyles();
        OdfDefaultStyle defaultStyle = styles.getDefaultStyle(OdfStyleFamily.Paragraph);
        if (defaultStyle != null && defaultStyle.hasProperty(countryProp) && defaultStyle.hasProperty(languageProp)) {
            ctry = defaultStyle.getProperty(countryProp);
            lang = defaultStyle.getProperty(languageProp);
            return new Locale(lang, ctry);
        }
        Iterable defaultStyles = styles.getDefaultStyles();
        for (OdfDefaultStyle style : defaultStyles) {
            if (!style.hasProperty(countryProp) || !style.hasProperty(languageProp)) continue;
            ctry = style.getProperty(countryProp);
            lang = style.getProperty(languageProp);
            return new Locale(lang, ctry);
        }
        return null;
    }

    private void setDefaultAsianLanguage(Locale locale) throws Exception {
        if (Document.getScriptType(locale) != ScriptType.CJK) {
            return;
        }
        String user_language = locale.getLanguage();
        if (!(user_language.equals(Locale.CHINESE.getLanguage()) || user_language.equals(Locale.TRADITIONAL_CHINESE.getLanguage()) || user_language.equals(Locale.JAPANESE.getLanguage()) || user_language.equals(Locale.KOREAN.getLanguage()))) {
            return;
        }
        OdfOfficeStyles styles = this.getStylesDom().getOfficeStyles();
        Iterable defaultStyles = styles.getDefaultStyles();
        if (defaultStyles != null) {
            for (OdfDefaultStyle style : defaultStyles) {
                if (!style.getFamily().getProperties().contains(OdfTextProperties.LanguageAsian)) continue;
                style.setProperty(OdfTextProperties.LanguageAsian, locale.getLanguage());
                style.setProperty(OdfTextProperties.CountryAsian, locale.getCountry());
            }
        }
    }

    private void setDefaultComplexLanguage(Locale locale) throws Exception {
        if (Document.getScriptType(locale) != ScriptType.CTL) {
            return;
        }
        OdfOfficeStyles styles = this.getStylesDom().getOfficeStyles();
        Iterable defaultStyles = styles.getDefaultStyles();
        if (defaultStyles != null) {
            for (OdfDefaultStyle style : defaultStyles) {
                if (!style.getFamily().getProperties().contains(OdfTextProperties.LanguageComplex)) continue;
                style.setProperty(OdfTextProperties.LanguageComplex, locale.getLanguage());
                style.setProperty(OdfTextProperties.CountryComplex, locale.getCountry());
            }
        }
    }

    public Iterator<Section> getSectionIterator() {
        ArrayList<Section> list = new ArrayList<Section>();
        try {
            TextSectionElement element;
            OfficeDocumentContentElement root = this.getContentDom().getRootElement();
            OfficeBodyElement officeBody = (OfficeBodyElement)OdfElement.findFirstChildNode(OfficeBodyElement.class, (Node)root);
            NodeList sectionList = officeBody.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "section");
            for (int i = 0; i < sectionList.getLength(); ++i) {
                element = (TextSectionElement)sectionList.item(i);
                list.add(Section.getInstance(element));
            }
            root = this.getStylesDom().getRootElement();
            OfficeMasterStylesElement masterStyle = (OfficeMasterStylesElement)OdfElement.findFirstChildNode(OfficeMasterStylesElement.class, (Node)root);
            sectionList = masterStyle.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "section");
            for (int i = 0; i < sectionList.getLength(); ++i) {
                element = (TextSectionElement)sectionList.item(i);
                list.add(Section.getInstance(element));
            }
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, "Failed in sectionIterator", e);
        }
        return list.iterator();
    }

    public Section getSectionByName(String name) {
        try {
            OfficeDocumentContentElement root = this.getContentDom().getRootElement();
            OfficeBodyElement officeBody = (OfficeBodyElement)OdfElement.findFirstChildNode(OfficeBodyElement.class, (Node)root);
            XPath xpath = this.getContentDom().getXPath();
            String xpathValue = ".//text:section[@text:name=\"" + name + "\"]";
            TextSectionElement element = (TextSectionElement)xpath.evaluate(xpathValue, officeBody, XPathConstants.NODE);
            if (element != null) {
                return Section.getInstance(element);
            }
            root = this.getStylesDom().getRootElement();
            OfficeMasterStylesElement masterStyle = (OfficeMasterStylesElement)OdfElement.findFirstChildNode(OfficeMasterStylesElement.class, (Node)root);
            xpath = this.getStylesDom().getXPath();
            element = (TextSectionElement)xpath.evaluate(".//text:section[@text:name=\"" + name + "\"]", masterStyle, XPathConstants.NODE);
            if (element != null) {
                return Section.getInstance(element);
            }
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, "Failed in getSectionByName", e);
        }
        return null;
    }

    public boolean removeElementLinkedResource(OdfElement odfElement) {
        boolean success = this.deleteLinkedRef(odfElement);
        return success &= this.deleteStyleRef(odfElement);
    }

    String makeUniqueName() {
        return String.format("a%06x", (int)(Math.random() * 1.6777215E7));
    }

    private String getNewUniqueString(String oldStr) {
        int lastIndex = oldStr.lastIndexOf("-");
        if (lastIndex == -1) {
            return oldStr + "-" + this.makeUniqueName();
        }
        String suffix = oldStr.substring(lastIndex + 1);
        if (suffix.matches("a[0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f]")) {
            return oldStr.substring(0, lastIndex + 1) + this.makeUniqueName();
        }
        return oldStr + "-" + this.makeUniqueName();
    }

    private void updateAttribute(Attr attr) {
        String oldID = attr.getValue();
        String newID = this.getNewUniqueString(oldID);
        attr.setValue(newID);
    }

    Node cloneForeignElement(Node element, OdfFileDom dom, boolean deep) {
        if (element instanceof OdfElement) {
            OdfElement cloneElement = dom.createElementNS(((OdfElement)element).getOdfName());
            NamedNodeMap attributes = element.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node item = attributes.item(i);
                    String qname = null;
                    String prefix = item.getPrefix();
                    qname = prefix == null ? item.getLocalName() : prefix + COLON + item.getLocalName();
                    cloneElement.setAttributeNS(item.getNamespaceURI(), qname, item.getNodeValue());
                }
            }
            if (deep) {
                for (Node childNode = element.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    cloneElement.appendChild(this.cloneForeignElement(childNode, dom, true));
                }
            }
            return cloneElement;
        }
        return dom.createTextNode(element.getNodeValue());
    }

    void updateXMLIds(OdfElement element) {
        try {
            XPath xpath = this.getContentDom().getXPath();
            String xpathValue = "//*[@xml:id]";
            NodeList childList = (NodeList)xpath.evaluate(xpathValue, element, XPathConstants.NODESET);
            if (childList == null) {
                return;
            }
            for (int i = 0; i < childList.getLength(); ++i) {
                OdfElement ele = (OdfElement)childList.item(i);
                Attr attri = ele.getAttributeNodeNS(OdfDocumentNamespace.XML.getUri(), "id");
                this.updateAttribute(attri);
            }
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, "Failed in updateXMLIds", e);
        }
    }

    void updateNames(OdfElement element) {
        try {
            XPath xpath = this.getContentDom().getXPath();
            String xpathValue = "descendant-or-self::node()[@text:name|@table:name|@draw:name|@chart:name]";
            NodeList childList = (NodeList)xpath.evaluate(xpathValue, element, XPathConstants.NODESET);
            if (childList == null) {
                return;
            }
            for (int i = 0; i < childList.getLength(); ++i) {
                OdfElement ele = (OdfElement)childList.item(i);
                Attr attri = ele.getAttributeNodeNS(OdfDocumentNamespace.TEXT.getUri(), "name");
                if (attri != null) {
                    this.updateAttribute(attri);
                }
                if ((attri = ele.getAttributeNodeNS(OdfDocumentNamespace.TABLE.getUri(), "name")) != null) {
                    this.updateAttribute(attri);
                }
                if (!(ele instanceof DrawFrameElement) || (attri = ele.getAttributeNodeNS(OdfDocumentNamespace.DRAW.getUri(), "name")) == null) continue;
                this.updateAttribute(attri);
            }
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, "Failed in updateXMLIds", e);
        }
    }

    void copyLinkedRefInBatch(OdfElement sourceCloneEle, Document srcDocument) {
        try {
            OdfFileDom fileDom = (OdfFileDom)sourceCloneEle.getOwnerDocument();
            XPath xpath = fileDom instanceof OdfContentDom ? ((OdfContentDom)fileDom).getXPath() : ((OdfStylesDom)fileDom).getXPath();
            HashMap<String, String> objectRenameMap = new HashMap<String, String>();
            NodeList linkNodes = (NodeList)xpath.evaluate(".//*[@xlink:href]", sourceCloneEle, XPathConstants.NODESET);
            for (int i = 0; i <= linkNodes.getLength(); ++i) {
                String newObjPath;
                OdfElement object = null;
                if (linkNodes.getLength() == i) {
                    if (!sourceCloneEle.hasAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href")) break;
                    object = sourceCloneEle;
                } else {
                    object = (OdfElement)linkNodes.item(i);
                }
                String refObjPath = object.getAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href");
                if (refObjPath == null || refObjPath.length() <= 0) continue;
                boolean hasPrefix = false;
                String prefix = "./";
                if (refObjPath.startsWith(prefix)) {
                    refObjPath = refObjPath.substring(2);
                    hasPrefix = true;
                }
                if (objectRenameMap.containsKey(refObjPath)) {
                    newObjPath = objectRenameMap.get(refObjPath);
                    object.setAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "xlink:href", hasPrefix ? prefix + newObjPath : newObjPath);
                    continue;
                }
                OdfFileEntry fileEntry = this.getPackage().getFileEntry(refObjPath);
                if (fileEntry == null) {
                    fileEntry = this.getPackage().getFileEntry(refObjPath + SLASH);
                }
                newObjPath = refObjPath;
                if (fileEntry != null) {
                    newObjPath = objectRenameMap.get(refObjPath);
                    if (newObjPath == null) {
                        int dotIndex = refObjPath.indexOf(DOT);
                        newObjPath = dotIndex != -1 ? refObjPath.substring(0, dotIndex) + "-" + this.makeUniqueName() + refObjPath.substring(dotIndex) : refObjPath + "-" + this.makeUniqueName();
                        objectRenameMap.put(refObjPath, newObjPath);
                    }
                    object.setAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "xlink:href", hasPrefix ? prefix + newObjPath : newObjPath);
                    continue;
                }
                objectRenameMap.put(refObjPath, refObjPath);
            }
            this.copyResourcesFrom(srcDocument, objectRenameMap);
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private InputStream readAsInputStream(ZipInputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (outputStream != null) {
            byte[] buf = new byte[4096];
            int r = 0;
            while ((r = inputStream.read(buf, 0, 4096)) > -1) {
                outputStream.write(buf, 0, r);
            }
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private String normalizeFilePath(String internalPath) {
        if (internalPath.equals(EMPTY_STRING)) {
            String errMsg = "The internalPath given by parameter is an empty string!";
            Logger.getLogger(OdfPackage.class.getName()).severe(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        return this.normalizePath(internalPath);
    }

    private String normalizePath(String path) {
        if (path == null) {
            String errMsg = "The internalPath given by parameter is NULL!";
            Logger.getLogger(OdfPackage.class.getName()).severe(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        if (!this.mightBeExternalReference(path)) {
            if (path.equals(EMPTY_STRING)) {
                path = SLASH;
            } else {
                if (path.indexOf(92) != -1) {
                    path = BACK_SLASH_PATTERN.matcher(path).replaceAll(SLASH);
                }
                while (path.indexOf("//") != -1) {
                    path = DOUBLE_SLASH_PATTERN.matcher(path).replaceAll(SLASH);
                }
                if (path.indexOf("/.") != -1 || path.indexOf("./") != -1) {
                    path = this.removeChangeDirectories(path);
                }
            }
        }
        return path;
    }

    private boolean mightBeExternalReference(String internalPath) {
        boolean isExternalReference = false;
        if (internalPath.startsWith(DOUBLE_DOT) || internalPath.startsWith(SLASH) && !internalPath.equals(SLASH) || internalPath.contains(COLON)) {
            isExternalReference = true;
        }
        return isExternalReference;
    }

    private String removeChangeDirectories(String path) {
        String lastPath;
        boolean isDirectory = path.endsWith(SLASH);
        StringTokenizer tokenizer = new StringTokenizer(path, SLASH);
        int tokenCount = tokenizer.countTokens();
        ArrayList<String> tokenList = new ArrayList<String>(tokenCount);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            tokenList.add(token);
        }
        if (!isDirectory && ((lastPath = (String)tokenList.get(tokenCount - 1)).equals(DOT) || lastPath.equals(DOUBLE_DOT))) {
            isDirectory = true;
        }
        int removeDirLevel = 0;
        StringBuilder out = new StringBuilder();
        for (int i = tokenCount - 1; i >= 0; --i) {
            String currentToken = (String)tokenList.get(i);
            if (currentToken.equals(DOUBLE_DOT)) {
                ++removeDirLevel;
                continue;
            }
            if (currentToken.equals(DOT)) continue;
            if (removeDirLevel > 0) {
                --removeDirLevel;
                continue;
            }
            out.insert(0, SLASH);
            out.insert(0, currentToken);
        }
        if (removeDirLevel > 0) {
            return EMPTY_STRING;
        }
        if (!isDirectory) {
            out.deleteCharAt(out.length() - 1);
        }
        return out.toString();
    }

    private void setFile(File thisFile) {
        this.mFile = thisFile;
    }

    private File getFile() {
        return this.mFile;
    }

    void copyResourcesFrom(Document srcDoc, HashMap<String, String> objectRenameMap) throws Exception {
        if (srcDoc.getFile() != null) {
            ArrayList<String> copiedFolder = new ArrayList<String>();
            Set<String> refObjPathSet = objectRenameMap.keySet();
            FileInputStream tempFileStream = new FileInputStream(srcDoc.getFile());
            ZipInputStream zipStream = new ZipInputStream(tempFileStream);
            ZipEntry zipEntry = zipStream.getNextEntry();
            while (zipEntry != null) {
                String refObjPath = zipEntry.getName();
                for (String path : refObjPathSet) {
                    if (refObjPath.equals(path)) {
                        String newObjPath = objectRenameMap.get(refObjPath);
                        refObjPath = this.normalizeFilePath(refObjPath);
                        String mediaType = srcDoc.getPackage().getFileEntry(refObjPath).getMediaTypeString();
                        InputStream is = this.readAsInputStream(zipStream);
                        this.getPackage().insert(is, newObjPath, mediaType);
                        break;
                    }
                    if (!refObjPath.startsWith(path + SLASH)) continue;
                    String suffix = refObjPath.substring(path.length());
                    String newObjPath = objectRenameMap.get(path) + suffix;
                    refObjPath = this.normalizeFilePath(refObjPath);
                    String mediaType = srcDoc.getPackage().getFileEntry(refObjPath).getMediaTypeString();
                    InputStream is = this.readAsInputStream(zipStream);
                    this.getPackage().insert(is, newObjPath, mediaType);
                    if (copiedFolder.contains(path)) break;
                    mediaType = srcDoc.getPackage().getFileEntry(path + SLASH).getMediaTypeString();
                    this.getPackage().insert((InputStream)null, objectRenameMap.get(path) + SLASH, mediaType);
                    copiedFolder.add(path);
                    break;
                }
                zipEntry = zipStream.getNextEntry();
            }
            zipStream.close();
            tempFileStream.close();
        } else {
            Set<String> refObjPathSet = objectRenameMap.keySet();
            for (String refObjPath : refObjPathSet) {
                String newObjPath = objectRenameMap.get(refObjPath);
                InputStream is = srcDoc.getPackage().getInputStream(refObjPath);
                if (is != null) {
                    String mediaType = srcDoc.getPackage().getFileEntry(refObjPath).getMediaTypeString();
                    this.getPackage().insert(is, newObjPath, mediaType);
                    continue;
                }
                Document embedDoc = srcDoc.getEmbeddedDocument(refObjPath);
                if (embedDoc == null) continue;
                this.insertDocument((OdfPackageDocument)embedDoc, newObjPath);
            }
        }
    }

    void copyLinkedRef(OdfElement sourceCloneEle) {
        try {
            OdfFileDom fileDom = (OdfFileDom)sourceCloneEle.getOwnerDocument();
            XPath xpath = fileDom instanceof OdfContentDom ? ((OdfContentDom)fileDom).getXPath() : ((OdfStylesDom)fileDom).getXPath();
            OdfPackageDocument srcDoc = fileDom.getDocument();
            HashMap<String, String> objectRenameMap = new HashMap<String, String>();
            NodeList linkNodes = (NodeList)xpath.evaluate(".//*[@xlink:href]", sourceCloneEle, XPathConstants.NODESET);
            for (int i = 0; i <= linkNodes.getLength(); ++i) {
                InputStream is;
                OdfFileEntry fileEntry;
                OdfElement object = null;
                if (linkNodes.getLength() == i) {
                    if (!sourceCloneEle.hasAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href")) break;
                    object = sourceCloneEle;
                } else {
                    object = (OdfElement)linkNodes.item(i);
                }
                String refObjPath = object.getAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href");
                if (refObjPath == null || refObjPath.length() <= 0) continue;
                boolean hasPrefix = false;
                String prefix = "./";
                if (refObjPath.startsWith(prefix)) {
                    refObjPath = refObjPath.substring(2);
                    hasPrefix = true;
                }
                if ((fileEntry = this.getPackage().getFileEntry(refObjPath)) == null) {
                    fileEntry = this.getPackage().getFileEntry(refObjPath + SLASH);
                }
                String newObjPath = refObjPath;
                if (fileEntry != null) {
                    newObjPath = (String)objectRenameMap.get(refObjPath);
                    if (newObjPath == null) {
                        int dotIndex = refObjPath.indexOf(DOT);
                        newObjPath = dotIndex != -1 ? refObjPath.substring(0, dotIndex) + "-" + this.makeUniqueName() + refObjPath.substring(dotIndex) : refObjPath + "-" + this.makeUniqueName();
                        objectRenameMap.put(refObjPath, newObjPath);
                    }
                    object.setAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "xlink:href", hasPrefix ? prefix + newObjPath : newObjPath);
                }
                if ((is = srcDoc.getPackage().getInputStream(refObjPath)) != null) {
                    String mediaType = srcDoc.getPackage().getFileEntry(refObjPath).getMediaTypeString();
                    this.getPackage().insert(is, newObjPath, mediaType);
                    continue;
                }
                Document embedDoc = ((Document)srcDoc).getEmbeddedDocument(refObjPath);
                if (embedDoc == null) continue;
                this.insertDocument((OdfPackageDocument)embedDoc, newObjPath);
            }
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    void copyForeignStyleRef(OdfElement sourceCloneEle, Document srcDoc) {
        try {
            OdfElement cloneStyleElement;
            ArrayList<String> tempList = new ArrayList<String>();
            OdfContentDom srcContentDom = srcDoc.getContentDom();
            XPath xpath = srcContentDom.getXPath();
            String styleQName = "style:name";
            NodeList srcStyleDefNodeList = (NodeList)xpath.evaluate("*/office:automatic-styles/*[@" + styleQName + "]", srcContentDom, XPathConstants.NODESET);
            IdentityHashMap<OdfElement, List<OdfElement>> srcContentStyleCloneEleList = new IdentityHashMap<OdfElement, List<OdfElement>>();
            IdentityHashMap<OdfElement, OdfElement> appendContentStyleList = new IdentityHashMap<OdfElement, OdfElement>();
            this.getCopyStyleList(null, sourceCloneEle, styleQName, srcStyleDefNodeList, srcContentStyleCloneEleList, appendContentStyleList, tempList, true);
            srcStyleDefNodeList = (NodeList)xpath.evaluate(".//*[@" + styleQName + "]", srcDoc.getStylesDom(), XPathConstants.NODESET);
            IdentityHashMap<OdfElement, List<OdfElement>> srcStylesStyleCloneEleList = new IdentityHashMap<OdfElement, List<OdfElement>>();
            IdentityHashMap<OdfElement, OdfElement> appendStylesStyleList = new IdentityHashMap<OdfElement, OdfElement>();
            tempList.clear();
            this.getCopyStyleList(null, sourceCloneEle, styleQName, srcStyleDefNodeList, srcStylesStyleCloneEleList, appendStylesStyleList, tempList, true);
            this.insertCollectedStyle(styleQName, srcContentStyleCloneEleList, (OdfFileDom)this.getContentDom(), appendContentStyleList);
            this.insertCollectedStyle(styleQName, srcStylesStyleCloneEleList, (OdfFileDom)this.getStylesDom(), appendStylesStyleList);
            tempList.clear();
            styleQName = "draw:name";
            srcStyleDefNodeList = (NodeList)xpath.evaluate(".//*[@" + styleQName + "]", srcDoc.getStylesDom(), XPathConstants.NODESET);
            IdentityHashMap<OdfElement, List<OdfElement>> srcDrawStyleCloneEleList = new IdentityHashMap<OdfElement, List<OdfElement>>();
            IdentityHashMap<OdfElement, OdfElement> appendDrawStyleList = new IdentityHashMap<OdfElement, OdfElement>();
            for (OdfElement styleElement : appendContentStyleList.keySet()) {
                cloneStyleElement = appendContentStyleList.get(styleElement);
                this.getCopyStyleList(styleElement, cloneStyleElement, styleQName, srcStyleDefNodeList, srcDrawStyleCloneEleList, appendDrawStyleList, tempList, false);
            }
            for (OdfElement styleElement : appendStylesStyleList.keySet()) {
                cloneStyleElement = appendStylesStyleList.get(styleElement);
                this.getCopyStyleList(styleElement, cloneStyleElement, styleQName, srcStyleDefNodeList, srcDrawStyleCloneEleList, appendDrawStyleList, tempList, false);
            }
            this.insertCollectedStyle(styleQName, srcDrawStyleCloneEleList, (OdfFileDom)this.getStylesDom(), appendDrawStyleList);
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void insertCollectedStyle(String styleQName, IdentityHashMap<OdfElement, List<OdfElement>> srcStyleCloneEleList, OdfFileDom dom, IdentityHashMap<OdfElement, OdfElement> appendStyleList) {
        try {
            OdfElement cloneStyleElement;
            String stylePrefix = OdfNamespace.getPrefixPart((String)styleQName);
            String styleLocalName = OdfNamespace.getLocalPart((String)styleQName);
            String styleURI = OdfDocumentNamespace.STYLE.getUri();
            if (stylePrefix.equals("draw")) {
                styleURI = OdfDocumentNamespace.DRAW.getUri();
            }
            XPath xpath = dom.getXPath();
            NodeList destStyleNodeList = dom instanceof OdfContentDom ? (NodeList)xpath.evaluate("*/office:automatic-styles/*[@" + styleQName + "]", dom, XPathConstants.NODESET) : (NodeList)xpath.evaluate(".//*[@" + styleQName + "]", dom, XPathConstants.NODESET);
            for (OdfElement styleElement : srcStyleCloneEleList.keySet()) {
                String styleName;
                List<String> newStyleNameList;
                cloneStyleElement = appendStyleList.get(styleElement);
                if (cloneStyleElement == null) {
                    cloneStyleElement = (OdfElement)styleElement.cloneNode(true);
                    appendStyleList.put(styleElement, cloneStyleElement);
                }
                if ((newStyleNameList = this.styleRenameMap.get(styleName = styleElement.getAttributeNS(styleURI, styleLocalName))) == null && this.isStyleNameExist(destStyleNodeList, styleName) == null) continue;
                String newStyleName = null;
                if (newStyleNameList == null) {
                    newStyleNameList = new ArrayList<String>();
                    newStyleName = styleName + "-" + this.makeUniqueName();
                    newStyleNameList.add(newStyleName);
                    this.styleRenameMap.put(styleName, newStyleNameList);
                } else {
                    for (int i = 0; i < newStyleNameList.size(); ++i) {
                        String styleNameIter = newStyleNameList.get(i);
                        OdfElement destStyleElementWithNewName = this.isStyleNameExist(destStyleNodeList, styleNameIter);
                        cloneStyleElement.setAttributeNS(styleURI, styleQName, styleNameIter);
                        if (destStyleElementWithNewName == null || !destStyleElementWithNewName.equals((Object)cloneStyleElement)) continue;
                        newStyleName = styleNameIter;
                        break;
                    }
                    if (newStyleName == null) {
                        newStyleName = styleName + "-" + this.makeUniqueName();
                        newStyleNameList.add(newStyleName);
                    }
                }
                if (!this.changeStyleRefName(srcStyleCloneEleList.get(styleElement), styleName, newStyleName)) continue;
                cloneStyleElement.setAttributeNS(styleURI, styleQName, newStyleName);
                String displayName = cloneStyleElement.getAttributeNS(styleURI, "display-name");
                if (displayName == null || displayName.length() <= 0) continue;
                cloneStyleElement.setAttributeNS(styleURI, stylePrefix + ":display-name", displayName + newStyleName.substring(newStyleName.length() - 8));
            }
            for (OdfElement styleElement : appendStyleList.keySet()) {
                cloneStyleElement = appendStyleList.get(styleElement);
                String newStyleName = cloneStyleElement.getAttributeNS(styleURI, styleLocalName);
                Boolean isAppended = this.styleAppendMap.get(newStyleName);
                if (isAppended != null && isAppended.booleanValue()) continue;
                this.styleAppendMap.put(newStyleName, true);
                OdfElement cloneForeignStyleElement = (OdfElement)this.cloneForeignElement((Node)cloneStyleElement, dom, true);
                String styleElePath = this.getElementPath(styleElement);
                this.appendForeignStyleElement(cloneForeignStyleElement, dom, styleElePath);
                this.copyLinkedRef(cloneStyleElement);
            }
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void getCopyStyleList(OdfElement ele, OdfElement cloneEle, String styleQName, NodeList srcStyleNodeList, IdentityHashMap<OdfElement, List<OdfElement>> copyStyleEleList, IdentityHashMap<OdfElement, OdfElement> appendStyleList, List<String> attrStrList, boolean loop) {
        try {
            String styleLocalName = OdfNamespace.getLocalPart((String)styleQName);
            String stylePrefix = OdfNamespace.getPrefixPart((String)styleQName);
            String styleURI = OdfDocumentNamespace.STYLE.getUri();
            if (stylePrefix.equals("draw")) {
                styleURI = OdfDocumentNamespace.DRAW.getUri();
            }
            String cloneEleStr = cloneEle.toString();
            for (int i = 0; i < srcStyleNodeList.getLength(); ++i) {
                OdfElement styleElement = (OdfElement)srcStyleNodeList.item(i);
                String styleName = styleElement.getAttributeNS(styleURI, styleLocalName);
                if (styleName == null) continue;
                int index = 0;
                index = cloneEleStr.indexOf("=\"" + styleName + "\"", index);
                while (index >= 0) {
                    int lastSpaceIndex;
                    String subStr = cloneEleStr.substring(0, index);
                    String attrStr = subStr.substring((lastSpaceIndex = subStr.lastIndexOf(32)) + 1, index);
                    if (attrStr.equals(styleQName) || attrStrList.contains(attrStr + "=" + "\"" + styleName + "\"")) {
                        index = cloneEleStr.indexOf("=\"" + styleName + "\"", index + styleName.length());
                        continue;
                    }
                    attrStrList.add(attrStr + "=" + "\"" + styleName + "\"");
                    XPath xpath = ((OdfFileDom)cloneEle.getOwnerDocument()).getXPath();
                    NodeList styleRefNodes = (NodeList)xpath.evaluate(".//*[@" + attrStr + "='" + styleName + "']", cloneEle, XPathConstants.NODESET);
                    boolean isExist = false;
                    for (int j = 0; j <= styleRefNodes.getLength(); ++j) {
                        OdfElement styleRefElement = null;
                        if (j == styleRefNodes.getLength()) {
                            isExist = this.isStyleNameRefExist((Node)cloneEle, styleName, false);
                            if (!isExist) continue;
                            styleRefElement = cloneEle;
                        } else {
                            OdfElement tmpElement = (OdfElement)styleRefNodes.item(j);
                            if (!this.isStyleNameRefExist((Node)tmpElement, styleName, false)) continue;
                            styleRefElement = tmpElement;
                        }
                        boolean hasLoopStyleDef = true;
                        if (copyStyleEleList.get(styleElement) == null) {
                            ArrayList styleRefEleList = new ArrayList();
                            copyStyleEleList.put(styleElement, styleRefEleList);
                            hasLoopStyleDef = false;
                        }
                        copyStyleEleList.get(styleElement).add(styleRefElement);
                        OdfElement cloneStyleElement = appendStyleList.get(styleElement);
                        if (cloneStyleElement == null) {
                            cloneStyleElement = (OdfElement)styleElement.cloneNode(true);
                            appendStyleList.put(styleElement, cloneStyleElement);
                        }
                        if (!loop || hasLoopStyleDef) continue;
                        this.getCopyStyleList(styleElement, cloneStyleElement, styleQName, srcStyleNodeList, copyStyleEleList, appendStyleList, attrStrList, loop);
                    }
                    index = cloneEleStr.indexOf("=\"" + styleName + "\"", index + styleName.length());
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void appendForeignStyleElement(OdfElement cloneStyleEle, OdfFileDom dom, String styleElePath) {
        StringTokenizer token = new StringTokenizer(styleElePath, SLASH);
        boolean isExist = true;
        Node iterNode = dom.getFirstChild();
        Object parentNode = dom;
        while (token.hasMoreTokens()) {
            String onePath = token.nextToken();
            while (iterNode != null && isExist) {
                String path = iterNode.getNamespaceURI();
                String prefix = iterNode.getPrefix();
                path = prefix == null ? path + "@" + iterNode.getLocalName() : path + "@" + prefix + COLON + iterNode.getLocalName();
                if (!path.equals(onePath)) {
                    iterNode = iterNode.getNextSibling();
                    continue;
                }
                parentNode = iterNode;
                iterNode = iterNode.getFirstChild();
                break;
            }
            if (iterNode != null) continue;
            if (isExist) {
                isExist = false;
            }
            StringTokenizer token2 = new StringTokenizer(onePath, "@");
            OdfElement newElement = dom.createElementNS(OdfName.newName((String)token2.nextToken(), (String)token2.nextToken()));
            parentNode.appendChild((Node)newElement);
            parentNode = newElement;
        }
        parentNode.appendChild((Node)cloneStyleEle);
    }

    private String getElementPath(OdfElement styleEle) {
        String path = EMPTY_STRING;
        Node parentNode = styleEle.getParentNode();
        while (!(parentNode instanceof OdfFileDom)) {
            String qname = null;
            String prefix = parentNode.getPrefix();
            qname = prefix == null ? parentNode.getLocalName() : prefix + COLON + parentNode.getLocalName();
            path = parentNode.getNamespaceURI() + "@" + qname + SLASH + path;
            parentNode = parentNode.getParentNode();
        }
        return path;
    }

    private boolean changeStyleRefName(List<OdfElement> list, String oldStyleName, String newStyleName) {
        boolean rtn = false;
        block2: for (int index = 0; index < list.size(); ++index) {
            OdfElement element = list.get(index);
            NamedNodeMap attributes = element.getAttributes();
            if (attributes == null) continue;
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node item = attributes.item(i);
                String value = item.getNodeValue();
                if (!oldStyleName.equals(value)) continue;
                try {
                    item.setNodeValue(newStyleName);
                    rtn = true;
                    continue block2;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        }
        return rtn;
    }

    private boolean isStyleNameRefExist(Node element, String styleName, boolean deep) {
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node item = attributes.item(i);
                if (!item.getNodeValue().equals(styleName) || item.getNodeName().equals("style:name")) continue;
                return true;
            }
        }
        if (deep) {
            for (Node childNode = element.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                if (!this.isStyleNameRefExist(childNode, styleName, true)) {
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    private OdfElement isStyleNameExist(NodeList nodeList, String styleName) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            OdfElement element = (OdfElement)nodeList.item(i);
            String name = element.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "name");
            if (!name.equals(styleName)) continue;
            return element;
        }
        return null;
    }

    boolean deleteLinkedRef(OdfElement odfEle) {
        boolean success = true;
        try {
            OdfContentDom contentDom = this.getContentDom();
            XPath xpath = contentDom.getXPath();
            NodeList linkNodes = (NodeList)xpath.evaluate("//*[@xlink:href]", contentDom, XPathConstants.NODESET);
            for (int i = 0; i < linkNodes.getLength(); ++i) {
                OdfFileEntry fileEntry;
                NodeList pathNodes;
                int refCount;
                OdfElement object = (OdfElement)linkNodes.item(i);
                String refObjPath = object.getAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href");
                short relation = odfEle.compareDocumentPosition((Node)object);
                if ((relation & 0x10) <= 0 || refObjPath == null || refObjPath.length() <= 0 || (refCount = (pathNodes = (NodeList)xpath.evaluate("//*[@xlink:href='" + refObjPath + "']", this.getContentDom(), XPathConstants.NODESET)).getLength()) != 1) continue;
                if (refObjPath.startsWith("./")) {
                    refObjPath = refObjPath.substring(2);
                }
                if ((fileEntry = this.getPackage().getFileEntry(refObjPath)) != null) {
                    this.getPackage().remove(refObjPath);
                    continue;
                }
                fileEntry = this.getPackage().getFileEntry(refObjPath + SLASH);
                this.removeDocument(refObjPath);
            }
        }
        catch (XPathExpressionException e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, null, e);
            success = false;
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, null, e);
            success = false;
        }
        return success;
    }

    boolean deleteStyleRef(OdfElement odfEle) {
        boolean success = true;
        try {
            int i;
            ArrayList<OdfElement> removeStyles = new ArrayList<OdfElement>();
            OdfOfficeAutomaticStyles autoStyles = this.getContentDom().getAutomaticStyles();
            NodeList stylesList = autoStyles.getChildNodes();
            OdfContentDom contentDom = this.getContentDom();
            XPath xpath = contentDom.getXPath();
            for (i = 0; i < stylesList.getLength(); ++i) {
                DrawPageElement tempPage;
                NodeList styleNodes;
                int styleCnt;
                OdfElement node;
                String styleName;
                Node item = stylesList.item(i);
                if (!(item instanceof OdfElement) || (styleName = (node = (OdfElement)item).getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "name")) == null || (styleCnt = (styleNodes = (NodeList)xpath.evaluate("//*[@*='" + styleName + "']", contentDom, XPathConstants.NODESET)).getLength()) <= 1) continue;
                OdfElement elementFirst = (OdfElement)styleNodes.item(1);
                OdfElement elementLast = (OdfElement)styleNodes.item(styleCnt - 1);
                boolean isSamePage = false;
                if (elementFirst instanceof DrawPageElement && (tempPage = (DrawPageElement)elementFirst).equals((Object)odfEle)) {
                    isSamePage = true;
                }
                short relationFirst = odfEle.compareDocumentPosition((Node)elementFirst);
                short relationLast = odfEle.compareDocumentPosition((Node)elementLast);
                if (((relationFirst & 0x10) <= 0 || (relationLast & 0x10) <= 0) && (!isSamePage || styleCnt != 1) || !(node instanceof OdfStyleBase)) continue;
                removeStyles.add(node);
            }
            for (i = 0; i < removeStyles.size(); ++i) {
                autoStyles.removeChild((Node)removeStyles.get(i));
            }
        }
        catch (Exception e) {
            Logger.getLogger(Document.class.getName()).log(Level.SEVERE, null, e);
            success = false;
        }
        return success;
    }

    @Override
    public Table addTable() {
        return this.getTableContainerImpl().addTable();
    }

    @Override
    public Table addTable(int numRows, int numCols) {
        return this.getTableContainerImpl().addTable(numRows, numCols);
    }

    @Override
    public Table getTableByName(String name) {
        return this.getTableContainerImpl().getTableByName(name);
    }

    @Override
    public List<Table> getTableList() {
        return this.getTableContainerImpl().getTableList();
    }

    @Override
    public Table.TableBuilder getTableBuilder() {
        return this.getTableContainerImpl().getTableBuilder();
    }

    protected TableContainer getTableContainerImpl() {
        if (this.tableContainerImpl == null) {
            this.tableContainerImpl = new TableContainerImpl();
        }
        return this.tableContainerImpl;
    }

    protected IdentityHashMap<OdfElement, Component> getComponentMap() {
        return this.mComponentRepository;
    }

    private class TableContainerImpl
    extends AbstractTableContainer {
        private TableContainerImpl() {
        }

        public OdfElement getTableContainerElement() {
            OdfElement containerElement = null;
            try {
                containerElement = Document.this.getContentRoot();
            }
            catch (Exception e) {
                Logger.getLogger(Document.class.getName()).log(Level.SEVERE, null, e);
            }
            return containerElement;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScriptType {
        WESTERN,
        CJK,
        CTL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        CHART("application/vnd.oasis.opendocument.chart", "odc"),
        CHART_TEMPLATE("application/vnd.oasis.opendocument.chart-template", "otc"),
        FORMULA("application/vnd.oasis.opendocument.formula", "odf"),
        FORMULA_TEMPLATE("application/vnd.oasis.opendocument.formula-template", "otf"),
        DATABASE_FRONT_END("application/vnd.oasis.opendocument.base", "odb"),
        GRAPHICS("application/vnd.oasis.opendocument.graphics", "odg"),
        GRAPHICS_TEMPLATE("application/vnd.oasis.opendocument.graphics-template", "otg"),
        IMAGE("application/vnd.oasis.opendocument.image", "odi"),
        IMAGE_TEMPLATE("application/vnd.oasis.opendocument.image-template", "oti"),
        PRESENTATION("application/vnd.oasis.opendocument.presentation", "odp"),
        PRESENTATION_TEMPLATE("application/vnd.oasis.opendocument.presentation-template", "otp"),
        SPREADSHEET("application/vnd.oasis.opendocument.spreadsheet", "ods"),
        SPREADSHEET_TEMPLATE("application/vnd.oasis.opendocument.spreadsheet-template", "ots"),
        TEXT("application/vnd.oasis.opendocument.text", "odt"),
        TEXT_MASTER("application/vnd.oasis.opendocument.text-master", "odm"),
        TEXT_TEMPLATE("application/vnd.oasis.opendocument.text-template", "ott"),
        TEXT_WEB("application/vnd.oasis.opendocument.text-web", "oth");

        private final String mMediaType;
        private final String mSuffix;

        private OdfMediaType(String mediaType, String suffix) {
            this.mMediaType = mediaType;
            this.mSuffix = suffix;
        }

        public String getMediaTypeString() {
            return this.mMediaType;
        }

        public String getSuffix() {
            return this.mSuffix;
        }

        public static OdfMediaType getOdfMediaType(String mediaType) {
            OdfMediaType odfMediaType = null;
            if (mediaType != null) {
                String mediaTypeShort = mediaType.substring(mediaType.lastIndexOf(Document.DOT) + 1, mediaType.length());
                mediaTypeShort = mediaTypeShort.replace('-', '_').toUpperCase();
                try {
                    odfMediaType = OdfMediaType.valueOf(mediaTypeShort);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Given mediaType '" + mediaType + "' is either not yet supported or not an ODF mediatype!");
                }
            }
            return odfMediaType;
        }
    }
}

