/*
 * Decompiled with CFR 0.152.
 */
package schema2template.model;

import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.NameClassVisitor;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.ValueExp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import schema2template.example.odf.OdfHelper;
import schema2template.model.MSVExpressionType;
import schema2template.model.MSVExpressionVisitorChildren;
import schema2template.model.MSVExpressionVisitorType;
import schema2template.model.MSVNameClassVisitorList;

public final class MSVExpressionIterator
implements Iterator<Expression> {
    private static final Logger LOG = Logger.getLogger(MSVExpressionIterator.class.getName());
    private Expression mCurrentExpression;
    public int mCurrentExpressionDepth;
    private MSVExpressionVisitorChildren mVisitor;
    private Stack<UniqueAncestor> mAncestorsAndCurrent;
    private HashSet<Expression> mKnownElementExpressions;
    private Class mDesiredExpression;
    private boolean mOnlyChildren;
    private int mCurrentDepth = 0;
    public static final boolean ALL_SUBTREE = true;
    public static final boolean DIRECT_CHILDREN_ONLY = true;

    public int getDepth() {
        return this.mCurrentDepth;
    }

    public MSVExpressionIterator(Expression root) {
        this(root, Expression.class, false);
    }

    public MSVExpressionIterator(Expression root, Class desiredExpression) {
        this(root, desiredExpression, false);
    }

    public MSVExpressionIterator(Expression root, Class desiredExpression, boolean onlyChildren) {
        this.mCurrentExpression = root;
        this.mDesiredExpression = desiredExpression;
        this.mOnlyChildren = onlyChildren;
        this.mVisitor = new MSVExpressionVisitorChildren();
        this.mKnownElementExpressions = new HashSet();
        this.mAncestorsAndCurrent = new Stack();
        this.mAncestorsAndCurrent.push(new UniqueAncestor(root, 0));
        while (!this.mDesiredExpression.isInstance(this.mCurrentExpression) && this.mCurrentExpression != null) {
            this.mCurrentExpression = this.getNextExpression();
        }
        if (this.mOnlyChildren && root == this.mCurrentExpression) {
            this.mCurrentExpression = this.getNextExpression();
        }
    }

    public static String dumpMSVExpressionTree(Expression rootExpression) throws Exception {
        MSVExpressionIterator iterator = new MSVExpressionIterator(rootExpression);
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            Expression expr = iterator.next();
            builder.append(MSVExpressionIterator.dumpMSVExpression(expr, iterator.getDepth())).append("\n");
        }
        return builder.toString();
    }

    private static String dumpMSVExpression(Expression expr, int depth) {
        String returnValue = null;
        MSVExpressionVisitorType typeVisitor = new MSVExpressionVisitorType();
        MSVNameClassVisitorList nameVisitor = new MSVNameClassVisitorList();
        MSVExpressionType type = (MSVExpressionType)((Object)expr.visit((ExpressionVisitor)typeVisitor));
        returnValue = depth + ": " + type.toString();
        if (expr instanceof NameClassAndExpression) {
            List names = (List)((NameClassAndExpression)expr).getNameClass().visit((NameClassVisitor)nameVisitor);
            for (String name : names) {
                returnValue = returnValue + " \"" + name + "\",";
                if (!OdfHelper.DEBUG.booleanValue()) continue;
                System.out.println(returnValue);
            }
        } else if (expr instanceof ReferenceExp) {
            returnValue = returnValue + " '" + ((ReferenceExp)expr).name + "',";
            if (OdfHelper.DEBUG.booleanValue()) {
                System.out.println(returnValue);
            }
        } else if (type == MSVExpressionType.VALUE) {
            returnValue = returnValue + " '" + ((ValueExp)expr).value.toString() + "',";
            if (OdfHelper.DEBUG.booleanValue()) {
                System.out.println(returnValue);
            }
        } else if (type == MSVExpressionType.DATA) {
            returnValue = returnValue + " '" + ((DataExp)expr).getName().localName + "',";
            if (OdfHelper.DEBUG.booleanValue()) {
                System.out.println(returnValue);
            }
        } else if (OdfHelper.DEBUG.booleanValue()) {
            System.out.println(returnValue);
        }
        return returnValue;
    }

    @Override
    public boolean hasNext() {
        return this.mCurrentExpression != null;
    }

    private Expression getNextExpression() {
        Expression nextExpression = null;
        if (this.mCurrentExpression != null) {
            Expression nextExpCandidate;
            List children;
            if (!(this.mOnlyChildren && this.mAncestorsAndCurrent.size() != 1 && this.mAncestorsAndCurrent.peek().mExp instanceof ElementExp || (children = (List)this.mCurrentExpression.visit((ExpressionVisitor)this.mVisitor)).size() <= 0 || !this.isNoKnownElement(nextExpCandidate = (Expression)children.get(0)))) {
                nextExpression = nextExpCandidate;
                this.mAncestorsAndCurrent.push(new UniqueAncestor(nextExpression, 0));
            }
            while (nextExpression == null && this.mAncestorsAndCurrent.size() > 1) {
                Expression nextExpCandidate2;
                UniqueAncestor uniqueAncestor = this.mAncestorsAndCurrent.pop();
                Expression parent = this.mAncestorsAndCurrent.peek().mExp;
                List siblings = (List)parent.visit((ExpressionVisitor)this.mVisitor);
                int nextSiblingIndex = uniqueAncestor.mSiblingIndex + 1;
                if (nextSiblingIndex >= siblings.size() || !this.isNoKnownElement(nextExpCandidate2 = (Expression)siblings.get(nextSiblingIndex))) continue;
                nextExpression = nextExpCandidate2;
                this.mAncestorsAndCurrent.push(new UniqueAncestor(nextExpression, nextSiblingIndex));
            }
        }
        return nextExpression;
    }

    private boolean isNoKnownElement(Expression exp) {
        boolean isNew = false;
        if (!(exp instanceof ElementExp) || !this.mKnownElementExpressions.contains(exp)) {
            this.mKnownElementExpressions.add(exp);
            isNew = true;
        }
        return isNew;
    }

    @Override
    public Expression next() {
        if (this.mCurrentExpression == null) {
            return null;
        }
        Expression retVal = this.mCurrentExpression;
        this.mCurrentDepth = this.mAncestorsAndCurrent.size() - 1;
        this.mCurrentExpression = this.getNextExpression();
        while (!this.mDesiredExpression.isInstance(this.mCurrentExpression) && this.mCurrentExpression != null) {
            this.mCurrentExpression = this.getNextExpression();
        }
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    private class UniqueAncestor {
        private Expression mExp;
        private int mSiblingIndex;

        public UniqueAncestor(Expression exp, int siblingIndex) {
            this.mExp = exp;
            this.mSiblingIndex = siblingIndex;
        }
    }
}

