/*
 * Decompiled with CFR 0.152.
 */
package schema2template.model;

import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import schema2template.model.MSVExpressionVisitorChildren;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSVExpressionIterator
implements Iterator<Expression> {
    private Expression mNextElement;
    private MSVExpressionVisitorChildren mVisitor;
    private HashSet<Expression> mVisited;
    private Stack<Expression> mAncestors;
    private Class mSuperclass;
    private boolean mAllElements;
    public static final boolean ALL_ELEMENTS = true;
    public static final boolean DIRECT_CHILDREN_ONLY = false;

    public MSVExpressionIterator(Expression root) {
        this(root, Expression.class, true);
    }

    public MSVExpressionIterator(Expression root, Class superClass) {
        this(root, superClass, true);
    }

    public MSVExpressionIterator(Expression root, Class superClass, boolean allElements) {
        this.mSuperclass = superClass;
        this.mAllElements = allElements;
        this.mAncestors = new Stack();
        this.mAncestors.push(root);
        this.mVisited = new HashSet();
        this.mVisitor = new MSVExpressionVisitorChildren();
        this.mNextElement = root;
        if (this.hasNext() && !this.mAllElements) {
            this.next();
            this.mVisited.remove(root);
        }
        if (this.hasNext() && !this.mSuperclass.isInstance(this.mNextElement)) {
            this.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.mNextElement != null;
    }

    private void setNext() {
        while (true) {
            List children = (List)this.mNextElement.visit((ExpressionVisitor)this.mVisitor);
            this.mNextElement = null;
            if (this.mAllElements || this.mAncestors.size() <= 1 || !(this.mAncestors.peek() instanceof ElementExp)) {
                for (Expression candidate : children) {
                    if (this.mVisited.contains(candidate)) continue;
                    this.mNextElement = candidate;
                    this.mAncestors.push(this.mNextElement);
                    break;
                }
            }
            block2: while (this.mNextElement == null && this.mAncestors.size() > 1) {
                this.mAncestors.pop();
                Expression parent = this.mAncestors.peek();
                List siblings = (List)parent.visit((ExpressionVisitor)this.mVisitor);
                for (Expression candidate : siblings) {
                    if (this.mVisited.contains(candidate)) continue;
                    this.mNextElement = candidate;
                    this.mAncestors.push(this.mNextElement);
                    continue block2;
                }
            }
            if (this.mNextElement == null || this.mSuperclass.isInstance(this.mNextElement)) {
                return;
            }
            this.mVisited.add(this.mNextElement);
        }
    }

    @Override
    public Expression next() {
        if (this.mNextElement == null) {
            return null;
        }
        Expression retval = this.mNextElement;
        this.mVisited.add(retval);
        this.setNext();
        return retval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

