/*
 * Decompiled with CFR 0.152.
 */
package schema2template.example.odf;

import java.util.SortedSet;
import java.util.TreeSet;
import schema2template.example.odf.OdfModel;
import schema2template.model.PuzzlePiece;
import schema2template.model.PuzzlePieceSet;
import schema2template.model.QNamed;
import schema2template.model.XMLModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCodeBaseClass
implements Comparable<SourceCodeBaseClass>,
QNamed {
    private SortedSet<PuzzlePiece> mSubelements;
    private String mBasename;
    private OdfModel mOdfmodel;

    protected SourceCodeBaseClass(OdfModel odfmodel, String basename, SortedSet<PuzzlePiece> subelements) {
        this.mSubelements = subelements;
        this.mBasename = basename;
        this.mOdfmodel = odfmodel;
    }

    @Override
    public int compareTo(SourceCodeBaseClass o) {
        return this.mBasename.compareTo(o.mBasename);
    }

    public boolean equals(Object o) {
        return o instanceof SourceCodeBaseClass && ((SourceCodeBaseClass)o).mBasename.equals(this.mBasename);
    }

    public int hashCode() {
        return this.mBasename.hashCode();
    }

    @Override
    public String getLocalName() {
        return XMLModel.extractLocalname(this.mBasename);
    }

    @Override
    public String getQName() {
        return this.mBasename;
    }

    @Override
    public String getNamespace() {
        return XMLModel.extractNamespace(this.mBasename);
    }

    public String toString() {
        return this.getQName();
    }

    public PuzzlePieceSet getElements() {
        return new PuzzlePieceSet(this.mSubelements);
    }

    public PuzzlePieceSet getBaseAttributes() {
        TreeSet<PuzzlePiece> attributes = new TreeSet<PuzzlePiece>(this.mSubelements.last().getAttributes());
        for (PuzzlePiece subelement : this.mSubelements.headSet(this.mSubelements.last())) {
            attributes.retainAll(subelement.getAttributes());
        }
        return new PuzzlePieceSet(attributes);
    }

    public boolean isStylable() {
        boolean notStylable = false;
        boolean stylable = false;
        for (PuzzlePiece def : this.getElements()) {
            if (this.mOdfmodel.isStylable(def)) {
                stylable = true;
                continue;
            }
            notStylable = true;
        }
        if (stylable && !notStylable) {
            return true;
        }
        if (notStylable && !stylable) {
            return false;
        }
        throw new RuntimeException("Base Class " + this.getQName() + " used for stylable AND not stylable elements. This is not possible.");
    }
}

