/*
 * Decompiled with CFR 0.152.
 */
package schema2template.template;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GrammarAdditionsFileHandler
extends DefaultHandler {
    private static final String ALL_ELEMENTS = "*";
    private boolean inGrammarAdditions = false;
    private boolean inElements = false;
    private boolean inElement = false;
    private boolean inDatatypes = false;
    private boolean inData = false;
    private boolean inAttributes = false;
    private boolean inAttribute = false;
    private Locator mLocator;
    private Map<String, String> mComponentRootElementNames;
    private Set<String> mRepetitionAttributeNames;
    private Map<String, String> mElementSuperClassNames;
    private Map<String, String> mElementBaseNames;
    private Map<String, List<String>> mElementStyleFamilies;
    private Set<String> mProcessedElements;
    private Map<String, String[]> mDatatypeValueConversion;
    private Map<String, Map<String, String>> mAttributeDefaults;
    private Set<String> mProcessedDatatypes;

    public GrammarAdditionsFileHandler(Map<String, String> elementBaseNames, Map<String, String> elementSuperClassNames, Map<String, String> componentRootElementNames, Set<String> repetitionAttributeNames, Map<String, Map<String, String>> attributeDefaultMap, Map<String, List<String>> elementNameToFamilyMap, Map<String, String[]> datatypeValueConversion) {
        this.mElementBaseNames = elementBaseNames;
        this.mElementSuperClassNames = elementSuperClassNames;
        this.mComponentRootElementNames = componentRootElementNames;
        this.mRepetitionAttributeNames = repetitionAttributeNames;
        this.mAttributeDefaults = attributeDefaultMap;
        this.mDatatypeValueConversion = datatypeValueConversion;
        this.mElementStyleFamilies = elementNameToFamilyMap;
        this.mProcessedElements = new HashSet<String>();
        this.mProcessedDatatypes = new HashSet<String>();
    }

    private void readElementSettings(Attributes attrs) throws SAXException {
        String componentRoot;
        String commaSeparatedStyleFamilies;
        String sc;
        String nodeName = attrs.getValue("name");
        if (nodeName == null) {
            throw new SAXException("Invalid element line " + this.mLocator.getLineNumber());
        }
        if (this.mProcessedElements.contains(nodeName)) {
            throw new SAXException("Multiple definition of element in line " + this.mLocator.getLineNumber());
        }
        this.mProcessedElements.add(nodeName);
        String base = attrs.getValue("base");
        if (base != null && base.length() > 0) {
            this.mElementBaseNames.put(nodeName, base);
        }
        if ((sc = attrs.getValue("extends")) != null && sc.length() > 0) {
            this.mElementSuperClassNames.put(nodeName, sc);
        }
        if ((commaSeparatedStyleFamilies = attrs.getValue("family")) != null) {
            StringTokenizer tok = new StringTokenizer(commaSeparatedStyleFamilies, ",");
            ArrayList<String> families = new ArrayList<String>();
            while (tok.hasMoreElements()) {
                String family = tok.nextToken();
                if (family.length() <= 0) continue;
                families.add(family);
            }
            if (families.size() > 0) {
                this.mElementStyleFamilies.put(nodeName, families);
            }
        }
        if ((componentRoot = attrs.getValue("root-of-component")) != null && componentRoot.length() > 0) {
            this.mComponentRootElementNames.put(nodeName, componentRoot);
        }
    }

    private void readDatatypeSettings(Attributes attrs) throws SAXException {
        String attrName = attrs.getValue("name");
        if (attrName == null) {
            throw new SAXException("Invalid datatype line " + this.mLocator.getLineNumber());
        }
        if (this.mProcessedDatatypes.contains(attrName)) {
            throw new SAXException("Multiple definition of datatype in line " + this.mLocator.getLineNumber());
        }
        this.mProcessedDatatypes.add(attrName);
        String[] tuple = new String[]{attrs.getValue("value-type"), attrs.getValue("conversion-type")};
        this.mDatatypeValueConversion.put(attrName, tuple);
    }

    private void readAttributeSettings(Attributes attrs) throws SAXException {
        String attrName = attrs.getValue("name");
        if (attrName == null) {
            throw new SAXException("Invalid attribute line " + this.mLocator.getLineNumber());
        }
        String elementName = attrs.getValue("element");
        String defaultValue = attrs.getValue("defaultValue");
        Map defaultValueByParentElement = this.mAttributeDefaults.computeIfAbsent(attrName, k -> new HashMap());
        if (elementName == null) {
            elementName = ALL_ELEMENTS;
        }
        defaultValueByParentElement.put(elementName, defaultValue);
        String repetition = attrs.getValue("repetition");
        if (repetition != null && repetition.length() > 0 && Boolean.parseBoolean(repetition)) {
            this.mRepetitionAttributeNames.add(attrName);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("grammar-additions") && !this.inGrammarAdditions) {
            this.inGrammarAdditions = true;
            return;
        }
        if (qName.equals("elements") && this.inGrammarAdditions && !this.inElements) {
            this.inElements = true;
            return;
        }
        if (qName.equals("element") && this.inElements && !this.inElement) {
            this.inElement = true;
            this.readElementSettings(attributes);
            return;
        }
        if (qName.equals("attributes") && this.inGrammarAdditions && !this.inAttributes) {
            this.inAttributes = true;
            return;
        }
        if (qName.equals("attribute") && this.inAttributes && !this.inAttribute) {
            this.inAttribute = true;
            this.readAttributeSettings(attributes);
            return;
        }
        if (qName.equals("data-types") && this.inGrammarAdditions && !this.inDatatypes) {
            this.inDatatypes = true;
            return;
        }
        if (qName.equals("data") && this.inDatatypes && !this.inData) {
            this.inData = true;
            this.readDatatypeSettings(attributes);
            return;
        }
        throw new SAXException("Malformed grammar-additions.xml in line " + this.mLocator.getLineNumber());
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("grammar-additions") && this.inGrammarAdditions) {
            this.inGrammarAdditions = false;
            return;
        }
        if (qName.equals("elements") && this.inElements) {
            this.inElements = false;
            return;
        }
        if (qName.equals("element") && this.inElement) {
            this.inElement = false;
            return;
        }
        if (qName.equals("attributes") && this.inAttributes) {
            this.inAttributes = false;
            return;
        }
        if (qName.equals("attribute") && this.inAttribute) {
            this.inAttribute = false;
            return;
        }
        if (qName.equals("data-types") && this.inDatatypes) {
            this.inDatatypes = false;
            return;
        }
        if (qName.equals("data") && this.inData) {
            this.inData = false;
            return;
        }
        throw new SAXException("Malformed grammar-additions.xml in line " + this.mLocator.getLineNumber());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
    }

    public static void readGrammarAdditionsFile(File cf, Map<String, String> elementBaseNames, Map<String, String> elementSuperClassNamesNames, Map<String, String> componentRootElementNames, Set<String> repetitionAttributeNames, Map<String, Map<String, String>> attributeDefaults, Map<String, List<String>> elementNameToFamilyMap, Map<String, String[]> datatypeValueConversion) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(cf, (DefaultHandler)new GrammarAdditionsFileHandler(elementBaseNames, elementSuperClassNamesNames, componentRootElementNames, repetitionAttributeNames, attributeDefaults, elementNameToFamilyMap, datatypeValueConversion));
    }
}

