/*
 * Decompiled with CFR 0.152.
 */
package schema2template.grammar;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.NameClassVisitor;
import com.sun.msv.grammar.ReferenceExp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.logging.Logger;
import schema2template.grammar.MSVExpressionInformation;
import schema2template.grammar.MSVExpressionType;
import schema2template.grammar.MSVExpressionVisitorType;
import schema2template.grammar.MSVNameClassVisitorList;
import schema2template.grammar.PuzzlePiece;
import schema2template.grammar.XMLModel;

public class PathPrinter {
    private static final Logger LOG = Logger.getLogger(PathPrinter.class.getName());
    XMLModel xmlModel;

    public PathPrinter(XMLModel xmlModel) {
        this.xmlModel = xmlModel;
    }

    public List<String> printChildPaths(String parentElementName, String childElementName) {
        SortedSet<PuzzlePiece> pieces = this.xmlModel.getElements(parentElementName);
        if (pieces == null) {
            LOG.severe("No parent element found by the given name: " + parentElementName);
            return null;
        }
        if (pieces.size() > 1) {
            LOG.severe("There were more than one element by the parent name '" + parentElementName + "'. Dropped all instances but one.");
        }
        PuzzlePiece parent = pieces.first();
        pieces = this.xmlModel.getElements(childElementName);
        if (pieces == null) {
            LOG.severe("No child element found by the given name: " + childElementName);
            return null;
        }
        if (pieces.size() > 1) {
            LOG.severe("There were more than one element by the child name '" + childElementName + "'. Dropped all instances but one.");
        }
        PuzzlePiece child = pieces.first();
        return this.printChildPaths(parent, child);
    }

    public List<String> printChildPaths(PuzzlePiece parent, PuzzlePiece child) {
        MSVExpressionInformation info = new MSVExpressionInformation(parent.getExpression(), null);
        List<List<Expression>> paths = info.getPathsContaining(Objects.requireNonNullElse(child, parent).getExpression());
        if (paths == null) {
            return null;
        }
        return PathPrinter.printChildPaths(paths);
    }

    public static List<String> printChildPaths(List<List<Expression>> paths) {
        MSVExpressionVisitorType typeVisitor = new MSVExpressionVisitorType();
        MSVNameClassVisitorList nameVisitor = new MSVNameClassVisitorList();
        ArrayList<String> retval = new ArrayList<String>(paths.size());
        for (List<Expression> path : paths) {
            boolean first = true;
            Object wayString = "";
            for (Expression step : path) {
                List names;
                MSVExpressionType type = (MSVExpressionType)((Object)step.visit((ExpressionVisitor)typeVisitor));
                if (type == MSVExpressionType.REF) {
                    wayString = ((String)wayString).concat(" -> REF " + ((ReferenceExp)step).name);
                    continue;
                }
                Object name = type.toString();
                Object qname = "";
                if (step instanceof NameClassAndExpression && (names = (List)((NameClassAndExpression)step).getNameClass().visit((NameClassVisitor)nameVisitor)) != null) {
                    boolean firstQ = true;
                    for (String singleQ : names) {
                        if (firstQ) {
                            firstQ = false;
                            qname = singleQ;
                            continue;
                        }
                        qname = (String)qname + "," + singleQ;
                    }
                }
                if (first) {
                    first = false;
                    wayString = (String)name + " " + (String)qname;
                    continue;
                }
                if (step instanceof NameClassAndExpression) {
                    name = (String)name + " " + (String)qname;
                }
                wayString = ((String)wayString).concat(" -> " + (String)name);
            }
            retval.add((String)wayString);
        }
        return retval;
    }
}

