/*
 * Decompiled with CFR 0.152.
 */
package schema2template.grammar;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.util.ExpressionWalker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import schema2template.grammar.PuzzlePiece;

class OdfFamilyPropertiesPatternMatcher {
    private final Grammar mGrammar;
    final Set<Expression> elementNodes = new HashSet<Expression>();
    final Set<Expression> refNodes = new HashSet<Expression>();
    final Set<Expression> elementHeads = new HashSet<Expression>();
    final Set<Expression> refHeads = new HashSet<Expression>();
    private Map<String, List<String>> propertiesByFamily = null;
    Boolean collectingState = Boolean.FALSE;
    Integer depthCollecting = null;

    public OdfFamilyPropertiesPatternMatcher(Grammar g) {
        this.mGrammar = g;
    }

    public Map<String, List<String>> getFamilyProperties() {
        if (this.propertiesByFamily == null) {
            this.initialize();
        }
        return this.propertiesByFamily;
    }

    private void initialize() {
        this.propertiesByFamily = new TreeMap<String, List<String>>();
        this.mGrammar.getTopLevel().visit((ExpressionVisitorVoid)new ExpressionWalker(){
            int depth = 1;
            List resultList = null;

            public void onElement(ElementExp exp) {
                if (OdfFamilyPropertiesPatternMatcher.this.elementNodes.contains(exp)) {
                    OdfFamilyPropertiesPatternMatcher.this.elementHeads.add((Expression)exp);
                    this.evaluatePattern(exp);
                    return;
                }
                this.evaluatePattern(exp);
                OdfFamilyPropertiesPatternMatcher.this.elementNodes.add((Expression)exp);
                ++this.depth;
                super.onElement(exp);
                --this.depth;
            }

            public void onAttribute(AttributeExp exp) {
                String attrName = PuzzlePiece.getName((NameClassAndExpression)exp);
                if (attrName.equals("style:family")) {
                    OdfFamilyPropertiesPatternMatcher.this.collectingState = Boolean.TRUE;
                    OdfFamilyPropertiesPatternMatcher.this.depthCollecting = this.depth;
                    this.resultList = new ArrayList();
                    if (exp.exp instanceof ValueExp) {
                        OdfFamilyPropertiesPatternMatcher.this.propertiesByFamily.put(((ValueExp)exp.exp).value.toString(), this.resultList);
                    } else if (exp.exp instanceof ChoiceExp) {
                        OdfFamilyPropertiesPatternMatcher.this.propertiesByFamily.put(((ValueExp)((ChoiceExp)exp.exp).exp1).value.toString(), this.resultList);
                        OdfFamilyPropertiesPatternMatcher.this.propertiesByFamily.put(((ValueExp)((ChoiceExp)exp.exp).exp2).value.toString(), this.resultList);
                    }
                }
                super.onAttribute(exp);
            }

            public void onRef(ReferenceExp exp) {
                if (OdfFamilyPropertiesPatternMatcher.this.refNodes.contains(exp)) {
                    if (OdfFamilyPropertiesPatternMatcher.this.refHeads.contains(exp)) {
                        return;
                    }
                    OdfFamilyPropertiesPatternMatcher.this.refHeads.add((Expression)exp);
                }
                OdfFamilyPropertiesPatternMatcher.this.elementNodes.add((Expression)exp);
                super.onRef(exp);
                if (OdfFamilyPropertiesPatternMatcher.this.refHeads.contains(exp)) {
                    OdfFamilyPropertiesPatternMatcher.this.refHeads.remove(exp);
                } else if (OdfFamilyPropertiesPatternMatcher.this.refNodes.contains(exp)) {
                    OdfFamilyPropertiesPatternMatcher.this.refNodes.remove(exp);
                }
            }

            public void endCollectingState() {
                OdfFamilyPropertiesPatternMatcher.this.collectingState = Boolean.FALSE;
            }

            private void evaluatePattern(ElementExp exp) {
                if (exp.getNameClass() instanceof SimpleNameClass) {
                    String elementName = ((SimpleNameClass)exp.getNameClass()).localName;
                    if (elementName != null && OdfFamilyPropertiesPatternMatcher.this.collectingState.booleanValue() && elementName.endsWith("properties")) {
                        this.resultList.add(elementName);
                    } else if (OdfFamilyPropertiesPatternMatcher.this.collectingState.booleanValue() && OdfFamilyPropertiesPatternMatcher.this.depthCollecting >= this.depth) {
                        this.endCollectingState();
                    }
                } else if (OdfFamilyPropertiesPatternMatcher.this.collectingState.booleanValue()) {
                    this.endCollectingState();
                }
            }
        });
    }

    public String toString() {
        Map<String, List<String>> results = this.getFamilyProperties();
        Set<String> families = results.keySet();
        StringBuilder sb = new StringBuilder();
        for (String family : families) {
            sb.append("@style:family = '").append(family).append("' =");
            List<String> propNames = results.get(family);
            for (String propName : propNames) {
                sb.append(" style:").append(propName);
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

