/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.util;

import java.util.Map;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.AttributeController;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.api.factory.Factory;
import org.objectweb.fractal.api.factory.GenericFactory;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.TypeFactory;

public class Fractal {
    private Fractal() {
    }

    public static Component getBootstrapComponent() throws InstantiationException {
        return org.objectweb.fractal.api.Fractal.getBootstrapComponent();
    }

    public static Component getBootstrapComponent(Map hints) throws InstantiationException {
        Object bootTmpl;
        String bootTmplClassName = (String)hints.get("fractal.provider");
        if (bootTmplClassName == null) {
            bootTmplClassName = System.getProperty("fractal.provider");
        }
        if (bootTmplClassName == null) {
            throw new InstantiationException("The fractal.provider value is not defined");
        }
        try {
            ClassLoader cl = (ClassLoader)hints.get("classloader");
            if (cl == null) {
                cl = new Fractal().getClass().getClassLoader();
            }
            Class<?> bootTmplClass = cl.loadClass(bootTmplClassName);
            bootTmpl = bootTmplClass.newInstance();
        }
        catch (Exception e) {
            throw new InstantiationException("Cannot find or instantiate the '" + bootTmplClassName + "' class associated to the fractal.provider key");
        }
        if (bootTmpl instanceof GenericFactory) {
            return ((GenericFactory)bootTmpl).newFcInstance(null, null, hints);
        }
        return ((Factory)bootTmpl).newFcInstance();
    }

    public static AttributeController getAttributeController(Component component) throws NoSuchInterfaceException {
        return (AttributeController)component.getFcInterface("attribute-controller");
    }

    public static BindingController getBindingController(Component component) throws NoSuchInterfaceException {
        return (BindingController)component.getFcInterface("binding-controller");
    }

    public static ContentController getContentController(Component component) throws NoSuchInterfaceException {
        return (ContentController)component.getFcInterface("content-controller");
    }

    public static SuperController getSuperController(Component component) throws NoSuchInterfaceException {
        return (SuperController)component.getFcInterface("super-controller");
    }

    public static NameController getNameController(Component component) throws NoSuchInterfaceException {
        return (NameController)component.getFcInterface("name-controller");
    }

    public static LifeCycleController getLifeCycleController(Component component) throws NoSuchInterfaceException {
        return (LifeCycleController)component.getFcInterface("lifecycle-controller");
    }

    public static Factory getFactory(Component component) throws NoSuchInterfaceException {
        return (Factory)component.getFcInterface("factory");
    }

    public static GenericFactory getGenericFactory(Component component) throws NoSuchInterfaceException {
        return (GenericFactory)component.getFcInterface("generic-factory");
    }

    public static TypeFactory getTypeFactory(Component component) throws NoSuchInterfaceException {
        return (TypeFactory)component.getFcInterface("type-factory");
    }
}

