/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.noear.eggg.MethodEggg;
import org.noear.eggg.ParamEggg;
import org.noear.eggg.TypeEggg;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Around;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.InterceptorEntity;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.aspect.MethodInterceptor;
import org.noear.solon.core.wrap.MethodHolder;
import org.noear.solon.core.wrap.ParamWrap;

public class MethodWrap
implements MethodInterceptor,
MethodHolder {
    private final AppContext context;
    private final Class<?> ownerClz;
    private final Class<?> declaringClz;
    private final MethodEggg methodEggg;
    private final Parameter[] parameters;
    private final Annotation[] annotations;
    private final List<InterceptorEntity> interceptors;
    private final Set<Interceptor> interceptorsIdx;
    private ParamWrap[] __paramWraps;

    public MethodWrap(AppContext ctx, Class<?> clz, MethodEggg m) {
        this.context = ctx;
        this.ownerClz = clz;
        this.declaringClz = m.getMethod().getDeclaringClass();
        this.methodEggg = m;
        this.parameters = m.getParameters();
        this.annotations = m.getAnnotations();
        this.interceptors = new ArrayList<InterceptorEntity>();
        this.interceptorsIdx = new HashSet<Interceptor>();
        if (this.context != null) {
            InterceptorEntity ie;
            for (Annotation anno : this.annotations) {
                if (anno instanceof Around) {
                    this.doInterceptorAdd((Around)anno);
                    continue;
                }
                ie = this.context.beanInterceptorGet(anno.annotationType());
                if (ie != null) {
                    this.doInterceptorAdd(ie);
                    continue;
                }
                this.doInterceptorAdd(anno.annotationType().getAnnotation(Around.class));
            }
            for (Annotation anno : this.ownerClz.getAnnotations()) {
                if (anno instanceof Around) {
                    this.doInterceptorAdd((Around)anno);
                    continue;
                }
                ie = this.context.beanInterceptorGet(anno.annotationType());
                if (ie != null) {
                    this.doInterceptorAdd(ie);
                    continue;
                }
                this.doInterceptorAdd(anno.annotationType().getAnnotation(Around.class));
            }
        }
        if (this.interceptors.size() > 1) {
            this.interceptors.sort(Comparator.comparing(x -> x.getIndex()));
        }
        this.interceptors.add(new InterceptorEntity(0, this));
    }

    public MethodEggg getMethodEggg() {
        return this.methodEggg;
    }

    public ParamWrap[] paramWraps() {
        if (this.__paramWraps == null) {
            this.__paramWraps = this.buildParamWraps();
        }
        return this.__paramWraps;
    }

    private ParamWrap[] buildParamWraps() {
        ParamWrap[] tmp = new ParamWrap[this.methodEggg.getParamCount()];
        int len = this.methodEggg.getParamCount();
        for (int i = 0; i < len; ++i) {
            tmp[i] = new ParamWrap((ParamEggg)this.methodEggg.getParamEgggAry().get(i));
        }
        return tmp;
    }

    public MethodWrap ofHandler() {
        for (ParamWrap pw : this.getParamWraps()) {
            pw.spec();
        }
        return this;
    }

    private void doInterceptorAdd(Around a) {
        if (a != null) {
            this.doInterceptorAdd(new InterceptorEntity(a.index(), this.context.getBeanOrNew(a.value())));
        }
    }

    private void doInterceptorAdd(InterceptorEntity i) {
        if (i != null) {
            if (this.interceptorsIdx.contains(i.getReal())) {
                return;
            }
            this.interceptorsIdx.add(i.getReal());
            this.interceptors.add(i);
        }
    }

    public String getName() {
        return this.methodEggg.getName();
    }

    @Override
    public Class<?> getOwnerClz() {
        return this.ownerClz;
    }

    @Override
    public Class<?> getDeclaringClz() {
        return this.declaringClz;
    }

    @Override
    public Method getMethod() {
        return this.methodEggg.getMethod();
    }

    @Override
    public TypeEggg getReturnTypeEggg() {
        return this.methodEggg.getReturnTypeEggg();
    }

    @Override
    public Class<?> getReturnType() {
        return this.methodEggg.getReturnTypeEggg().getType();
    }

    @Override
    public Type getGenericReturnType() {
        return this.methodEggg.getReturnTypeEggg().getGenericType();
    }

    @Override
    public ParamWrap[] getParamWraps() {
        return this.paramWraps();
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return this.methodEggg.getMethod().getAnnotation(type);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.methodEggg.getMethod().isAnnotationPresent(annotationClass);
    }

    @Override
    public List<InterceptorEntity> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    @Override
    public Object doIntercept(Invocation inv) throws Throwable {
        return this.invoke(inv.target(), inv.args());
    }

    public Object invoke(Object obj, Object[] args) throws Throwable {
        try {
            return this.methodEggg.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getTargetException();
            throw Utils.throwableUnwrap(e2);
        }
    }

    public Object invokeByAspect(Object obj, Object[] args) throws Throwable {
        Invocation inv = new Invocation(this.context, obj, args, this, this.interceptors);
        return inv.invoke();
    }
}

