/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.annotation.Inject;

public class IndexBuilder {
    private static Map<String, Integer> map = new HashMap<String, Integer>();
    private static ArrayList<String> classStack = new ArrayList();

    public static int buildIndex(Class<?> clazz) {
        return IndexBuilder.buildIndex(clazz, true);
    }

    private static int buildIndex(Class<?> clazz, Boolean stackTop) {
        if (stackTop.booleanValue()) {
            classStack.clear();
            if (IndexBuilder.isLoopRelate(clazz, clazz.getName())) {
                String link = "";
                for (int i = 0; i < classStack.size(); ++i) {
                    link = link + classStack.get(i);
                    if (i == classStack.size() - 1) continue;
                    link = link + " -> ";
                }
                throw new RuntimeException("Dependency loops are not supported: " + link);
            }
        }
        if (map.get(clazz.getName()) != null) {
            return map.get(clazz.getName());
        }
        List<Class<?>> clazzList = IndexBuilder.findRelateClass(clazz);
        if (clazzList.size() == 0) {
            map.put(clazz.getName(), 0);
            return 0;
        }
        Integer maxIndex = null;
        for (Class<?> clazzRelate : clazzList) {
            Integer index = IndexBuilder.buildIndex(clazzRelate, false);
            if (maxIndex == null) {
                maxIndex = index;
                continue;
            }
            if (maxIndex >= index) continue;
            maxIndex = index;
        }
        map.put(clazz.getName(), maxIndex + 1);
        return maxIndex + 1;
    }

    private static List<Class<?>> findRelateClass(Class<?> clazz) {
        Field[] fields;
        ArrayList clazzList = new ArrayList();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Inject inject;
            if (!field.isAnnotationPresent(Inject.class) || (inject = field.getAnnotation(Inject.class)).value().contains("${")) continue;
            clazzList.add(field.getType());
        }
        return clazzList;
    }

    private static boolean isLoopRelate(Class<?> clazz, String topName) {
        classStack.add(clazz.getName());
        List<Class<?>> clazzList = IndexBuilder.findRelateClass(clazz);
        for (Class<?> clazzRelate : clazzList) {
            if (!clazzRelate.getName().equals(topName)) continue;
            classStack.add(clazzRelate.getName());
            return true;
        }
        for (Class<?> clazzRelate : clazzList) {
            if (!IndexBuilder.isLoopRelate(clazzRelate, topName)) continue;
            return true;
        }
        classStack.remove(clazz.getName());
        return false;
    }
}

