/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.core.XClassLoader;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XPropertiesLoader;
import org.noear.solon.core.util.PathAnalyzer;
import org.noear.solon.core.wrap.ClassWrap;

public class XUtil {
    public static final ExecutorService commonPool = Executors.newCachedThreadPool();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Pattern _pkr = Pattern.compile("\\{([^\\\\}]+)\\}");

    public static String guid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String md5(String str) {
        try {
            byte[] btInput = str.getBytes("UTF-8");
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] chars = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                chars[k++] = HEX_DIGITS[byte0 >>> 4 & 0xF];
                chars[k++] = HEX_DIGITS[byte0 & 0xF];
            }
            return new String(chars);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static RuntimeException throwableWrap(Throwable ex) {
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new RuntimeException(ex);
    }

    public static Throwable throwableUnwrap(Throwable ex) {
        Throwable th = ex;
        while (th instanceof RuntimeException && th.getCause() != null) {
            th = th.getCause();
        }
        while (th instanceof InvocationTargetException) {
            th = ((InvocationTargetException)th).getTargetException();
        }
        return th;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return !XUtil.isEmpty(s);
    }

    public static boolean isBlank(String s) {
        if (XUtil.isEmpty(s)) {
            return true;
        }
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            if (XUtil.isWhitespace(s.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13;
    }

    public static <T> T firstOrNull(List<T> list) {
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static Class<?> loadClass(String className) {
        try {
            return XClassLoader.global().loadClass(className);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <T> T newInstance(String className) {
        try {
            Class<?> clz = XUtil.loadClass(className);
            if (clz == null) {
                return null;
            }
            return (T)clz.newInstance();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Enumeration<URL> getResources(String name) throws IOException {
        return XClassLoader.global().getResources(name);
    }

    public static URL getResource(String name) {
        return XClassLoader.global().getResource(name);
    }

    public static String getResourceAsString(String name, String charset) throws IOException {
        URL url = XUtil.getResource(name);
        if (url != null) {
            return XUtil.getString(url.openStream(), charset);
        }
        return null;
    }

    public static String getString(InputStream ins, String charset) throws IOException {
        if (ins == null) {
            return null;
        }
        ByteArrayOutputStream outs = new ByteArrayOutputStream();
        int len = 0;
        byte[] buf = new byte[512];
        while ((len = ins.read(buf)) != -1) {
            outs.write(buf, 0, len);
        }
        if (charset == null) {
            return outs.toString();
        }
        return outs.toString(charset);
    }

    public static Properties loadProperties(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return XPropertiesLoader.global().load(url);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Properties buildProperties(String txt) {
        try {
            return XPropertiesLoader.global().build(txt);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T injectProperties(T bean, Properties propS) {
        ClassWrap.get(bean.getClass()).fill(bean, propS::getProperty, null);
        return bean;
    }

    public static String getFullStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.getBuffer().toString();
    }

    public static String mergePath(String path1, String path2) {
        if (XUtil.isEmpty(path1) || "**".equals(path1)) {
            if (path2.startsWith("/")) {
                return path2;
            }
            return "/" + path2;
        }
        if (!path1.startsWith("/")) {
            path1 = "/" + path1;
        }
        if (XUtil.isEmpty(path2)) {
            return path1;
        }
        if (path2.startsWith("/")) {
            path2 = path2.substring(1);
        }
        if (path1.endsWith("/")) {
            return path1 + path2;
        }
        if (path1.endsWith("*")) {
            int idx = path1.lastIndexOf(47) + 1;
            if (idx < 1) {
                return path2;
            }
            return path1.substring(0, idx) + path2;
        }
        return path1 + "/" + path2;
    }

    public static XMap pathVarMap(String path, String expr) {
        XMap _map = new XMap();
        if (expr.indexOf("{") >= 0) {
            PathAnalyzer _pr;
            String path2 = null;
            try {
                path2 = URLDecoder.decode(path, "utf-8");
            }
            catch (Throwable ex) {
                path2 = path;
            }
            Matcher pm = _pkr.matcher(expr);
            ArrayList<String> _pks = new ArrayList<String>();
            while (pm.find()) {
                _pks.add(pm.group(1));
            }
            if (_pks.size() > 0 && (pm = (_pr = new PathAnalyzer(expr)).matcher(path2)).find()) {
                int len = _pks.size();
                for (int i = 0; i < len; ++i) {
                    _map.put((String)_pks.get(i), pm.group(i + 1));
                }
            }
        }
        return _map;
    }

    public static String buildExt(String extend, boolean autoMake) {
        int idx;
        if (extend == null) {
            return null;
        }
        if (extend.contains("/")) {
            return extend;
        }
        URL temp = XUtil.getResource("");
        if (temp == null) {
            return null;
        }
        String uri = temp.toString();
        if (uri.startsWith("file:/")) {
            idx = uri.lastIndexOf("/target/");
            idx = idx > 0 ? (idx += 8) : uri.lastIndexOf("/", idx) + 1;
            uri = uri.substring(5, idx);
        } else {
            idx = uri.indexOf("jar!/");
            idx = uri.lastIndexOf("/", idx) + 1;
            uri = uri.substring(9, idx);
        }
        uri = uri + extend + "/";
        File dir = new File(uri);
        if (!dir.exists()) {
            if (autoMake) {
                dir.mkdir();
            } else {
                return null;
            }
        }
        return uri;
    }

    public static void bindTo(Map<String, String> source, Object target) {
        XUtil.bindTo((String k) -> (String)source.get(k), target);
    }

    public static void bindTo(Properties source, Object target) {
        XUtil.bindTo((String k) -> source.getProperty((String)k), target);
    }

    public static void bindTo(Function<String, String> source, Object target) {
        if (target == null) {
            return;
        }
        ClassWrap.get(target.getClass()).fill(target, source, null);
    }
}

