/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.prop;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import org.noear.solon.Utils;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.prop.JsonProps;

public class JsonPropsUtil {
    public static boolean apply(JsonRenderFactory factory, JsonProps jsonProps) {
        if (jsonProps == null) {
            return false;
        }
        if (Utils.isNotEmpty((String)jsonProps.dateAsFormat)) {
            factory.addConvertor(Date.class, e -> {
                SimpleDateFormat df = new SimpleDateFormat(jsonProps.dateAsFormat);
                if (Utils.isNotEmpty((String)jsonProps.dateAsTimeZone)) {
                    df.setTimeZone(TimeZone.getTimeZone(ZoneId.of(jsonProps.dateAsTimeZone)));
                }
                return df.format((Date)e);
            });
            factory.addConvertor(ZonedDateTime.class, e -> {
                DateTimeFormatter df = DateTimeFormatter.ofPattern(jsonProps.dateAsFormat);
                if (Utils.isNotEmpty((String)jsonProps.dateAsTimeZone)) {
                    df.withZone(ZoneId.of(jsonProps.dateAsTimeZone));
                }
                return e.format(df);
            });
            factory.addConvertor(LocalDateTime.class, e -> {
                DateTimeFormatter df = DateTimeFormatter.ofPattern(jsonProps.dateAsFormat);
                if (Utils.isNotEmpty((String)jsonProps.dateAsTimeZone)) {
                    df.withZone(ZoneId.of(jsonProps.dateAsTimeZone));
                }
                return e.format(df);
            });
            factory.addConvertor(LocalDate.class, e -> {
                DateTimeFormatter df = DateTimeFormatter.ofPattern(jsonProps.dateAsFormat);
                if (Utils.isNotEmpty((String)jsonProps.dateAsTimeZone)) {
                    df.withZone(ZoneId.of(jsonProps.dateAsTimeZone));
                }
                return e.format(df);
            });
        }
        if (jsonProps.dateAsTicks) {
            factory.addConvertor(Date.class, Date::getTime);
        }
        if (jsonProps.longAsString) {
            factory.addConvertor(Long.class, String::valueOf);
            factory.addConvertor(Long.TYPE, String::valueOf);
        }
        if (jsonProps.boolAsInt) {
            factory.addConvertor(Boolean.class, e -> e != false ? 1 : 0);
        }
        return true;
    }
}

