/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fury;

import io.fury.Fury;
import io.fury.ThreadLocalFury;
import io.fury.ThreadSafeFury;
import io.fury.config.Language;
import io.fury.resolver.AllowListChecker;
import io.fury.resolver.ClassChecker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.stream.Collectors;
import org.noear.solon.core.util.ResourceUtil;

public class FuryUtil {
    private static final String BLACKLIST_TXT_PATH = "META-INF/solon/furyBlackList.txt";
    public static Set<String> DEFAULT_BLACKLIST_SET;
    public static final ThreadSafeFury fury;

    private static ThreadSafeFury getFurySerializer() {
        FuryUtil.loadBlackList();
        return new ThreadLocalFury(classLoader -> {
            Fury f = Fury.builder().withAsyncCompilation(true).withLanguage(Language.JAVA).withRefTracking(true).requireClassRegistration(false).build();
            AllowListChecker blackListChecker = new AllowListChecker(AllowListChecker.CheckLevel.WARN);
            Set<String> blackList = DEFAULT_BLACKLIST_SET;
            f.getClassResolver().setClassChecker((ClassChecker)blackListChecker);
            blackListChecker.addListener(f.getClassResolver());
            for (String key : blackList) {
                blackListChecker.disallowClass(key + "*");
            }
            return f;
        });
    }

    private static void loadBlackList() {
        block15: {
            try (InputStream is = ResourceUtil.getResourceAsStream((String)BLACKLIST_TXT_PATH);){
                if (is != null) {
                    DEFAULT_BLACKLIST_SET = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.toSet());
                    break block15;
                }
                throw new IllegalStateException(String.format("Read blacklist %s failed", BLACKLIST_TXT_PATH));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Read blacklist %s failed", BLACKLIST_TXT_PATH), e);
            }
        }
    }

    static {
        fury = FuryUtil.getFurySerializer();
    }
}

