/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.serialization.ActionSerializer;

public class FastjsonStringSerializer
implements ActionSerializer<String> {
    private SerializeConfig serializeConfig;
    private int serializerFeatures = JSON.DEFAULT_GENERATE_FEATURE;
    private ParserConfig deserializeConfig;
    private int deserializeFeatures = JSON.DEFAULT_PARSER_FEATURE;

    public SerializeConfig getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new SerializeConfig();
        }
        return this.serializeConfig;
    }

    public void cfgSerializerFeatures(boolean isReset, boolean isAdd, SerializerFeature ... features) {
        if (isReset) {
            this.serializerFeatures = JSON.DEFAULT_GENERATE_FEATURE;
        }
        for (SerializerFeature feature : features) {
            if (isAdd) {
                this.serializerFeatures |= feature.getMask();
                continue;
            }
            this.serializerFeatures &= ~feature.getMask();
        }
    }

    public ParserConfig getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new ParserConfig();
        }
        return this.deserializeConfig;
    }

    public void cfgDeserializeFeatures(boolean isReset, boolean isAdd, Feature ... features) {
        if (isReset) {
            this.deserializeFeatures = JSON.DEFAULT_GENERATE_FEATURE;
        }
        for (Feature feature : features) {
            if (isAdd) {
                this.deserializeFeatures |= feature.getMask();
                continue;
            }
            this.deserializeFeatures &= ~feature.getMask();
        }
    }

    public String name() {
        return "fastjson-json";
    }

    public String serialize(Object obj) throws IOException {
        if (this.serializeConfig == null) {
            return JSON.toJSONString((Object)obj, (int)this.serializerFeatures, (SerializerFeature[])new SerializerFeature[0]);
        }
        return JSON.toJSONString((Object)obj, (SerializeConfig)this.serializeConfig, (SerializeFilter[])new SerializeFilter[0], null, (int)this.serializerFeatures, (SerializerFeature[])new SerializerFeature[0]);
    }

    public Object deserialize(String data, Class<?> clz) throws IOException {
        if (clz == null) {
            if (this.deserializeConfig == null) {
                return JSON.parse((String)data, (int)this.deserializeFeatures);
            }
            return JSON.parse((String)data, (ParserConfig)this.deserializeConfig, (int)this.deserializeFeatures);
        }
        if (this.deserializeConfig == null) {
            return JSON.parseObject((String)data, clz, (int)this.deserializeFeatures, (Feature[])new Feature[0]);
        }
        return JSON.parseObject((String)data, clz, (ParserConfig)this.deserializeConfig, (int)this.deserializeFeatures, (Feature[])new Feature[0]);
    }

    public Object deserializeBody(Context ctx) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            if (this.deserializeConfig == null) {
                return JSON.parse((String)data, (int)this.deserializeFeatures);
            }
            return JSON.parse((String)data, (ParserConfig)this.deserializeConfig, (int)this.deserializeFeatures);
        }
        return null;
    }
}

