/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.serializer.SerializerFeature;
import org.noear.solon.Solon;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.fastjson.FastjsonActionExecutor;
import org.noear.solon.serialization.fastjson.FastjsonRenderFactory;
import org.noear.solon.serialization.fastjson.FastjsonRenderTypedFactory;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;

public class XPluginImp
implements Plugin {
    public void start(AopContext context) {
        JsonProps jsonProps = JsonProps.create((AopContext)context);
        FastjsonRenderFactory renderFactory = new FastjsonRenderFactory();
        this.applyProps(renderFactory, jsonProps);
        context.wrapAndPut(FastjsonRenderFactory.class, (Object)renderFactory);
        EventBus.publish((Object)renderFactory);
        FastjsonRenderTypedFactory renderTypedFactory = new FastjsonRenderTypedFactory();
        context.wrapAndPut(FastjsonRenderTypedFactory.class, (Object)renderTypedFactory);
        context.lifecycle(-99, () -> {
            RenderManager.mapping((String)"@json", (Render)renderFactory.create());
            RenderManager.mapping((String)"@type_json", (Render)renderTypedFactory.create());
        });
        FastjsonActionExecutor actionExecutor = new FastjsonActionExecutor();
        context.wrapAndPut(FastjsonActionExecutor.class, (Object)actionExecutor);
        EventBus.publish((Object)((Object)actionExecutor));
        Solon.app().chainManager().addExecuteHandler((ActionExecuteHandler)actionExecutor);
    }

    private void applyProps(FastjsonRenderFactory factory, JsonProps jsonProps) {
        if (JsonPropsUtil.apply((JsonRenderFactory)factory, (JsonProps)jsonProps)) {
            if (jsonProps.nullStringAsEmpty) {
                factory.addFeatures(SerializerFeature.WriteNullStringAsEmpty);
            }
            if (jsonProps.nullBoolAsFalse) {
                factory.addFeatures(SerializerFeature.WriteNullBooleanAsFalse);
            }
            if (jsonProps.nullNumberAsZero) {
                factory.addFeatures(SerializerFeature.WriteNullNumberAsZero);
            }
            if (jsonProps.nullArrayAsEmpty) {
                factory.addFeatures(SerializerFeature.WriteNullListAsEmpty);
            }
            if (jsonProps.nullAsWriteable) {
                factory.addFeatures(SerializerFeature.WriteMapNullValue);
            }
            if (jsonProps.enumAsName) {
                factory.addFeatures(SerializerFeature.WriteEnumUsingName);
            }
        }
    }
}

