/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.simple;

import java.util.Date;
import java.util.TimeZone;
import org.noear.solon.Utils;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.scheduling.scheduled.JobHolder;
import org.noear.solon.scheduling.simple.cron.CronExpressionPlus;
import org.noear.solon.scheduling.simple.cron.CronUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleScheduler
implements Lifecycle {
    static final Logger log = LoggerFactory.getLogger(SimpleScheduler.class);
    private JobHolder jobHolder;
    private CronExpressionPlus cron;
    private long sleepMillis;
    private Date baseTime;
    private Date nextTime;
    private Thread thread;
    boolean isStarted = false;

    public SimpleScheduler(JobHolder jobHolder) {
        this.jobHolder = jobHolder;
        if (Utils.isNotEmpty((String)jobHolder.getScheduled().cron())) {
            this.cron = CronUtils.get(jobHolder.getScheduled().cron());
            if (Utils.isNotEmpty((String)jobHolder.getScheduled().zone())) {
                this.cron.setTimeZone(TimeZone.getTimeZone(jobHolder.getScheduled().zone()));
            }
        }
        this.thread = new Thread(this::run);
        if (Utils.isNotEmpty((String)jobHolder.getName())) {
            this.thread.setName("Job:" + jobHolder.getName());
        }
    }

    public void start() throws Throwable {
        if (!this.isStarted) {
            this.thread.start();
            this.isStarted = true;
        }
    }

    public void stop() throws Throwable {
        if (this.isStarted) {
            this.isStarted = false;
        }
    }

    private void run() {
        if (this.baseTime == null) {
            this.baseTime = new Date();
        }
        if ((this.jobHolder.getScheduled().fixedDelay() > 0L || this.jobHolder.getScheduled().fixedRate() > 0L) && this.jobHolder.getScheduled().initialDelay() > 0L) {
            this.sleep0(this.jobHolder.getScheduled().initialDelay());
        }
        while (this.isStarted) {
            try {
                this.scheduling();
            }
            catch (Throwable e) {
                e = Utils.throwableUnwrap((Throwable)e);
                log.warn(e.getMessage(), e);
            }
        }
    }

    private void scheduling() throws Throwable {
        if (this.jobHolder.getScheduled().fixedDelay() > 0L) {
            this.exec0();
            this.sleep0(this.jobHolder.getScheduled().fixedDelay());
        } else if (this.jobHolder.getScheduled().fixedRate() > 0L) {
            this.sleepMillis = System.currentTimeMillis() - this.baseTime.getTime();
            if (this.sleepMillis >= this.jobHolder.getScheduled().fixedRate()) {
                this.baseTime = new Date();
                this.execAsParallel();
                this.sleepMillis = this.jobHolder.getScheduled().fixedRate();
            } else {
                this.sleepMillis = 100L;
            }
            this.sleep0(this.sleepMillis);
        } else {
            this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
            this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
            if (this.sleepMillis >= 0L) {
                this.baseTime = this.nextTime;
                this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
                if (this.sleepMillis <= 1000L) {
                    this.execAsParallel();
                    this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
                }
            }
            this.sleep0(this.sleepMillis);
        }
    }

    private void execAsParallel() {
        RunUtil.parallel(this::exec0);
    }

    private void exec0() {
        try {
            this.jobHolder.handle(null);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    private void sleep0(long millis) {
        if (millis < 0L) {
            millis = 100L;
        }
        try {
            Thread.sleep(millis);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }
}

