/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.solon.integration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.solon.SolonAppender;
import ch.qos.logback.solon.SolonTagsConverter;
import ch.qos.logback.solon.integration.LogbackConfigurator;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.noear.solon.Solon;

public class DefaultLogbackConfiguration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(LogbackConfigurator config) {
        Object object = config.getConfigurationLock();
        synchronized (object) {
            this.prepare(config);
            boolean fileEnable = Solon.cfg().getBool("solon.logging.appender.file.enable", true);
            boolean consoleEnable = Solon.cfg().getBool("solon.logging.appender.console.enable", true);
            ArrayList<Appender<ILoggingEvent>> appenderList = new ArrayList<Appender<ILoggingEvent>>();
            if (fileEnable) {
                Appender<ILoggingEvent> fileAppender = this.fileAppender(config);
                appenderList.add(fileAppender);
            }
            if (consoleEnable) {
                Appender<ILoggingEvent> consoleAppender = this.consoleAppender(config);
                appenderList.add(consoleAppender);
            }
            Appender<ILoggingEvent> solonAppender = this.solonAppender(config);
            appenderList.add(solonAppender);
            Appender[] appenderAry = new Appender[appenderList.size()];
            Level rootLevel = Level.toLevel((String)this.resolve(config, "${LOGGER_ROOT_LEVEL}"));
            config.root(rootLevel, appenderList.toArray(appenderAry));
        }
    }

    private void prepare(LogbackConfigurator config) {
        config.conversionRule("tags", SolonTagsConverter.class);
        this.putProperty(config, "APP_NAME", "solon.app.name", "solon");
        this.putProperty(config, "CONSOLE_LOG_PATTERN", "solon.logging.appender.console.pattern", "%highlight(%-5level %d{yyyy-MM-dd HH:mm:ss.SSS} [-%t][*%X{traceId}]%tags[%logger{20}]:) %n%msg%n");
        this.putProperty(config, "CONSOLE_LOG_LEVEL", "solon.logging.appender.console.level", "TRACE");
        this.putProperty(config, "FILE_LOG_EXTENSION", "solon.logging.appender.file.extension", ".log");
        this.putProperty(config, "FILE_LOG_NAME", "solon.logging.appender.file.name", "logs/${APP_NAME}");
        this.putProperty(config, "FILE_LOG_ROLLING", "solon.logging.appender.file.rolling", "${FILE_LOG_NAME}_%d{yyyy-MM-dd}_%i${FILE_LOG_EXTENSION}");
        this.putProperty(config, "FILE_LOG_PATTERN", "solon.logging.appender.file.pattern", "%-5level %d{yyyy-MM-dd HH:mm:ss.SSS} [-%t][*%X{traceId}]%tags[%logger{20}]: %n%msg%n");
        this.putProperty(config, "FILE_LOG_LEVEL", "solon.logging.appender.file.level", "INFO");
        this.putProperty(config, "FILE_LOG_MAX_HISTORY", "solon.logging.appender.file.maxHistory", "7");
        this.putProperty(config, "FILE_LOG_MAX_FILE_SIZE", "solon.logging.appender.file.maxFileSize", "10 MB");
        this.putProperty(config, "FILE_LOG_TOTAL_SIZE_CAP", "solon.logging.appender.file.totalSizeCap", "0");
        this.putProperty(config, "LOGGER_ROOT_LEVEL", "solon.logging.logger.root.level", "TRACE");
    }

    private void putProperty(LogbackConfigurator config, String name, String source, String defaultValue) {
        config.getContext().putProperty(name, this.resolveSolonProp(config, source, defaultValue));
    }

    private Appender<ILoggingEvent> solonAppender(LogbackConfigurator config) {
        SolonAppender appender = new SolonAppender();
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(this.resolve(config, "TRACE"));
        filter.start();
        appender.addFilter((Filter)filter);
        config.appender("SOLON", (Appender<?>)appender);
        return appender;
    }

    private Appender<ILoggingEvent> consoleAppender(LogbackConfigurator config) {
        ConsoleAppender appender = new ConsoleAppender();
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(this.resolve(config, "${CONSOLE_LOG_LEVEL}"));
        filter.start();
        appender.addFilter((Filter)filter);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern(this.resolve(config, "${CONSOLE_LOG_PATTERN}"));
        config.start((LifeCycle)encoder);
        appender.setEncoder((Encoder)encoder);
        config.appender("CONSOLE", (Appender<?>)appender);
        return appender;
    }

    private Appender<ILoggingEvent> fileAppender(LogbackConfigurator config) {
        RollingFileAppender appender = new RollingFileAppender();
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(this.resolve(config, "${FILE_LOG_LEVEL}"));
        filter.start();
        appender.addFilter((Filter)filter);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern(this.resolve(config, "${FILE_LOG_PATTERN}"));
        encoder.setCharset(this.resolveCharset(config, "UTF-8"));
        appender.setEncoder((Encoder)encoder);
        config.start((LifeCycle)encoder);
        appender.setFile(this.resolve(config, "${FILE_LOG_NAME}.log"));
        appender.setAppend(true);
        this.setRollingPolicy((RollingFileAppender<ILoggingEvent>)appender, config);
        config.appender("FILE", (Appender<?>)appender);
        return appender;
    }

    private void setRollingPolicy(RollingFileAppender<ILoggingEvent> appender, LogbackConfigurator config) {
        SizeAndTimeBasedRollingPolicy rollingPolicy = new SizeAndTimeBasedRollingPolicy();
        rollingPolicy.setContext((Context)config.getContext());
        rollingPolicy.setFileNamePattern(this.resolve(config, "${FILE_LOG_ROLLING}"));
        rollingPolicy.setMaxHistory(this.resolveInt(config, "${FILE_LOG_MAX_HISTORY}}"));
        rollingPolicy.setMaxFileSize(this.resolveFileSize(config, "${FILE_LOG_MAX_FILE_SIZE}"));
        rollingPolicy.setTotalSizeCap(this.resolveFileSize(config, "${FILE_LOG_TOTAL_SIZE_CAP}"));
        appender.setRollingPolicy((RollingPolicy)rollingPolicy);
        rollingPolicy.setParent(appender);
        rollingPolicy.setContext((Context)config.getContext());
        rollingPolicy.start();
    }

    private boolean resolveBoolean(LogbackConfigurator config, String val) {
        return Boolean.parseBoolean(this.resolve(config, val));
    }

    private int resolveInt(LogbackConfigurator config, String val) {
        return Integer.parseInt(this.resolve(config, val));
    }

    private FileSize resolveFileSize(LogbackConfigurator config, String val) {
        return FileSize.valueOf((String)this.resolve(config, val));
    }

    private Charset resolveCharset(LogbackConfigurator config, String val) {
        return Charset.forName(this.resolve(config, val));
    }

    private String resolveSolonProp(LogbackConfigurator config, String source, String defaultValue) {
        String val = Solon.cfg().getProperty(source);
        if (val == null) {
            val = defaultValue;
        }
        return this.resolve(config, val);
    }

    private String resolve(LogbackConfigurator config, String val) {
        try {
            return OptionHelper.substVars((String)val, (PropertyContainer)config.getContext());
        }
        catch (ScanException ex) {
            throw new RuntimeException(ex);
        }
    }
}

