/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.hotplug;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.noear.solon.Solon;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.PluginUtil;
import org.noear.solon.hotplug.PluginClassLoader;
import org.noear.solon.hotplug.PluginInfo;
import org.noear.solon.hotplug.PluginPackage;

public class PluginManager {
    static final Map<String, PluginInfo> pluginMap = new ConcurrentHashMap<String, PluginInfo>();

    public static Collection<PluginInfo> getPlugins() {
        return pluginMap.values();
    }

    public static void add(String name, File file) {
        pluginMap.computeIfAbsent(name, k -> new PluginInfo(name, file));
    }

    public static void remove(String name) {
        pluginMap.remove(name);
    }

    public static PluginPackage load(String name) {
        PluginInfo info = pluginMap.get(name);
        if (info == null) {
            throw new IllegalArgumentException("Addin does not exist: " + name);
        }
        if (info.getAddinPackage() == null) {
            info.setAddinPackage(PluginManager.loadJar(info.getFile()));
        }
        return info.getAddinPackage();
    }

    public static void unload(String name) {
        PluginInfo info = pluginMap.get(name);
        if (info == null) {
            throw new IllegalArgumentException("Addin does not exist: " + name);
        }
        if (info.getAddinPackage() == null) {
            return;
        }
        PluginManager.unloadJar(info.getAddinPackage());
        info.setAddinPackage(null);
    }

    public static void start(String name) {
        PluginInfo info = pluginMap.get(name);
        if (info == null) {
            throw new IllegalArgumentException("Addin does not exist: " + name);
        }
        if (info.getAddinPackage() == null) {
            info.setAddinPackage(PluginManager.loadJar(info.getFile()));
        }
        if (info.getStarted()) {
            return;
        }
        info.getAddinPackage().start();
    }

    public static void stop(String name) {
        PluginInfo info = pluginMap.get(name);
        if (info == null) {
            throw new IllegalArgumentException("Addin does not exist: " + name);
        }
        if (!info.getStarted()) {
            return;
        }
        if (info.getAddinPackage() != null) {
            info.getAddinPackage().prestop();
            info.getAddinPackage().stop();
        }
    }

    public static PluginPackage loadJar(File file) {
        try {
            URL url = file.toURI().toURL();
            PluginClassLoader classLoader = new PluginClassLoader((ClassLoader)AppClassLoader.global());
            classLoader.addJar(url);
            ArrayList<PluginEntity> plugins = new ArrayList<PluginEntity>();
            PluginUtil.scanPlugins((ClassLoader)((Object)classLoader), (String)url.toString(), plugins::add);
            return new PluginPackage(file, classLoader, plugins);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void unloadJar(PluginPackage pluginPackage) {
        try {
            pluginPackage.prestop();
            pluginPackage.stop();
            PluginClassLoader classLoader = pluginPackage.getClassLoader();
            classLoader.removeJar(pluginPackage.getFile());
            classLoader.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Props pops = Solon.cfg().getProp("solon.hotplug");
        if (pops.size() > 0) {
            pops.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (k instanceof String && v instanceof String) {
                    PluginManager.add((String)k, new File((String)v));
                }
            }));
        }
    }
}

