/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.integration;

import java.util.Collection;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.integration.properties.DiscoverProperties;

public class DiscoverLocator
implements LifecycleBean,
EventListener<Discovery> {
    private final AppContext appContext;
    private final DiscoverProperties discover;

    public DiscoverLocator(AppContext appContext, DiscoverProperties discover) {
        this.appContext = appContext;
        this.discover = discover;
    }

    public void start() {
        Collection serviceNames;
        if (Utils.isNotEmpty(this.discover.getIncludedServices())) {
            for (String name : this.discover.getIncludedServices()) {
                this.register(name);
            }
        }
        if (Utils.isNotEmpty((Collection)(serviceNames = CloudClient.discovery().findServices("")))) {
            for (String name : serviceNames) {
                this.register(name);
            }
        }
    }

    public void onEvent(Discovery discovery) throws Throwable {
        this.syncStatus(discovery);
    }

    protected void register(String serviceName) {
        if (this.discover.getExcludedServices().contains(serviceName)) {
            return;
        }
        Object tmp = this.appContext.getBean(serviceName);
        if (tmp == null) {
            DocDocket docDocket = new DocDocket();
            docDocket.groupName(serviceName);
            docDocket.upstream(serviceName, serviceName, this.discover.getUriPattern().replace("{service}", serviceName));
            if (Utils.isNotEmpty(this.discover.getBasicAuth())) {
                docDocket.basicAuth().putAll(this.discover.getBasicAuth());
            }
            BeanWrap beanWrap = this.appContext.wrap(serviceName, (Object)docDocket);
            this.appContext.putWrap(serviceName, beanWrap);
            LoadBalance.get((String)serviceName);
        }
    }

    protected void syncStatus(Discovery discovery) throws Throwable {
        if (!this.discover.isSyncStatus()) {
            return;
        }
        Object tmp = this.appContext.getBean(discovery.service());
        if (tmp instanceof DocDocket) {
            DocDocket docDocket = (DocDocket)tmp;
            docDocket.enable(discovery.clusterSize() > 0);
        }
    }
}

