/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.integration;

import java.util.Collection;
import java.util.Map;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.docs.DocDocket;

public class DiscoveryEventListener
implements EventListener<Discovery>,
Lifecycle {
    private final AppContext appContext;
    private final String uriPattern;
    private final boolean syncStatus;
    private final Collection<String> excluded;
    private final Collection<String> included;
    private final Map<String, String> basicAuth;

    public DiscoveryEventListener(AppContext appContext, String uriPattern) {
        this.appContext = appContext;
        this.uriPattern = uriPattern;
        this.syncStatus = appContext.cfg().getBool("solon.docs.discover.syncStatus", false);
        this.excluded = appContext.cfg().getList("solon.docs.discover.excluded");
        this.included = appContext.cfg().getList("solon.docs.discover.included");
        this.basicAuth = appContext.cfg().getMap("solon.docs.discover.basicAuth");
    }

    public void start() {
        if (this.included.size() > 0) {
            for (String tmp : this.included) {
                String[] ss = tmp.split(":");
                if (ss.length > 1) {
                    LoadBalance.get((String)ss[0], (String)ss[1]);
                    continue;
                }
                LoadBalance.get((String)ss[0]);
            }
        }
    }

    public void onEvent(Discovery discovery) throws Throwable {
        if (this.excluded.contains(discovery.service())) {
            return;
        }
        Object tmp = this.appContext.getBean(discovery.service());
        if (tmp == null) {
            DocDocket docDocket = new DocDocket();
            docDocket.groupName(discovery.service());
            docDocket.upstream(discovery.service(), discovery.service(), this.uriPattern.replace("{service}", discovery.service()));
            if (this.basicAuth.size() > 0) {
                docDocket.basicAuth().putAll(this.basicAuth);
            }
            if (this.syncStatus) {
                docDocket.enable(discovery.clusterSize() > 0);
            }
            BeanWrap beanWrap = this.appContext.wrap(discovery.service(), (Object)docDocket);
            this.appContext.putWrap(discovery.service(), beanWrap);
        } else if (this.syncStatus && tmp instanceof DocDocket) {
            DocDocket docDocket = (DocDocket)tmp;
            docDocket.enable(discovery.clusterSize() > 0);
        }
    }
}

