/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.integration;

import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.integration.DiscoveryEventListener;

public class XPluginImpl
implements Plugin {
    public static final String SOLON_DOCS_ROUTES = "solon.docs.routes";
    public static final String SOLON_DOCS_DISCOVER_URIPATTERN = "solon.docs.discover.uriPattern";
    public static final String SOLON_DOCS_DISCOVER_SYNCSTATUS = "solon.docs.discover.syncStatus";
    public static final String SOLON_DOCS_DISCOVER_EXCLUDED = "solon.docs.discover.excluded";
    public static final String SOLON_DOCS_DISCOVER_INCLUDED = "solon.docs.discover.included";
    public static final String SOLON_DOCS_DISCOVER_BASICAUTH = "solon.docs.discover.basicAuth";

    public void start(AppContext context) throws Throwable {
        String discover_pathPattern;
        Map docMap = context.cfg().getGroupedProp(SOLON_DOCS_ROUTES);
        if (docMap.size() > 0) {
            for (Map.Entry kv : docMap.entrySet()) {
                DocDocket docDocket = (DocDocket)((Props)kv.getValue()).getBean(DocDocket.class);
                BeanWrap docBw = context.wrap((String)kv.getKey(), (Object)docDocket);
                context.putWrap((String)kv.getKey(), docBw);
                context.wrapPublish(docBw);
            }
        }
        if (Utils.isNotEmpty((String)(discover_pathPattern = Solon.cfg().get(SOLON_DOCS_DISCOVER_URIPATTERN)))) {
            if (ClassUtil.hasClass(() -> Discovery.class)) {
                DiscoveryEventListener eventListener = new DiscoveryEventListener(context, discover_pathPattern);
                EventBus.subscribe(Discovery.class, (EventListener)eventListener);
                eventListener.start();
            } else {
                LogUtil.global().warn("Solon docs discover: missing solon cloud discovery");
            }
        }
    }
}

