/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi2;

import io.swagger.models.Swagger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.models.ApiGroupResource;
import org.noear.solon.docs.openapi2.JacksonSerializer;
import org.noear.solon.docs.openapi2.OpenApi2Builder;
import org.noear.solon.docs.util.BasicAuthUtil;
import org.noear.solon.exception.SolonException;

public class OpenApi2Utils {
    public static String getApiGroupResourceJson() throws IOException {
        return OpenApi2Utils.getApiGroupResourceJson("/swagger/v2");
    }

    public static String getApiGroupResourceJson(String resourceUri) throws IOException {
        List list = Solon.context().getWrapsOfType(DocDocket.class);
        List resourceList = list.stream().filter(bw -> Utils.isNotEmpty((String)bw.name())).map(bw -> {
            DocDocket docDocket = (DocDocket)bw.raw();
            if (docDocket.isEnable()) {
                String group = bw.name();
                String groupName = docDocket.groupName();
                String url = resourceUri + "?group=" + group;
                if (docDocket.upstream() == null) {
                    return new ApiGroupResource(groupName, docDocket.version(), url, "");
                }
                return new ApiGroupResource(groupName, docDocket.version(), url, docDocket.upstream().getContextPath());
            }
            return null;
        }).filter(r -> r != null).collect(Collectors.toList());
        return JacksonSerializer.getInstance().serialize(resourceList);
    }

    public static String getApiJson(Context ctx, String group) throws IOException {
        String targetAddr;
        DocDocket docket = (DocDocket)Solon.context().getBean(group);
        if (docket == null) {
            return null;
        }
        if (!BasicAuthUtil.basicAuth((Context)ctx, (DocDocket)docket)) {
            BasicAuthUtil.response401((Context)ctx);
            return null;
        }
        if (!docket.globalResponseCodes().containsKey(200)) {
            docket.globalResponseCodes().put(200, "");
        }
        if (docket.upstream() == null) {
            Swagger swagger = new OpenApi2Builder(docket).build();
            if (docket.serializer() == null) {
                return JacksonSerializer.getInstance().serialize(swagger);
            }
            return (String)docket.serializer().serialize((Object)swagger);
        }
        URI upstreamTarget = docket.upstream().getTarget();
        if ("lb".equals(upstreamTarget.getScheme())) {
            targetAddr = LoadBalance.get((String)upstreamTarget.getHost()).getServer(upstreamTarget.getPort());
            if (targetAddr == null) {
                throw new SolonException("The target service does not exist (" + upstreamTarget + ")");
            }
        } else {
            targetAddr = docket.upstream().getTarget().toString();
        }
        String url = PathUtil.mergePath((String)targetAddr, (String)docket.upstream().getUri()).substring(1);
        return OpenApi2Utils.httpGet(url, docket);
    }

    public static String httpGet(String urlStr, DocDocket docket) throws IOException {
        Iterator iterator;
        HttpURLConnection connection = (HttpURLConnection)new URL(urlStr).openConnection();
        if (docket.basicAuth().size() > 0 && (iterator = docket.basicAuth().entrySet().iterator()).hasNext()) {
            Map.Entry kv = iterator.next();
            String auth = BasicAuthUtil.base64EncodeToStr((String)((String)kv.getKey()), (String)((String)kv.getValue()));
            connection.setRequestProperty("Authorization", "Basic " + auth);
        }
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String inputLine;
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                String string = response.toString();
                return string;
            }
        }
        throw new SocketException("HTTP GET failed: " + responseCode);
    }
}

