/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.impl.CloudLoadBalanceFactory;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudBreakerService;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventService;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.cloud.service.CloudI18nService;
import org.noear.solon.cloud.service.CloudIdService;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.cloud.service.CloudListService;
import org.noear.solon.cloud.service.CloudLockService;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.solon.cloud.service.CloudMetricService;
import org.noear.solon.cloud.service.CloudTraceService;
import org.noear.solon.core.Signal;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.util.LogUtil;

public class CloudClient {
    public static CloudLoadBalanceFactory loadBalance() {
        return CloudManager.loadBalance();
    }

    public static CloudBreakerService breaker() {
        return CloudManager.breakerService();
    }

    public static CloudConfigService config() {
        return CloudManager.configService();
    }

    public static void configLoad(String group, String key) {
        if (CloudClient.config() == null) {
            return;
        }
        if (Utils.isNotEmpty((String)key)) {
            Config config = CloudClient.config().pull(group, key);
            if (config != null && Utils.isNotEmpty((String)config.value())) {
                Properties properties = config.toProps();
                Solon.cfg().loadAdd(properties);
            }
            CloudClient.config().attention(group, key, cfg -> {
                Properties properties = cfg.toProps();
                Solon.cfg().loadAdd(properties);
            });
        }
    }

    public static void configLoad(String groupKeySet) {
        if (CloudClient.config() == null) {
            return;
        }
        if (Utils.isNotEmpty((String)groupKeySet)) {
            String[] gkAry;
            for (String gkStr : gkAry = groupKeySet.split(",")) {
                String[] gk = null;
                gk = gkStr.contains("::") ? gkStr.split("::") : gkStr.split(":");
                if (gk.length == 2) {
                    CloudClient.configLoad(gk[0], gk[1]);
                    continue;
                }
                CloudClient.configLoad(Solon.cfg().appGroup(), gk[0]);
            }
        }
    }

    public static CloudDiscoveryService discovery() {
        return CloudManager.discoveryService();
    }

    public static void discoveryPush() {
        if (CloudClient.discovery() == null) {
            return;
        }
        if (Utils.isEmpty((String)Solon.cfg().appName())) {
            return;
        }
        Solon.app().onEvent(AppLoadEndEvent.class, event -> {
            for (Signal signal : Solon.app().signals()) {
                Instance instance = Instance.localNew(signal);
                CloudClient.discovery().register(Solon.cfg().appGroup(), instance);
                LogUtil.global().info("Cloud: Service registered " + instance.service() + "@" + instance.uri());
            }
        });
        Solon.app().onEvent(Signal.class, signal -> {
            Instance instance = Instance.localNew(signal);
            CloudClient.discovery().register(Solon.cfg().appGroup(), instance);
            LogUtil.global().info("Cloud: Service registered " + instance.service() + "@" + instance.uri());
        });
    }

    public static CloudEventService event() {
        return CloudManager.eventService();
    }

    public static CloudLockService lock() {
        return CloudManager.lockService();
    }

    public static CloudLogService log() {
        return CloudManager.logService();
    }

    public static CloudTraceService trace() {
        return CloudManager.traceService();
    }

    public static CloudMetricService metric() {
        return CloudManager.metricService();
    }

    public static CloudListService list() {
        return CloudManager.listService();
    }

    public static CloudFileService file() {
        return CloudManager.fileService();
    }

    public static CloudI18nService i18n() {
        return CloudManager.i18nService();
    }

    public static CloudIdService idService(String group, String service) {
        return CloudManager.idServiceFactory().create(group, service);
    }

    public static CloudIdService id() {
        return CloudManager.idServiceDef();
    }

    public static CloudJobService job() {
        return CloudManager.jobService();
    }
}

