/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.core.LoadBalance;

public class CloudLoadBalance
implements LoadBalance {
    private String service;
    private String group;
    private Discovery discovery;
    private int index = 0;
    private static int indexMax = 99999999;

    public CloudLoadBalance(String group, String service) {
        this.service = service;
        this.group = group;
        if (CloudClient.discovery() != null) {
            this.discovery = CloudClient.discovery().find(group, service);
            CloudClient.discovery().attention(group, service, d1 -> {
                this.discovery = d1;
            });
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getService() {
        return this.service;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public String getServer() {
        if (this.discovery == null) {
            return null;
        }
        if (Utils.isNotEmpty((String)this.discovery.agent())) {
            return this.discovery.agent();
        }
        int count = this.discovery.clusterSize();
        if (count == 0) {
            return null;
        }
        if (this.index > indexMax) {
            this.index = 0;
        }
        Instance instance = this.discovery.instanceGet(this.index++ % count);
        return instance.uri();
    }
}

