/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.annotation.CloudConfig;
import org.noear.solon.cloud.annotation.CloudEvent;
import org.noear.solon.cloud.impl.CloudBeanInjector;
import org.noear.solon.cloud.impl.CloudLoadBalanceFactory;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.wrap.ClassWrap;

public class XPluginImp
implements Plugin {
    public void start(SolonApp app) {
        Aop.context().beanBuilderAdd(CloudConfig.class, (clz, bw, anno) -> {
            CloudConfigHandler handler = bw.raw() instanceof CloudConfigHandler ? (CloudConfigHandler)bw.raw() : cfg -> {
                Properties val0 = cfg.toProps();
                ClassWrap.get((Class)clz).fill(bw.raw(), val0::getProperty);
            };
            CloudManager.register(anno, handler);
            if (CloudClient.config() != null) {
                Config config = CloudClient.config().pull(anno.group(), anno.value());
                if (config != null) {
                    handler.handler(config);
                }
                CloudClient.config().attention(anno.group(), anno.value(), handler);
            }
        });
        Aop.context().beanBuilderAdd(CloudEvent.class, (clz, bw, anno) -> {
            if (bw.raw() instanceof CloudEventHandler) {
                CloudManager.register(anno, (CloudEventHandler)bw.raw());
                if (CloudClient.event() != null) {
                    CloudClient.event().attention(anno.level(), anno.group(), anno.value(), (CloudEventHandler)bw.raw());
                }
            }
        });
        Aop.context().beanInjectorAdd(CloudConfig.class, (BeanInjector)CloudBeanInjector.instance);
        if (CloudClient.discovery() != null) {
            Bridge.upstreamFactorySet((LoadBalance.Factory)CloudLoadBalanceFactory.instance);
        }
    }

    public void stop() throws Throwable {
        if (Solon.cfg().isDriftMode() && CloudClient.discovery() != null && Utils.isNotEmpty((String)Solon.cfg().appName())) {
            CloudClient.discovery().deregister(Solon.cfg().appGroup(), Instance.local());
        }
    }
}

