/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.annotation.CloudConfig;
import org.noear.solon.cloud.annotation.CloudEvent;
import org.noear.solon.cloud.impl.CloudBeanInjector;
import org.noear.solon.cloud.impl.CloudLoadBalanceFactory;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.model.Node;
import org.noear.solon.cloud.utils.LocalUtils;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.wrap.ClassWrap;

public class XPluginImp
implements Plugin {
    public void start(SolonApp app) {
        Aop.context().beanBuilderAdd(CloudConfig.class, (clz, bw, anno) -> {
            if (bw.raw() instanceof CloudConfigHandler) {
                CloudManager.register(anno, (CloudConfigHandler)bw.raw());
            } else {
                CloudManager.register(anno, new CloudConfigHandler(){

                    @Override
                    public void handler(Config cfg) {
                        Properties val0 = cfg.toProps();
                        ClassWrap.get((Class)clz).fill(bw.raw(), val0::getProperty);
                    }
                });
            }
        });
        Aop.context().beanBuilderAdd(CloudEvent.class, (clz, bw, anno) -> {
            if (bw.raw() instanceof CloudEventHandler) {
                CloudManager.register(anno, (CloudEventHandler)bw.raw());
            }
        });
        Aop.context().beanInjectorAdd(CloudConfig.class, (BeanInjector)CloudBeanInjector.instance);
        Aop.context().beanOnloaded(() -> {
            if (CloudClient.config() != null) {
                CloudManager.configHandlerMap.forEach((anno, handler) -> {
                    Config config = CloudClient.config().get(anno.group(), anno.key());
                    if (config != null) {
                        handler.handler(config);
                    }
                    CloudClient.config().attention(anno.group(), anno.key(), (CloudConfigHandler)handler);
                });
            }
            if (CloudClient.event() != null) {
                CloudManager.eventHandlerMap.forEach((anno, handler) -> CloudClient.event().attention(anno.topic(), (CloudEventHandler)handler));
            }
        });
        if (CloudClient.discovery() != null) {
            Bridge.upstreamFactorySet((LoadBalance.Factory)CloudLoadBalanceFactory.instance);
        }
    }

    public void stop() throws Throwable {
        if (Solon.cfg().isDriftMode() && CloudClient.discovery() != null && Utils.isNotEmpty((String)Solon.cfg().appName())) {
            Node node = new Node();
            node.service = Solon.cfg().appName();
            node.ip = LocalUtils.getLocalAddress();
            node.port = Solon.global().port();
            node.protocol = "http";
            CloudClient.discovery().deregister(node);
        }
    }
}

