/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.exchange;

import io.vertx.core.buffer.Buffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.util.KeyValues;

public class ExNewResponse {
    private int status = 200;
    private Map<String, KeyValues<String>> headers = new LinkedHashMap<String, KeyValues<String>>();
    private Buffer body;

    public void status(int code) {
        this.status = code;
    }

    private KeyValues<String> headerHolder(String key) {
        return this.headers.computeIfAbsent(key, k -> new KeyValues(key));
    }

    public ExNewResponse header(String key, String ... values) {
        this.headerHolder(key).setValues((Object[])values);
        return this;
    }

    public ExNewResponse header(String key, List<String> values) {
        this.headerHolder(key).setValues((Object[])values.toArray(new String[values.size()]));
        return this;
    }

    public ExNewResponse headerAdd(String key, String value) {
        this.headerHolder(key).addValue((Object)value);
        return this;
    }

    public ExNewResponse headerRemove(String ... keys) {
        for (String key : keys) {
            this.headers.remove(key);
        }
        return this;
    }

    public ExNewResponse redirect(int code, String url) {
        this.status(code);
        this.header("Location", url);
        return this;
    }

    public ExNewResponse body(Buffer body) {
        this.body = body;
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, KeyValues<String>> getHeaders() {
        return this.headers;
    }

    public Buffer getBody() {
        return this.body;
    }
}

