/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.redisson;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cache.redisson.RedissonBuilder;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.Serializer;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonCacheService
implements CacheService {
    static final Logger log = LoggerFactory.getLogger(RedissonCacheService.class);
    protected String _cacheKeyHead;
    protected int _defaultSeconds;
    protected Serializer<String> _serializer = null;
    protected boolean _enableMd5key = true;
    protected final RedissonClient client;

    public RedissonCacheService enableMd5key(boolean enable) {
        this._enableMd5key = enable;
        return this;
    }

    public RedissonCacheService serializer(Serializer<String> serializer) {
        if (serializer != null) {
            this._serializer = serializer;
        }
        return this;
    }

    public RedissonCacheService(RedissonClient client, int defSeconds) {
        this(client, null, defSeconds);
    }

    public RedissonCacheService(RedissonClient client, String keyHeader, int defSeconds) {
        this.client = client;
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
    }

    public RedissonCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public RedissonCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str;
        if (defSeconds == 0 && Utils.isNotEmpty((String)(defSeconds_str = prop.getProperty("defSeconds")))) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        this.client = RedissonBuilder.build(prop);
    }

    public RedissonClient client() {
        return this.client;
    }

    public void store(String key, Object obj, int seconds) {
        if (obj == null) {
            return;
        }
        if (seconds < 1) {
            seconds = this._defaultSeconds;
        }
        String newKey = this.newKey(key);
        try {
            if (this._serializer == null) {
                this.client.getBucket(newKey).set(obj, (long)seconds, TimeUnit.SECONDS);
            } else {
                obj = this._serializer.serialize(obj);
                this.client.getBucket(newKey, (Codec)StringCodec.INSTANCE).set(obj, (long)seconds, TimeUnit.SECONDS);
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public <T> T get(String key, Class<T> clz) {
        String newKey = this.newKey(key);
        try {
            if (this._serializer == null) {
                return (T)this.client.getBucket(newKey).get();
            }
            Object obj = this.client.getBucket(newKey, (Codec)StringCodec.INSTANCE).get();
            if (obj == null) {
                return null;
            }
            obj = this._serializer.deserialize((Object)((String)obj), clz);
            return (T)obj;
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
            return null;
        }
    }

    public void remove(String key) {
        String newKey = this.newKey(key);
        if (this._serializer == null) {
            this.client.getBucket(newKey).delete();
        } else {
            this.client.getBucket(newKey, (Codec)StringCodec.INSTANCE).delete();
        }
    }

    protected String newKey(String key) {
        if (this._enableMd5key) {
            return this._cacheKeyHead + ":" + Utils.md5((String)key);
        }
        return this._cacheKeyHead + ":" + key;
    }
}

