/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.jedis;

import java.util.Base64;
import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cache.jedis.RedisX;
import org.noear.solon.cache.jedis.SerializationUtils;
import org.noear.solon.core.cache.CacheService;
import org.noear.solon.core.event.EventBus;

public class RedisCacheService
implements CacheService {
    private String _cacheKeyHead;
    private int _defaultSeconds;
    private RedisX _cache = null;

    public RedisCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public RedisCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str = prop.getProperty("defSeconds");
        String server = prop.getProperty("server");
        String password = prop.getProperty("password");
        String db_str = prop.getProperty("db");
        String maxTotaol_str = prop.getProperty("maxTotaol");
        String maxWaitMillis_str = prop.getProperty("maxWaitMillis");
        if (defSeconds == 0 && !Utils.isEmpty((String)defSeconds_str)) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        int db = 0;
        int maxTotaol = 200;
        long maxWaitMillis = 3000L;
        if (Utils.isNotEmpty((String)db_str)) {
            db = Integer.parseInt(db_str);
        }
        if (Utils.isNotEmpty((String)maxTotaol_str)) {
            maxTotaol = Integer.parseInt(maxTotaol_str);
        }
        if (Utils.isNotEmpty((String)maxWaitMillis_str)) {
            maxWaitMillis = Integer.parseInt(maxWaitMillis_str);
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        if (this._defaultSeconds < 3) {
            this._defaultSeconds = 30;
        }
        if (Utils.isEmpty((String)this._cacheKeyHead)) {
            this._cacheKeyHead = Solon.cfg().appName();
        }
        this._cache = new RedisX(server, password, db, maxTotaol, maxWaitMillis);
    }

    public void store(String key, Object obj, int seconds) {
        if (obj == null) {
            return;
        }
        if (this._cache != null) {
            String newKey = this.newKey(key);
            try {
                byte[] tmp = SerializationUtils.serialize(obj);
                String val = Base64.getEncoder().encodeToString(tmp);
                if (seconds > 0) {
                    this._cache.open0(ru -> ru.key(newKey).expire(seconds).set(val));
                } else {
                    this._cache.open0(ru -> ru.key(newKey).expire(this._defaultSeconds).set(val));
                }
            }
            catch (Exception ex) {
                EventBus.push((Object)ex);
            }
        }
    }

    public Object get(String key) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            String val = this._cache.open1(ru -> ru.key(newKey).get());
            if (val == null) {
                return null;
            }
            try {
                byte[] bytes = Base64.getDecoder().decode(val);
                return SerializationUtils.deserialize(bytes);
            }
            catch (Exception ex) {
                EventBus.push((Object)ex);
                return null;
            }
        }
        return null;
    }

    public void remove(String key) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            this._cache.open0(ru -> ru.key(newKey).delete());
        }
    }

    private String newKey(String key) {
        return this._cacheKeyHead + "$" + Utils.md5((String)key);
    }
}

