/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.reflect.Type;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.data.cache.CacheService;

public class CaffeineCacheService
implements CacheService {
    private String _cacheKeyHead;
    private int _defaultSeconds;
    private final Cache<String, Object> client;

    public CaffeineCacheService(Cache<String, Object> client, int defSeconds) {
        this(client, null, defSeconds);
    }

    public CaffeineCacheService(Cache<String, Object> client, String keyHeader, int defSeconds) {
        this.client = client;
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
    }

    public CaffeineCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public CaffeineCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str = prop.getProperty("defSeconds");
        if (defSeconds == 0 && Utils.isNotEmpty((String)defSeconds_str)) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        this.client = Caffeine.newBuilder().expireAfterWrite((long)this._defaultSeconds, TimeUnit.SECONDS).build();
    }

    public void store(String key, Object obj, int seconds) {
        this.client.put((Object)key, obj);
    }

    public void remove(String key) {
        this.client.put((Object)key, null);
    }

    public <T> T get(String key, Type type) {
        return (T)this.client.getIfPresent((Object)key);
    }

    public <T> T getOrStore(String key, Type type, int seconds, Supplier<T> supplier) {
        return (T)this.client.get((Object)key, k -> supplier.get());
    }
}

