/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.noear.solon.boot.websocket.netty.WebSocketImpl;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketRouter;

public class WsServerHandler
extends SimpleChannelInboundHandler<Object> {
    public static final AttributeKey<String> ResourceDescriptorKey = AttributeKey.valueOf((String)"ResourceDescriptor");
    public static final AttributeKey<WebSocketServerHandshaker> HandshakerKey = AttributeKey.valueOf((String)"Handshaker");
    public static final AttributeKey<WebSocketImpl> SessionKey = AttributeKey.valueOf((String)"Session");
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        if (!req.decoderResult().isSuccess() || !"websocket".equals(req.headers().get("Upgrade"))) {
            this.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        String url = "ws://" + req.headers().get((CharSequence)HttpHeaderNames.HOST) + req.uri();
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(url, null, false);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            handshaker.handshake(ctx.channel(), req);
            ctx.attr(HandshakerKey).set((Object)handshaker);
            ctx.attr(ResourceDescriptorKey).set((Object)req.uri());
            WebSocketImpl webSocket = new WebSocketImpl(ctx);
            ctx.attr(SessionKey).set((Object)webSocket);
            this.webSocketRouter.getListener().onOpen((WebSocket)webSocket);
        }
    }

    public void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof CloseWebSocketFrame) {
            WebSocketServerHandshaker handshaker = (WebSocketServerHandshaker)ctx.attr(HandshakerKey).get();
            if (handshaker != null) {
                handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            }
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (frame instanceof TextWebSocketFrame) {
            WebSocket webSocket = (WebSocket)ctx.attr(SessionKey).get();
            String msgTxt = ((TextWebSocketFrame)frame).text();
            this.webSocketRouter.getListener().onMessage(webSocket, msgTxt);
            return;
        }
        if (frame instanceof BinaryWebSocketFrame) {
            WebSocket webSocket = (WebSocket)ctx.attr(SessionKey).get();
            byte[] msgBytes = frame.content().array();
            this.webSocketRouter.getListener().onMessage(webSocket, ByteBuffer.wrap(msgBytes));
            return;
        }
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse resp) {
        if (resp.status().code() != 200) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)resp.status().toString(), (Charset)CharsetUtil.UTF_8);
            resp.content().writeBytes(buf);
            buf.release();
            HttpUtil.setContentLength((HttpMessage)resp, (long)resp.content().readableBytes());
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)resp);
        if (!HttpUtil.isKeepAlive((HttpMessage)resp) || resp.status().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        WebSocketImpl webSocket = (WebSocketImpl)((Object)ctx.attr(SessionKey).get());
        if (webSocket.isClosed()) {
            return;
        }
        webSocket.close();
        this.webSocketRouter.getListener().onClose((WebSocket)webSocket);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        WebSocket webSocket = (WebSocket)ctx.attr(SessionKey).get();
        this.webSocketRouter.getListener().onError(webSocket, cause);
        ctx.close();
    }
}

