/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.websocket.netty.WsServerHandler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.ProtocolManager;
import org.noear.solon.socketd.SessionBase;

public class _SocketServerSession
extends SessionBase {
    public static final Map<ChannelHandlerContext, Session> sessions = new HashMap<ChannelHandlerContext, Session>();
    private final ChannelHandlerContext real;
    private final String _sessionId = Utils.guid();
    private URI _uri;
    private String _path;
    static AttributeKey AttachmentKey = AttributeKey.valueOf((String)"Attachment");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(ChannelHandlerContext real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            ChannelHandlerContext channelHandlerContext = real;
            synchronized (channelHandlerContext) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketServerSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(ChannelHandlerContext real) {
        sessions.remove(real);
    }

    public _SocketServerSession(ChannelHandlerContext real) {
        this.real = real;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.WEBSOCKET;
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create((String)this.real.attr(WsServerHandler.ResourceDescriptorKey).get());
        }
        return this._uri;
    }

    public String path() {
        if (this._path == null) {
            this._path = this.uri().getPath();
        }
        return this._path;
    }

    public void sendAsync(Message message) {
        this.send(message);
    }

    public void sendAsync(String message) {
        this.send(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String message) {
        _SocketServerSession _SocketServerSession2 = this;
        synchronized (_SocketServerSession2) {
            if (Solon.app().enableWebSocketD()) {
                ByteBuffer buf = ProtocolManager.encode((Message)Message.wrap((String)message));
                this.real.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)buf)));
            } else {
                this.real.writeAndFlush((Object)new TextWebSocketFrame(message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) {
        super.send(message);
        _SocketServerSession _SocketServerSession2 = this;
        synchronized (_SocketServerSession2) {
            if (Solon.app().enableWebSocketD()) {
                ByteBuffer buf = ProtocolManager.encode((Message)message);
                this.real.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)buf)));
            } else if (message.isString()) {
                this.real.writeAndFlush((Object)new TextWebSocketFrame(message.bodyAsString()));
            } else {
                byte[] bytes = message.body();
                this.real.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])bytes)));
            }
        }
    }

    public void close() throws IOException {
        if (this.real == null) {
            return;
        }
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        if (this.real == null) {
            return false;
        }
        return this.real.channel().isOpen();
    }

    public boolean isSecure() {
        return false;
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.real.channel().remoteAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.real.channel().localAddress();
    }

    public void setAttachment(Object obj) {
        this.real.attr(AttachmentKey).set(obj);
    }

    public <T> T getAttachment() {
        return (T)this.real.attr(AttachmentKey).get();
    }

    public Collection<Session> getOpenSessions() {
        return Collections.unmodifiableCollection(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketServerSession that = (_SocketServerSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

