/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.stream.ChunkedWriteHandler;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.prop.impl.WebSocketServerProps;
import org.noear.solon.boot.websocket.netty.WsServerHandler;

public class WsServer
implements ServerLifecycle {
    ChannelFuture _server;
    WebSocketServerProps _props;

    public WsServer(WebSocketServerProps props) {
        this._props = props;
    }

    public void start(String host, int port) throws Throwable {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(this._props.getCoreThreads());
        NioEventLoopGroup workGroup = new NioEventLoopGroup(this._props.getMaxThreads(false));
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                    pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    pipeline.addLast(new ChannelHandler[]{new WsServerHandler()});
                }
            });
            this._server = Utils.isEmpty((String)host) ? bootstrap.bind(port).await() : bootstrap.bind(host, port).await();
        }
        catch (RuntimeException e) {
            bossGroup.shutdownGracefully();
            workGroup.shutdownGracefully();
            throw e;
        }
        catch (Throwable e) {
            bossGroup.shutdownGracefully();
            workGroup.shutdownGracefully();
            throw new IllegalStateException(e);
        }
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.channel().close();
        this._server = null;
    }
}

